/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ADSContextHelper;
import org.opends.admin.ads.ServerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADSContext {
    private static final Logger LOG = Logger.getLogger(ADSContext.class.getName());
    public static final String GLOBAL_ADMIN_UID = "admin";
    private static HashMap<String, ServerProperty> nameToServerProperty = null;
    private static final Set<ServerProperty> MULTIVALUED_SERVER_PROPERTIES = new HashSet<ServerProperty>();
    public static final String ALL_SERVERGROUP_NAME = "all-servers";
    private static final Set<ServerGroupProperty> MULTIVALUED_SERVER_GROUP_PROPERTIES;
    private static HashMap<String, AdministratorProperty> nameToAdminUSerProperty;
    private final InitialLdapContext dirContext;
    private String instanceKeyCertificate = null;

    public static ServerProperty getServerPropFromName(String name) {
        if (nameToServerProperty == null) {
            nameToServerProperty = new HashMap();
            for (ServerProperty s : ServerProperty.values()) {
                nameToServerProperty.put(s.getAttributeName(), s);
            }
        }
        return nameToServerProperty.get(name);
    }

    public static AdministratorProperty getAdminUSerPropFromName(String name) {
        if (nameToAdminUSerProperty == null) {
            nameToAdminUSerProperty = new HashMap();
            for (AdministratorProperty u : AdministratorProperty.values()) {
                nameToAdminUSerProperty.put(u.getAttributeName(), u);
            }
        }
        return nameToAdminUSerProperty.get(name);
    }

    public ADSContext(InitialLdapContext dirContext) {
        this.dirContext = dirContext;
    }

    public InitialLdapContext getDirContext() {
        return this.dirContext;
    }

    public void registerServer(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerProperties(serverProperties);
        BasicAttributes attrs = ADSContext.makeAttrsFromServerProperties(serverProperties);
        try {
            DirContext ctx = this.dirContext.createSubcontext(dn, (Attributes)attrs);
            ctx.close();
        }
        catch (NameAlreadyBoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void updateServer(Map<ServerProperty, Object> serverProperties, String newServerId) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerProperties(serverProperties);
        try {
            if (newServerId != null) {
                HashMap<ServerProperty, Object> newServerProps = new HashMap<ServerProperty, Object>(serverProperties);
                newServerProps.put(ServerProperty.ID, newServerId);
                LdapName newDn = ADSContext.makeDNFromServerProperties(newServerProps);
                this.dirContext.rename(dn, newDn);
                dn = newDn;
                serverProperties.put(ServerProperty.ID, newServerId);
            }
            BasicAttributes attrs = ADSContext.makeAttrsFromServerProperties(serverProperties);
            this.dirContext.modifyAttributes(dn, 2, (Attributes)attrs);
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void unregisterServer(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerProperties(serverProperties);
        try {
            this.dirContext.destroySubcontext(dn);
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public boolean isServerAlreadyRegistered(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerProperties(serverProperties);
        return this.isExistingEntry(dn);
    }

    public boolean isAdministratorAlreadyRegistered(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromAdministratorProperties(adminProperties);
        return this.isExistingEntry(dn);
    }

    public int registerOrUpdateServer(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        int result = 0;
        try {
            this.registerServer(serverProperties);
        }
        catch (ADSContextException x) {
            if (x.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                this.updateServer(serverProperties, null);
                result = 1;
            }
            throw x;
        }
        return result;
    }

    public Set<String> getServerGroupMemberList(String serverGroupId) throws ADSContextException {
        LdapName dn = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(serverGroupId) + "," + ADSContext.getServerGroupContainerDN());
        HashSet<String> result = new HashSet<String>();
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            NamingEnumeration<SearchResult> srs = this.getDirContext().search((Name)dn, "(objectclass=*)", sc);
            if (!srs.hasMore()) {
                return result;
            }
            Attributes attrs = srs.next().getAttributes();
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMore()) {
                Attribute attr = ne.next();
                String attrID = attr.getID();
                if (!attrID.toLowerCase().equals(ServerGroupProperty.MEMBERS.getAttributeName().toLowerCase())) continue;
                NamingEnumeration<?> ae = attr.getAll();
                while (ae.hasMore()) {
                    result.add((String)ae.next());
                }
                break;
            }
        }
        catch (NameNotFoundException x) {
            result = new HashSet();
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    public Set<Map<ServerProperty, Object>> readServerRegistry() throws ADSContextException {
        HashSet<Map<ServerProperty, Object>> result = new HashSet<Map<ServerProperty, Object>>();
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(1);
            NamingEnumeration<SearchResult> ne = this.dirContext.search(ADSContext.getServerContainerDN(), "(objectclass=*)", sc);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Map<ServerProperty, Object> properties = this.makePropertiesFromServerAttrs(sr.getAttributes());
                result.add(properties);
            }
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    public void createServerGroup(Map<ServerGroupProperty, Object> serverGroupProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerGroupProperties(serverGroupProperties);
        BasicAttributes attrs = ADSContext.makeAttrsFromServerGroupProperties(serverGroupProperties);
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("groupOfUniqueNames");
        attrs.put(oc);
        try {
            DirContext ctx = this.dirContext.createSubcontext(dn, (Attributes)attrs);
            ctx.close();
        }
        catch (NameAlreadyBoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL, (Throwable)x);
        }
    }

    public void updateServerGroup(String groupID, Map<ServerGroupProperty, Object> serverGroupProperties) throws ADSContextException {
        LdapName dn = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(groupID) + "," + ADSContext.getServerGroupContainerDN());
        try {
            if (serverGroupProperties.containsKey((Object)ServerGroupProperty.UID)) {
                String newGroupId = serverGroupProperties.get((Object)ServerGroupProperty.UID).toString();
                if (!newGroupId.equals(groupID)) {
                    LdapName newDN = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(newGroupId) + "," + ADSContext.getServerGroupContainerDN());
                    this.dirContext.rename(dn, newDN);
                    dn = newDN;
                }
                serverGroupProperties.remove((Object)ServerGroupProperty.UID);
            }
            if (serverGroupProperties.isEmpty()) {
                return;
            }
            BasicAttributes attrs = ADSContext.makeAttrsFromServerGroupProperties(serverGroupProperties);
            this.dirContext.modifyAttributes(dn, 2, (Attributes)attrs);
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NameAlreadyBoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void removeServerGroupProp(String groupID, Set<ServerGroupProperty> serverGroupProperties) throws ADSContextException {
        LdapName dn = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(groupID) + "," + ADSContext.getServerGroupContainerDN());
        BasicAttributes attrs = ADSContext.makeAttrsFromServerGroupProperties(serverGroupProperties);
        try {
            this.dirContext.modifyAttributes(dn, 3, (Attributes)attrs);
        }
        catch (NameAlreadyBoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void deleteServerGroup(Map<ServerGroupProperty, Object> serverGroupProperties) throws ADSContextException {
        LdapName dn = ADSContext.makeDNFromServerGroupProperties(serverGroupProperties);
        try {
            this.dirContext.destroySubcontext(dn);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public Set<Map<ServerGroupProperty, Object>> readServerGroupRegistry() throws ADSContextException {
        HashSet<Map<ServerGroupProperty, Object>> result = new HashSet<Map<ServerGroupProperty, Object>>();
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(1);
            NamingEnumeration<SearchResult> ne = this.dirContext.search(ADSContext.getServerGroupContainerDN(), "(objectclass=*)", sc);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Map<ServerGroupProperty, Object> properties = this.makePropertiesFromServerGroupAttrs(sr.getAttributes());
                result.add(properties);
            }
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    public Set<Map<AdministratorProperty, Object>> readAdministratorRegistry() throws ADSContextException {
        HashSet<Map<AdministratorProperty, Object>> result = new HashSet<Map<AdministratorProperty, Object>>();
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(1);
            NamingEnumeration<SearchResult> ne = this.dirContext.search(ADSContext.getAdministratorContainerDN(), "(objectclass=*)", sc);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Map<AdministratorProperty, Object> properties = this.makePropertiesFromAdministratorAttrs(ADSContext.getRdn(sr.getName()), sr.getAttributes());
                result.add(properties);
            }
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    public void createAdminData(String backendName) throws ADSContextException {
        this.createAdministrationSuffix(backendName);
        this.createTopContainerEntry();
        this.createAdministratorContainerEntry();
        this.createContainerEntry(ADSContext.getServerContainerDN());
        this.createContainerEntry(ADSContext.getServerGroupContainerDN());
        HashMap<ServerGroupProperty, Object> allServersGroupsMap = new HashMap<ServerGroupProperty, Object>();
        allServersGroupsMap.put(ServerGroupProperty.UID, ALL_SERVERGROUP_NAME);
        this.createServerGroup(allServersGroupsMap);
        this.createContainerEntry(ADSContext.getInstanceKeysContainerDN());
    }

    public void removeAdminData() throws ADSContextException {
        this.removeAdministrationSuffix();
    }

    public boolean hasAdminData() throws ADSContextException {
        return this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getAdministrationSuffixDN()));
    }

    public static String getAdministratorDN(String uid) {
        return "cn=" + Rdn.escapeValue(uid) + "," + ADSContext.getAdministratorContainerDN();
    }

    public void createAdministrator(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        LdapName dnCentralAdmin = ADSContext.makeDNFromAdministratorProperties(adminProperties);
        BasicAttributes attrs = ADSContext.makeAttrsFromAdministratorProperties(adminProperties, true);
        try {
            DirContext ctx = this.dirContext.createSubcontext(dnCentralAdmin, (Attributes)attrs);
            ctx.close();
        }
        catch (NameAlreadyBoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void deleteAdministrator(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        LdapName dnCentralAdmin = ADSContext.makeDNFromAdministratorProperties(adminProperties);
        try {
            this.dirContext.destroySubcontext(dnCentralAdmin);
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NotContextException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void updateAdministrator(Map<AdministratorProperty, Object> adminProperties, String newAdminUserId) throws ADSContextException {
        LdapName dnCentralAdmin = ADSContext.makeDNFromAdministratorProperties(adminProperties);
        try {
            if (newAdminUserId != null) {
                HashMap<AdministratorProperty, Object> newAdminUserProps = new HashMap<AdministratorProperty, Object>(adminProperties);
                newAdminUserProps.put(AdministratorProperty.UID, newAdminUserId);
                LdapName newDn = ADSContext.makeDNFromAdministratorProperties(newAdminUserProps);
                this.dirContext.rename(dnCentralAdmin, newDn);
                dnCentralAdmin = newDn;
                adminProperties.put(AdministratorProperty.UID, newAdminUserId);
            }
            if (adminProperties.size() > 1) {
                BasicAttributes attrs = ADSContext.makeAttrsFromAdministratorProperties(adminProperties, false);
                this.dirContext.modifyAttributes(dnCentralAdmin, 2, (Attributes)attrs);
            }
        }
        catch (NameNotFoundException x) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public static String getAdministrationSuffixDN() {
        return "cn=admin data";
    }

    private static LdapName makeDNFromHostnameAndPath(String hostname, String ipath) throws ADSContextException {
        String cnValue = Rdn.escapeValue(hostname + "@" + ipath);
        return ADSContext.nameFromDN("cn=" + cnValue + "," + ADSContext.getServerContainerDN());
    }

    private static LdapName makeDNFromServerUniqueId(String serverUniqueId) throws ADSContextException {
        String cnValue = Rdn.escapeValue(serverUniqueId);
        return ADSContext.nameFromDN("cn=" + cnValue + "," + ADSContext.getServerContainerDN());
    }

    private static LdapName makeDNFromServerGroupProperties(Map<ServerGroupProperty, Object> serverGroupProperties) throws ADSContextException {
        String serverGroupId = (String)serverGroupProperties.get((Object)ServerGroupProperty.UID);
        if (serverGroupId == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_NAME);
        }
        return ADSContext.nameFromDN("cn=" + Rdn.escapeValue(serverGroupId) + "," + ADSContext.getServerGroupContainerDN());
    }

    private static LdapName makeDNFromServerProperties(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        String serverID = ADSContext.getServerID(serverProperties);
        if (serverID != null) {
            return ADSContext.makeDNFromServerUniqueId(serverID);
        }
        String hostname = ADSContext.getHostname(serverProperties);
        try {
            String ipath = ADSContext.getInstallPath(serverProperties);
            return ADSContext.makeDNFromHostnameAndPath(hostname, ipath);
        }
        catch (ADSContextException ace) {
            ServerDescriptor s = ServerDescriptor.createStandalone(serverProperties);
            return ADSContext.makeDNFromServerUniqueId(s.getHostPort(true));
        }
    }

    public static String getServerIdFromServerProperties(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerProperties(serverProperties);
        String rdn = ldapName.get(ldapName.size() - 1);
        int pos = rdn.indexOf("=");
        return rdn.substring(pos + 1);
    }

    private static LdapName makeDNFromAdministratorProperties(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        String adminUid = ADSContext.getAdministratorUID(adminProperties);
        String dnCentralAdmin = ADSContext.getAdministratorDN(adminUid);
        return ADSContext.nameFromDN(dnCentralAdmin);
    }

    private static BasicAttributes makeAttrsFromAdministratorProperties(Map<AdministratorProperty, Object> adminProperties, boolean passwordRequired) throws ADSContextException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        if (passwordRequired) {
            attrs.put("userPassword", ADSContext.getAdministratorPassword(adminProperties));
        }
        oc.add("top");
        oc.add("person");
        attrs.put(oc);
        attrs.put("sn", GLOBAL_ADMIN_UID);
        if (adminProperties.containsKey((Object)AdministratorProperty.DESCRIPTION)) {
            attrs.put("description", adminProperties.get((Object)AdministratorProperty.DESCRIPTION));
        }
        BasicAttribute privilege = new BasicAttribute("ds-privilege-name");
        privilege.add("bypass-acl");
        privilege.add("modify-acl");
        privilege.add("config-read");
        privilege.add("config-write");
        privilege.add("ldif-import");
        privilege.add("ldif-export");
        privilege.add("backend-backup");
        privilege.add("backend-restore");
        privilege.add("server-shutdown");
        privilege.add("server-restart");
        privilege.add("disconnect-client");
        privilege.add("cancel-request");
        privilege.add("password-reset");
        privilege.add("update-schema");
        privilege.add("privilege-change");
        privilege.add("unindexed-search");
        attrs.put(privilege);
        return attrs;
    }

    private static BasicAttributes makeAttrsFromServerProperties(Map<ServerProperty, Object> serverProperties) {
        BasicAttributes result = new BasicAttributes();
        for (ServerProperty prop : serverProperties.keySet()) {
            Attribute attr = ADSContext.makeAttrFromServerProperty(prop, serverProperties.get((Object)prop));
            if (attr == null) continue;
            result.put(attr);
        }
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-branch");
        oc.add("extensibleobject");
        result.put(oc);
        return result;
    }

    private static Attribute makeAttrFromServerProperty(ServerProperty property, Object value) {
        BasicAttribute result;
        switch (property) {
            case GROUPS: {
                result = new BasicAttribute(ServerProperty.GROUPS.getAttributeName());
                for (Object o : (Set)value) {
                    result.add(o);
                }
                break;
            }
            default: {
                result = new BasicAttribute(property.getAttributeName(), value);
            }
        }
        return result;
    }

    private static BasicAttributes makeAttrsFromServerGroupProperties(Map<ServerGroupProperty, Object> serverGroupProperties) {
        BasicAttributes result = new BasicAttributes();
        for (ServerGroupProperty prop : serverGroupProperties.keySet()) {
            Attribute attr = ADSContext.makeAttrFromServerGroupProperty(prop, serverGroupProperties.get((Object)prop));
            if (attr == null) continue;
            result.put(attr);
        }
        return result;
    }

    private static BasicAttributes makeAttrsFromServerGroupProperties(Set<ServerGroupProperty> serverGroupProperties) {
        BasicAttributes result = new BasicAttributes();
        for (ServerGroupProperty prop : serverGroupProperties) {
            Attribute attr = ADSContext.makeAttrFromServerGroupProperty(prop, null);
            if (attr == null) continue;
            result.put(attr);
        }
        return result;
    }

    private static Attribute makeAttrFromServerGroupProperty(ServerGroupProperty property, Object value) {
        BasicAttribute result;
        switch (property) {
            case MEMBERS: {
                result = new BasicAttribute(ServerGroupProperty.MEMBERS.getAttributeName());
                for (Object o : (Set)value) {
                    result.add(o);
                }
                break;
            }
            default: {
                result = new BasicAttribute(property.getAttributeName(), value);
            }
        }
        return result;
    }

    private Map<ServerGroupProperty, Object> makePropertiesFromServerGroupAttrs(Attributes attrs) throws ADSContextException {
        HashMap<ServerGroupProperty, Object> result = new HashMap<ServerGroupProperty, Object>();
        try {
            for (ServerGroupProperty prop : ServerGroupProperty.values()) {
                HashSet<String> value;
                Attribute attr = attrs.get(prop.getAttributeName());
                if (attr == null) continue;
                if (attr.size() >= 1 && MULTIVALUED_SERVER_GROUP_PROPERTIES.contains((Object)prop)) {
                    HashSet<String> set = new HashSet<String>();
                    NamingEnumeration<?> ae = attr.getAll();
                    while (ae.hasMore()) {
                        set.add((String)ae.next());
                    }
                    value = set;
                } else {
                    value = attr.get(0);
                }
                result.put(prop, value);
            }
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    private Map<ServerProperty, Object> makePropertiesFromServerAttrs(Attributes attrs) throws ADSContextException {
        HashMap<ServerProperty, Object> result = new HashMap<ServerProperty, Object>();
        try {
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMore()) {
                HashSet<String> value;
                Attribute attr = ne.next();
                String attrID = attr.getID();
                if (attrID.endsWith(";binary")) {
                    attrID = attrID.substring(0, attrID.lastIndexOf(";binary"));
                }
                ServerProperty prop = null;
                ServerProperty[] props = ServerProperty.values();
                for (int i = 0; i < props.length && prop == null; ++i) {
                    String v = props[i].getAttributeName();
                    if (!attrID.equalsIgnoreCase(v)) continue;
                    prop = props[i];
                }
                if (prop == null) continue;
                if (attr.size() >= 1 && MULTIVALUED_SERVER_PROPERTIES.contains((Object)prop)) {
                    HashSet<String> set = new HashSet<String>();
                    NamingEnumeration<?> ae = attr.getAll();
                    while (ae.hasMore()) {
                        set.add((String)ae.next());
                    }
                    value = set;
                } else {
                    value = attr.get(0);
                }
                result.put(prop, value);
            }
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    private Map<AdministratorProperty, Object> makePropertiesFromAdministratorAttrs(String rdn, Attributes attrs) throws ADSContextException {
        HashMap<AdministratorProperty, Object> result = new HashMap<AdministratorProperty, Object>();
        LdapName nameObj = ADSContext.nameFromDN(rdn);
        String dn = nameObj + "," + ADSContext.getAdministratorContainerDN();
        result.put(AdministratorProperty.ADMINISTRATOR_DN, dn);
        try {
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMore()) {
                Object value;
                Attribute attr = ne.next();
                String attrID = attr.getID();
                if (attrID.equalsIgnoreCase("cn")) {
                    value = attr.get(0);
                    result.put(AdministratorProperty.UID, value);
                    continue;
                }
                if (attrID.equalsIgnoreCase("userpassword")) {
                    value = attr.get(0);
                    result.put(AdministratorProperty.PASSWORD, value);
                    continue;
                }
                if (!attrID.equalsIgnoreCase("description")) continue;
                value = attr.get(0);
                result.put(AdministratorProperty.DESCRIPTION, value);
            }
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    private static String getServerContainerDN() {
        return "cn=Servers," + ADSContext.getAdministrationSuffixDN();
    }

    public static String getAdministratorContainerDN() {
        return "cn=Administrators," + ADSContext.getAdministrationSuffixDN();
    }

    private static String getServerGroupContainerDN() {
        return "cn=Server Groups," + ADSContext.getAdministrationSuffixDN();
    }

    private static String getHostname(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        String result = (String)serverProperties.get((Object)ServerProperty.HOST_NAME);
        if (result == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_HOSTNAME);
        }
        if (result.length() == 0) {
            throw new ADSContextException(ADSContextException.ErrorType.NOVALID_HOSTNAME);
        }
        return result;
    }

    private static String getServerID(Map<ServerProperty, Object> serverProperties) {
        String result = (String)serverProperties.get((Object)ServerProperty.ID);
        if (result != null && result.length() == 0) {
            result = null;
        }
        return result;
    }

    private static String getInstallPath(Map<ServerProperty, Object> serverProperties) throws ADSContextException {
        String result = (String)serverProperties.get((Object)ServerProperty.INSTANCE_PATH);
        if (result == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_IPATH);
        }
        if (result.length() == 0) {
            throw new ADSContextException(ADSContextException.ErrorType.NOVALID_IPATH);
        }
        return result;
    }

    private static String getAdministratorUID(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        String result = (String)adminProperties.get((Object)AdministratorProperty.UID);
        if (result == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_ADMIN_UID);
        }
        return result;
    }

    private static String getAdministratorPassword(Map<AdministratorProperty, Object> adminProperties) throws ADSContextException {
        String result = (String)adminProperties.get((Object)AdministratorProperty.PASSWORD);
        if (result == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_ADMIN_PASSWORD);
        }
        return result;
    }

    private static LdapName nameFromDN(String dn) throws ADSContextException {
        LdapName result;
        try {
            result = new LdapName(dn);
        }
        catch (InvalidNameException x) {
            LOG.log(Level.SEVERE, "Error parsing dn " + dn, x);
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    private static String getRdn(String rdnName) throws ADSContextException {
        String rdn;
        try {
            CompositeName nameObj = new CompositeName(rdnName);
            rdn = nameObj.get(0);
        }
        catch (InvalidNameException x) {
            LOG.log(Level.SEVERE, "Error parsing rdn " + rdnName, x);
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return rdn;
    }

    private boolean isExistingEntry(LdapName dn) throws ADSContextException {
        boolean result;
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            result = this.getDirContext().search((Name)dn, "(objectclass=*)", sc).hasMore();
        }
        catch (NameNotFoundException x) {
            result = false;
        }
        catch (NoPermissionException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
        return result;
    }

    private void createContainerEntry(String dn) throws ADSContextException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-branch");
        attrs.put(oc);
        this.createEntry(dn, attrs);
    }

    private void createAdministratorContainerEntry() throws ADSContextException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("groupofurls");
        attrs.put(oc);
        attrs.put("memberURL", "ldap:///" + ADSContext.getAdministratorContainerDN() + "??one?(objectclass=*)");
        attrs.put("description", "Group of identities which have full access.");
        this.createEntry(ADSContext.getAdministratorContainerDN(), attrs);
    }

    private void createTopContainerEntry() throws ADSContextException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-branch");
        attrs.put(oc);
        this.createEntry(ADSContext.getAdministrationSuffixDN(), attrs);
    }

    private void createEntry(String dn, Attributes attrs) throws ADSContextException {
        try {
            DirContext ctx = this.getDirContext().createSubcontext(ADSContext.nameFromDN(dn), attrs);
            ctx.close();
        }
        catch (NamingException x) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
        }
    }

    public void createAdministrationSuffix(String backendName) throws ADSContextException {
        ADSContextHelper helper = new ADSContextHelper();
        String ben = backendName;
        if (backendName == null) {
            ben = ADSContext.getBackendName();
        }
        helper.createAdministrationSuffix(this.getDirContext(), ben, ADSContext.getDbName(), ADSContext.getImportTemp());
        this.retrieveInstanceKeyCertificate();
    }

    private void removeAdministrationSuffix() throws ADSContextException {
        ADSContextHelper helper = new ADSContextHelper();
        helper.removeAdministrationSuffix(this.getDirContext(), ADSContext.getBackendName());
    }

    private static String getBackendName() {
        return "adminRoot";
    }

    private static String getDbName() {
        return "adminDb";
    }

    private static String getImportTemp() {
        return "importAdminTemp";
    }

    private void retrieveInstanceKeyCertificate() throws ADSContextException {
        if (!this.isExistingEntry(ADSContext.nameFromDN("cn=ads-truststore"))) {
            return;
        }
        String dnStr = "ds-cfg-key-id=ads-certificate,cn=ads-truststore";
        this.instanceKeyCertificate = null;
        for (int i = 0; null == this.instanceKeyCertificate && i < 2; ++i) {
            try {
                SearchControls sc = new SearchControls();
                sc.setSearchScope(0);
                String[] attrIDs = new String[]{"ds-cfg-ads-certificate"};
                sc.setReturningAttributes(attrIDs);
                SearchResult adsCertEntry = this.dirContext.search((Name)ADSContext.nameFromDN("ds-cfg-key-id=ads-certificate,cn=ads-truststore"), "(objectclass=*)", sc).next();
                Attribute certAttr = adsCertEntry.getAttributes().get("ds-cfg-ads-certificate");
                if (null == certAttr) break;
                this.instanceKeyCertificate = (String)certAttr.get();
                continue;
            }
            catch (NameNotFoundException x) {
                BasicAttributes attrs = new BasicAttributes();
                BasicAttribute oc = new BasicAttribute("objectclass");
                oc.add("top");
                oc.add("ds-cfg-self-signed-cert-request");
                attrs.put(oc);
                this.createEntry("ds-cfg-key-id=ads-certificate,cn=ads-truststore", attrs);
                continue;
            }
            catch (NoPermissionException x) {
                throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
            }
            catch (NamingException x) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)x);
            }
        }
        if (null == this.instanceKeyCertificate) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED);
        }
    }

    public String getInstanceKeyCertificate() throws ADSContextException {
        if (null == this.instanceKeyCertificate) {
            this.retrieveInstanceKeyCertificate();
        }
        return this.instanceKeyCertificate;
    }

    private static String getInstanceKeysContainerDN() {
        return "cn=instance keys," + ADSContext.getAdministrationSuffixDN();
    }

    static {
        MULTIVALUED_SERVER_PROPERTIES.add(ServerProperty.GROUPS);
        MULTIVALUED_SERVER_GROUP_PROPERTIES = new HashSet<ServerGroupProperty>();
        MULTIVALUED_SERVER_GROUP_PROPERTIES.add(ServerGroupProperty.MEMBERS);
        nameToAdminUSerProperty = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstanceKeyProperty {
        KEY_ID("ds-cfg-key-id", ADSPropertySyntax.STRING),
        HOST_NAME("ds-cfg-ads-certificate", ADSPropertySyntax.STRING);

        private String attrName;
        private ADSPropertySyntax attrSyntax;

        private InstanceKeyProperty(String n2, ADSPropertySyntax s) {
            this.attrName = n2;
            this.attrSyntax = s;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public ADSPropertySyntax getAttributeSyntax() {
            return this.attrSyntax;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdministratorProperty {
        UID("id", ADSPropertySyntax.STRING),
        PASSWORD("password", ADSPropertySyntax.STRING),
        DESCRIPTION("description", ADSPropertySyntax.STRING),
        ADMINISTRATOR_DN("administrator dn", ADSPropertySyntax.STRING);

        private String attrName;
        private ADSPropertySyntax attrSyntax;

        private AdministratorProperty(String n2, ADSPropertySyntax s) {
            this.attrName = n2;
            this.attrSyntax = s;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public ADSPropertySyntax getAttributeSyntax() {
            return this.attrSyntax;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerGroupProperty {
        UID("cn"),
        DESCRIPTION("description"),
        MEMBERS("uniqueMember");

        private String attrName;

        private ServerGroupProperty(String n2) {
            this.attrName = n2;
        }

        public String getAttributeName() {
            return this.attrName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerProperty {
        ID("id", ADSPropertySyntax.STRING),
        HOST_NAME("hostname", ADSPropertySyntax.STRING),
        LDAP_PORT("ldapport", ADSPropertySyntax.INTEGER),
        JMX_PORT("jmxport", ADSPropertySyntax.INTEGER),
        JMXS_PORT("jmxsport", ADSPropertySyntax.INTEGER),
        LDAPS_PORT("ldapsport", ADSPropertySyntax.INTEGER),
        CERTIFICATE("certificate", ADSPropertySyntax.STRING),
        INSTANCE_PATH("instancepath", ADSPropertySyntax.STRING),
        DESCRIPTION("description", ADSPropertySyntax.STRING),
        HOST_OS("os", ADSPropertySyntax.STRING),
        LDAP_ENABLED("ldapEnabled", ADSPropertySyntax.BOOLEAN),
        LDAPS_ENABLED("ldapsEnabled", ADSPropertySyntax.BOOLEAN),
        STARTTLS_ENABLED("startTLSEnabled", ADSPropertySyntax.BOOLEAN),
        JMX_ENABLED("jmxEnabled", ADSPropertySyntax.BOOLEAN),
        JMXS_ENABLED("jmxsEnabled", ADSPropertySyntax.BOOLEAN),
        LOCATION("location", ADSPropertySyntax.STRING),
        GROUPS("memberofgroups", ADSPropertySyntax.STRING);

        private String attrName;
        private ADSPropertySyntax attSyntax;

        private ServerProperty(String n2, ADSPropertySyntax s) {
            this.attrName = n2;
            this.attSyntax = s;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public ADSPropertySyntax getAttributeSyntax() {
            return this.attSyntax;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ADSPropertySyntax {
        STRING,
        INTEGER,
        BOOLEAN;

    }
}

