/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.table;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TableSerializer;

public final class TabSeparatedTablePrinter
extends TablePrinter {
    private boolean displayHeadings = false;
    private PrintWriter writer = null;

    public TabSeparatedTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public TabSeparatedTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    protected TableSerializer getSerializer() {
        return new Serializer(this.writer, this.displayHeadings);
    }

    private static final class Serializer
    extends TableSerializer {
        private int column = 0;
        private final boolean displayHeadings;
        private int requiredSeparators = 0;
        private final PrintWriter writer;

        private Serializer(PrintWriter writer, boolean displayHeadings) {
            this.writer = writer;
            this.displayHeadings = displayHeadings;
        }

        public void addCell(String s) {
            if (s.length() == 0) {
                ++this.requiredSeparators;
            } else {
                for (int i = 0; i < this.requiredSeparators; ++i) {
                    this.writer.print('\t');
                }
                this.requiredSeparators = 1;
            }
            this.writer.print(s.replaceAll("[\\t\\n\\r]", " "));
            ++this.column;
        }

        public void addHeading(String s) {
            if (this.displayHeadings) {
                this.addCell(s);
            }
        }

        public void endHeader() {
            if (this.displayHeadings) {
                this.writer.println();
            }
        }

        public void endRow() {
            this.writer.println();
        }

        public void endTable() {
            this.writer.flush();
        }

        public void startHeader() {
            this.column = 0;
            this.requiredSeparators = 0;
        }

        public void startRow() {
            this.column = 0;
            this.requiredSeparators = 0;
        }
    }
}

