/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.table;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TableSerializer;

public final class CSVTablePrinter
extends TablePrinter {
    private boolean displayHeadings = false;
    private PrintWriter writer = null;

    public CSVTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public CSVTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    protected TableSerializer getSerializer() {
        return new Serializer(this.writer, this.displayHeadings);
    }

    private static final class Serializer
    extends TableSerializer {
        private int column = 0;
        private final boolean displayHeadings;
        private int requiredSeparators = 0;
        private final PrintWriter writer;

        private Serializer(PrintWriter writer, boolean displayHeadings) {
            this.writer = writer;
            this.displayHeadings = displayHeadings;
        }

        public void addCell(String s) {
            if (s.length() == 0) {
                ++this.requiredSeparators;
            } else {
                for (int i = 0; i < this.requiredSeparators; ++i) {
                    this.writer.print(',');
                }
                this.requiredSeparators = 1;
            }
            boolean needsQuoting = false;
            if (s.contains(",")) {
                needsQuoting = true;
            }
            if (s.contains("\n")) {
                needsQuoting = true;
            }
            if (s.contains("\r")) {
                needsQuoting = true;
            }
            if (s.contains("\"")) {
                needsQuoting = true;
                s = s.replace("\"", "\"\"");
            }
            if (s.startsWith(" ")) {
                needsQuoting = true;
            }
            if (s.endsWith(" ")) {
                needsQuoting = true;
            }
            StringBuilder builder = new StringBuilder();
            if (needsQuoting) {
                builder.append("\"");
            }
            builder.append(s);
            if (needsQuoting) {
                builder.append("\"");
            }
            this.writer.print(builder.toString());
            ++this.column;
        }

        public void addHeading(String s) {
            if (this.displayHeadings) {
                this.addCell(s);
            }
        }

        public void endHeader() {
            if (this.displayHeadings) {
                this.writer.println();
            }
        }

        public void endRow() {
            this.writer.println();
        }

        public void endTable() {
            this.writer.flush();
        }

        public void startHeader() {
            this.column = 0;
            this.requiredSeparators = 0;
        }

        public void startRow() {
            this.column = 0;
            this.requiredSeparators = 0;
        }
    }
}

