/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.HashSet;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceArgument
extends Argument {
    private boolean caseSensitive;
    private HashSet<String> allowedValues;

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, String valuePlaceholder, HashSet<String> allowedValues, boolean caseSensitive, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, descriptionID, descriptionArgs);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, String defaultValue, String propertyName, HashSet<String> allowedValues, boolean caseSensitive, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, defaultValue, propertyName, descriptionID, descriptionArgs);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public HashSet<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean valueIsAcceptable(String valueString, StringBuilder invalidReason) {
        if (this.caseSensitive) {
            if (!this.allowedValues.contains(valueString)) {
                int msgID = 5505071;
                invalidReason.append(MessageHandler.getMessage(msgID, this.getName(), valueString));
                return false;
            }
        } else if (!this.allowedValues.contains(StaticUtils.toLowerCase(valueString))) {
            int msgID = 5505071;
            invalidReason.append(MessageHandler.getMessage(msgID, this.getName(), valueString));
            return false;
        }
        return true;
    }
}

