/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedArgument
extends Argument {
    private LinkedHashMap<String, String> namesToValues = new LinkedHashMap();

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, true, valuePlaceholder, null, null, descriptionID, descriptionArgs);
    }

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, String valuePlaceholder, String defaultValue, String propertyName, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, true, valuePlaceholder, defaultValue, propertyName, descriptionID, descriptionArgs);
    }

    public LinkedHashMap<String, String> getNameToValueMap() {
        return this.namesToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean valueIsAcceptable(String valueString, StringBuilder invalidReason) {
        String line;
        BufferedReader reader;
        File valueFile;
        try {
            valueFile = new File(valueString);
            if (!valueFile.exists()) {
                int msgID = 5505072;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName()));
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 5505073;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            return false;
        }
        try {
            reader = new BufferedReader(new FileReader(valueFile));
        }
        catch (Exception e) {
            int msgID = 5505074;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            return false;
        }
        try {
            line = reader.readLine();
        }
        catch (Exception e) {
            int msgID = 5505075;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName(), StaticUtils.getExceptionMessage(e)));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        if (line == null) {
            int msgID = 5505076;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName()));
            return false;
        }
        this.namesToValues.put(valueString, line);
        return true;
    }

    @Override
    public void addValue(String valueString) {
        String actualValue = this.namesToValues.get(valueString);
        if (actualValue != null) {
            super.addValue(actualValue);
        }
    }
}

