/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.Iterator;
import java.util.LinkedList;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Argument {
    private boolean isHidden;
    private boolean isMultiValued;
    private boolean isPresent;
    private boolean isRequired;
    private boolean needsValue;
    private Character shortIdentifier;
    private int descriptionID;
    private LinkedList<String> values;
    private String defaultValue;
    private String description;
    private String longIdentifier;
    private String name;
    private String propertyName;
    private String valuePlaceholder;

    protected Argument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, String defaultValue, String propertyName, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        this.name = name;
        this.shortIdentifier = shortIdentifier;
        this.longIdentifier = longIdentifier;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.needsValue = needsValue;
        this.valuePlaceholder = valuePlaceholder;
        this.defaultValue = defaultValue;
        this.propertyName = propertyName;
        this.descriptionID = descriptionID;
        this.description = MessageHandler.getMessage(descriptionID, descriptionArgs);
        if (shortIdentifier == null && longIdentifier == null) {
            int msgID = 5505059;
            String message = MessageHandler.getMessage(msgID, name);
            throw new ArgumentException(msgID, message);
        }
        if (needsValue && valuePlaceholder == null) {
            int msgID = 5505060;
            String message = MessageHandler.getMessage(msgID, name);
            throw new ArgumentException(msgID, message);
        }
        this.values = new LinkedList();
        this.isPresent = false;
        this.isHidden = false;
    }

    public String getName() {
        return this.name;
    }

    public Character getShortIdentifier() {
        return this.shortIdentifier;
    }

    public String getLongIdentifier() {
        return this.longIdentifier;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void setPresent(boolean isPresent) {
        this.isPresent = isPresent;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public void setMultiValued(boolean isMultiValued) {
        this.isMultiValued = isMultiValued;
    }

    public boolean needsValue() {
        return this.needsValue;
    }

    public void setNeedsValue(boolean needsValue) {
        this.needsValue = needsValue;
    }

    public String getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public void setValuePlaceholder(String valuePlaceholder) {
        this.valuePlaceholder = valuePlaceholder;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public int getDescriptionID() {
        return this.descriptionID;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            return this.defaultValue;
        }
        return this.values.getFirst();
    }

    public LinkedList<String> getValues() {
        return this.values;
    }

    public int getIntValue() throws ArgumentException {
        int intValue;
        if (this.values.isEmpty()) {
            int msgID = 5505061;
            String message = MessageHandler.getMessage(msgID, this.name);
            throw new ArgumentException(msgID, message);
        }
        Iterator iterator = this.values.iterator();
        String valueString = (String)iterator.next();
        try {
            intValue = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            int msgID = 5505062;
            String message = MessageHandler.getMessage(msgID, valueString, this.name);
            throw new ArgumentException(msgID, message, e);
        }
        if (iterator.hasNext()) {
            int msgID = 5505063;
            String message = MessageHandler.getMessage(msgID, this.name);
            throw new ArgumentException(msgID, message);
        }
        return intValue;
    }

    public LinkedList<Integer> getIntValues() throws ArgumentException {
        LinkedList<Integer> intList = new LinkedList<Integer>();
        for (String valueString : this.values) {
            try {
                intList.add(Integer.valueOf(valueString));
            }
            catch (Exception e) {
                int msgID = 5505062;
                String message = MessageHandler.getMessage(msgID, valueString, this.name);
                throw new ArgumentException(msgID, message, e);
            }
        }
        return intList;
    }

    public boolean getBooleanValue() throws ArgumentException {
        boolean booleanValue;
        if (this.values.isEmpty()) {
            int msgID = 5505064;
            String message = MessageHandler.getMessage(msgID, this.name);
            throw new ArgumentException(msgID, message);
        }
        Iterator iterator = this.values.iterator();
        String valueString = StaticUtils.toLowerCase((String)iterator.next());
        if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
            booleanValue = true;
        } else if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
            booleanValue = false;
        } else {
            int msgID = 5505065;
            String message = MessageHandler.getMessage(msgID, valueString, this.name);
            throw new ArgumentException(msgID, message);
        }
        if (iterator.hasNext()) {
            int msgID = 5505066;
            String message = MessageHandler.getMessage(msgID, this.name);
            throw new ArgumentException(msgID, message);
        }
        return booleanValue;
    }

    public abstract boolean valueIsAcceptable(String var1, StringBuilder var2);

    public void addValue(String valueString) {
        this.values.add(valueString);
    }

    public void clearValues() {
        this.values.clear();
    }
}

