/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.StringTokenizer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticUtils {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    private StaticUtils() {
    }

    public static byte[] getBytes(String s) {
        try {
            if (s == null) {
                return null;
            }
            int length = s.length();
            byte[] returnArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                returnArray[i] = (byte)(c & 0x7F);
                if (c == returnArray[i]) continue;
                return s.getBytes("UTF-8");
            }
            return returnArray;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                return s.getBytes("UTF-8");
            }
            catch (Exception e2) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
                return s.getBytes();
            }
        }
    }

    public static byte[] getBytes(char[] chars) {
        return StaticUtils.getBytes(new String(chars));
    }

    public static String byteToHex(byte b) {
        switch (b & 0xFF) {
            case 0: {
                return "00";
            }
            case 1: {
                return "01";
            }
            case 2: {
                return "02";
            }
            case 3: {
                return "03";
            }
            case 4: {
                return "04";
            }
            case 5: {
                return "05";
            }
            case 6: {
                return "06";
            }
            case 7: {
                return "07";
            }
            case 8: {
                return "08";
            }
            case 9: {
                return "09";
            }
            case 10: {
                return "0A";
            }
            case 11: {
                return "0B";
            }
            case 12: {
                return "0C";
            }
            case 13: {
                return "0D";
            }
            case 14: {
                return "0E";
            }
            case 15: {
                return "0F";
            }
            case 16: {
                return "10";
            }
            case 17: {
                return "11";
            }
            case 18: {
                return "12";
            }
            case 19: {
                return "13";
            }
            case 20: {
                return "14";
            }
            case 21: {
                return "15";
            }
            case 22: {
                return "16";
            }
            case 23: {
                return "17";
            }
            case 24: {
                return "18";
            }
            case 25: {
                return "19";
            }
            case 26: {
                return "1A";
            }
            case 27: {
                return "1B";
            }
            case 28: {
                return "1C";
            }
            case 29: {
                return "1D";
            }
            case 30: {
                return "1E";
            }
            case 31: {
                return "1F";
            }
            case 32: {
                return "20";
            }
            case 33: {
                return "21";
            }
            case 34: {
                return "22";
            }
            case 35: {
                return "23";
            }
            case 36: {
                return "24";
            }
            case 37: {
                return "25";
            }
            case 38: {
                return "26";
            }
            case 39: {
                return "27";
            }
            case 40: {
                return "28";
            }
            case 41: {
                return "29";
            }
            case 42: {
                return "2A";
            }
            case 43: {
                return "2B";
            }
            case 44: {
                return "2C";
            }
            case 45: {
                return "2D";
            }
            case 46: {
                return "2E";
            }
            case 47: {
                return "2F";
            }
            case 48: {
                return "30";
            }
            case 49: {
                return "31";
            }
            case 50: {
                return "32";
            }
            case 51: {
                return "33";
            }
            case 52: {
                return "34";
            }
            case 53: {
                return "35";
            }
            case 54: {
                return "36";
            }
            case 55: {
                return "37";
            }
            case 56: {
                return "38";
            }
            case 57: {
                return "39";
            }
            case 58: {
                return "3A";
            }
            case 59: {
                return "3B";
            }
            case 60: {
                return "3C";
            }
            case 61: {
                return "3D";
            }
            case 62: {
                return "3E";
            }
            case 63: {
                return "3F";
            }
            case 64: {
                return "40";
            }
            case 65: {
                return "41";
            }
            case 66: {
                return "42";
            }
            case 67: {
                return "43";
            }
            case 68: {
                return "44";
            }
            case 69: {
                return "45";
            }
            case 70: {
                return "46";
            }
            case 71: {
                return "47";
            }
            case 72: {
                return "48";
            }
            case 73: {
                return "49";
            }
            case 74: {
                return "4A";
            }
            case 75: {
                return "4B";
            }
            case 76: {
                return "4C";
            }
            case 77: {
                return "4D";
            }
            case 78: {
                return "4E";
            }
            case 79: {
                return "4F";
            }
            case 80: {
                return "50";
            }
            case 81: {
                return "51";
            }
            case 82: {
                return "52";
            }
            case 83: {
                return "53";
            }
            case 84: {
                return "54";
            }
            case 85: {
                return "55";
            }
            case 86: {
                return "56";
            }
            case 87: {
                return "57";
            }
            case 88: {
                return "58";
            }
            case 89: {
                return "59";
            }
            case 90: {
                return "5A";
            }
            case 91: {
                return "5B";
            }
            case 92: {
                return "5C";
            }
            case 93: {
                return "5D";
            }
            case 94: {
                return "5E";
            }
            case 95: {
                return "5F";
            }
            case 96: {
                return "60";
            }
            case 97: {
                return "61";
            }
            case 98: {
                return "62";
            }
            case 99: {
                return "63";
            }
            case 100: {
                return "64";
            }
            case 101: {
                return "65";
            }
            case 102: {
                return "66";
            }
            case 103: {
                return "67";
            }
            case 104: {
                return "68";
            }
            case 105: {
                return "69";
            }
            case 106: {
                return "6A";
            }
            case 107: {
                return "6B";
            }
            case 108: {
                return "6C";
            }
            case 109: {
                return "6D";
            }
            case 110: {
                return "6E";
            }
            case 111: {
                return "6F";
            }
            case 112: {
                return "70";
            }
            case 113: {
                return "71";
            }
            case 114: {
                return "72";
            }
            case 115: {
                return "73";
            }
            case 116: {
                return "74";
            }
            case 117: {
                return "75";
            }
            case 118: {
                return "76";
            }
            case 119: {
                return "77";
            }
            case 120: {
                return "78";
            }
            case 121: {
                return "79";
            }
            case 122: {
                return "7A";
            }
            case 123: {
                return "7B";
            }
            case 124: {
                return "7C";
            }
            case 125: {
                return "7D";
            }
            case 126: {
                return "7E";
            }
            case 127: {
                return "7F";
            }
            case 128: {
                return "80";
            }
            case 129: {
                return "81";
            }
            case 130: {
                return "82";
            }
            case 131: {
                return "83";
            }
            case 132: {
                return "84";
            }
            case 133: {
                return "85";
            }
            case 134: {
                return "86";
            }
            case 135: {
                return "87";
            }
            case 136: {
                return "88";
            }
            case 137: {
                return "89";
            }
            case 138: {
                return "8A";
            }
            case 139: {
                return "8B";
            }
            case 140: {
                return "8C";
            }
            case 141: {
                return "8D";
            }
            case 142: {
                return "8E";
            }
            case 143: {
                return "8F";
            }
            case 144: {
                return "90";
            }
            case 145: {
                return "91";
            }
            case 146: {
                return "92";
            }
            case 147: {
                return "93";
            }
            case 148: {
                return "94";
            }
            case 149: {
                return "95";
            }
            case 150: {
                return "96";
            }
            case 151: {
                return "97";
            }
            case 152: {
                return "98";
            }
            case 153: {
                return "99";
            }
            case 154: {
                return "9A";
            }
            case 155: {
                return "9B";
            }
            case 156: {
                return "9C";
            }
            case 157: {
                return "9D";
            }
            case 158: {
                return "9E";
            }
            case 159: {
                return "9F";
            }
            case 160: {
                return "A0";
            }
            case 161: {
                return "A1";
            }
            case 162: {
                return "A2";
            }
            case 163: {
                return "A3";
            }
            case 164: {
                return "A4";
            }
            case 165: {
                return "A5";
            }
            case 166: {
                return "A6";
            }
            case 167: {
                return "A7";
            }
            case 168: {
                return "A8";
            }
            case 169: {
                return "A9";
            }
            case 170: {
                return "AA";
            }
            case 171: {
                return "AB";
            }
            case 172: {
                return "AC";
            }
            case 173: {
                return "AD";
            }
            case 174: {
                return "AE";
            }
            case 175: {
                return "AF";
            }
            case 176: {
                return "B0";
            }
            case 177: {
                return "B1";
            }
            case 178: {
                return "B2";
            }
            case 179: {
                return "B3";
            }
            case 180: {
                return "B4";
            }
            case 181: {
                return "B5";
            }
            case 182: {
                return "B6";
            }
            case 183: {
                return "B7";
            }
            case 184: {
                return "B8";
            }
            case 185: {
                return "B9";
            }
            case 186: {
                return "BA";
            }
            case 187: {
                return "BB";
            }
            case 188: {
                return "BC";
            }
            case 189: {
                return "BD";
            }
            case 190: {
                return "BE";
            }
            case 191: {
                return "BF";
            }
            case 192: {
                return "C0";
            }
            case 193: {
                return "C1";
            }
            case 194: {
                return "C2";
            }
            case 195: {
                return "C3";
            }
            case 196: {
                return "C4";
            }
            case 197: {
                return "C5";
            }
            case 198: {
                return "C6";
            }
            case 199: {
                return "C7";
            }
            case 200: {
                return "C8";
            }
            case 201: {
                return "C9";
            }
            case 202: {
                return "CA";
            }
            case 203: {
                return "CB";
            }
            case 204: {
                return "CC";
            }
            case 205: {
                return "CD";
            }
            case 206: {
                return "CE";
            }
            case 207: {
                return "CF";
            }
            case 208: {
                return "D0";
            }
            case 209: {
                return "D1";
            }
            case 210: {
                return "D2";
            }
            case 211: {
                return "D3";
            }
            case 212: {
                return "D4";
            }
            case 213: {
                return "D5";
            }
            case 214: {
                return "D6";
            }
            case 215: {
                return "D7";
            }
            case 216: {
                return "D8";
            }
            case 217: {
                return "D9";
            }
            case 218: {
                return "DA";
            }
            case 219: {
                return "DB";
            }
            case 220: {
                return "DC";
            }
            case 221: {
                return "DD";
            }
            case 222: {
                return "DE";
            }
            case 223: {
                return "DF";
            }
            case 224: {
                return "E0";
            }
            case 225: {
                return "E1";
            }
            case 226: {
                return "E2";
            }
            case 227: {
                return "E3";
            }
            case 228: {
                return "E4";
            }
            case 229: {
                return "E5";
            }
            case 230: {
                return "E6";
            }
            case 231: {
                return "E7";
            }
            case 232: {
                return "E8";
            }
            case 233: {
                return "E9";
            }
            case 234: {
                return "EA";
            }
            case 235: {
                return "EB";
            }
            case 236: {
                return "EC";
            }
            case 237: {
                return "ED";
            }
            case 238: {
                return "EE";
            }
            case 239: {
                return "EF";
            }
            case 240: {
                return "F0";
            }
            case 241: {
                return "F1";
            }
            case 242: {
                return "F2";
            }
            case 243: {
                return "F3";
            }
            case 244: {
                return "F4";
            }
            case 245: {
                return "F5";
            }
            case 246: {
                return "F6";
            }
            case 247: {
                return "F7";
            }
            case 248: {
                return "F8";
            }
            case 249: {
                return "F9";
            }
            case 250: {
                return "FA";
            }
            case 251: {
                return "FB";
            }
            case 252: {
                return "FC";
            }
            case 253: {
                return "FD";
            }
            case 254: {
                return "FE";
            }
            case 255: {
                return "FF";
            }
        }
        return "??";
    }

    public static String byteToLowerHex(byte b) {
        switch (b & 0xFF) {
            case 0: {
                return "00";
            }
            case 1: {
                return "01";
            }
            case 2: {
                return "02";
            }
            case 3: {
                return "03";
            }
            case 4: {
                return "04";
            }
            case 5: {
                return "05";
            }
            case 6: {
                return "06";
            }
            case 7: {
                return "07";
            }
            case 8: {
                return "08";
            }
            case 9: {
                return "09";
            }
            case 10: {
                return "0a";
            }
            case 11: {
                return "0b";
            }
            case 12: {
                return "0c";
            }
            case 13: {
                return "0d";
            }
            case 14: {
                return "0e";
            }
            case 15: {
                return "0f";
            }
            case 16: {
                return "10";
            }
            case 17: {
                return "11";
            }
            case 18: {
                return "12";
            }
            case 19: {
                return "13";
            }
            case 20: {
                return "14";
            }
            case 21: {
                return "15";
            }
            case 22: {
                return "16";
            }
            case 23: {
                return "17";
            }
            case 24: {
                return "18";
            }
            case 25: {
                return "19";
            }
            case 26: {
                return "1a";
            }
            case 27: {
                return "1b";
            }
            case 28: {
                return "1c";
            }
            case 29: {
                return "1d";
            }
            case 30: {
                return "1e";
            }
            case 31: {
                return "1f";
            }
            case 32: {
                return "20";
            }
            case 33: {
                return "21";
            }
            case 34: {
                return "22";
            }
            case 35: {
                return "23";
            }
            case 36: {
                return "24";
            }
            case 37: {
                return "25";
            }
            case 38: {
                return "26";
            }
            case 39: {
                return "27";
            }
            case 40: {
                return "28";
            }
            case 41: {
                return "29";
            }
            case 42: {
                return "2a";
            }
            case 43: {
                return "2b";
            }
            case 44: {
                return "2c";
            }
            case 45: {
                return "2d";
            }
            case 46: {
                return "2e";
            }
            case 47: {
                return "2f";
            }
            case 48: {
                return "30";
            }
            case 49: {
                return "31";
            }
            case 50: {
                return "32";
            }
            case 51: {
                return "33";
            }
            case 52: {
                return "34";
            }
            case 53: {
                return "35";
            }
            case 54: {
                return "36";
            }
            case 55: {
                return "37";
            }
            case 56: {
                return "38";
            }
            case 57: {
                return "39";
            }
            case 58: {
                return "3a";
            }
            case 59: {
                return "3b";
            }
            case 60: {
                return "3c";
            }
            case 61: {
                return "3d";
            }
            case 62: {
                return "3e";
            }
            case 63: {
                return "3f";
            }
            case 64: {
                return "40";
            }
            case 65: {
                return "41";
            }
            case 66: {
                return "42";
            }
            case 67: {
                return "43";
            }
            case 68: {
                return "44";
            }
            case 69: {
                return "45";
            }
            case 70: {
                return "46";
            }
            case 71: {
                return "47";
            }
            case 72: {
                return "48";
            }
            case 73: {
                return "49";
            }
            case 74: {
                return "4a";
            }
            case 75: {
                return "4b";
            }
            case 76: {
                return "4c";
            }
            case 77: {
                return "4d";
            }
            case 78: {
                return "4e";
            }
            case 79: {
                return "4f";
            }
            case 80: {
                return "50";
            }
            case 81: {
                return "51";
            }
            case 82: {
                return "52";
            }
            case 83: {
                return "53";
            }
            case 84: {
                return "54";
            }
            case 85: {
                return "55";
            }
            case 86: {
                return "56";
            }
            case 87: {
                return "57";
            }
            case 88: {
                return "58";
            }
            case 89: {
                return "59";
            }
            case 90: {
                return "5a";
            }
            case 91: {
                return "5b";
            }
            case 92: {
                return "5c";
            }
            case 93: {
                return "5d";
            }
            case 94: {
                return "5e";
            }
            case 95: {
                return "5f";
            }
            case 96: {
                return "60";
            }
            case 97: {
                return "61";
            }
            case 98: {
                return "62";
            }
            case 99: {
                return "63";
            }
            case 100: {
                return "64";
            }
            case 101: {
                return "65";
            }
            case 102: {
                return "66";
            }
            case 103: {
                return "67";
            }
            case 104: {
                return "68";
            }
            case 105: {
                return "69";
            }
            case 106: {
                return "6a";
            }
            case 107: {
                return "6b";
            }
            case 108: {
                return "6c";
            }
            case 109: {
                return "6d";
            }
            case 110: {
                return "6e";
            }
            case 111: {
                return "6f";
            }
            case 112: {
                return "70";
            }
            case 113: {
                return "71";
            }
            case 114: {
                return "72";
            }
            case 115: {
                return "73";
            }
            case 116: {
                return "74";
            }
            case 117: {
                return "75";
            }
            case 118: {
                return "76";
            }
            case 119: {
                return "77";
            }
            case 120: {
                return "78";
            }
            case 121: {
                return "79";
            }
            case 122: {
                return "7a";
            }
            case 123: {
                return "7b";
            }
            case 124: {
                return "7c";
            }
            case 125: {
                return "7d";
            }
            case 126: {
                return "7e";
            }
            case 127: {
                return "7f";
            }
            case 128: {
                return "80";
            }
            case 129: {
                return "81";
            }
            case 130: {
                return "82";
            }
            case 131: {
                return "83";
            }
            case 132: {
                return "84";
            }
            case 133: {
                return "85";
            }
            case 134: {
                return "86";
            }
            case 135: {
                return "87";
            }
            case 136: {
                return "88";
            }
            case 137: {
                return "89";
            }
            case 138: {
                return "8a";
            }
            case 139: {
                return "8b";
            }
            case 140: {
                return "8c";
            }
            case 141: {
                return "8d";
            }
            case 142: {
                return "8e";
            }
            case 143: {
                return "8f";
            }
            case 144: {
                return "90";
            }
            case 145: {
                return "91";
            }
            case 146: {
                return "92";
            }
            case 147: {
                return "93";
            }
            case 148: {
                return "94";
            }
            case 149: {
                return "95";
            }
            case 150: {
                return "96";
            }
            case 151: {
                return "97";
            }
            case 152: {
                return "98";
            }
            case 153: {
                return "99";
            }
            case 154: {
                return "9a";
            }
            case 155: {
                return "9b";
            }
            case 156: {
                return "9c";
            }
            case 157: {
                return "9d";
            }
            case 158: {
                return "9e";
            }
            case 159: {
                return "9f";
            }
            case 160: {
                return "a0";
            }
            case 161: {
                return "a1";
            }
            case 162: {
                return "a2";
            }
            case 163: {
                return "a3";
            }
            case 164: {
                return "a4";
            }
            case 165: {
                return "a5";
            }
            case 166: {
                return "a6";
            }
            case 167: {
                return "a7";
            }
            case 168: {
                return "a8";
            }
            case 169: {
                return "a9";
            }
            case 170: {
                return "aa";
            }
            case 171: {
                return "ab";
            }
            case 172: {
                return "ac";
            }
            case 173: {
                return "ad";
            }
            case 174: {
                return "ae";
            }
            case 175: {
                return "af";
            }
            case 176: {
                return "b0";
            }
            case 177: {
                return "b1";
            }
            case 178: {
                return "b2";
            }
            case 179: {
                return "b3";
            }
            case 180: {
                return "b4";
            }
            case 181: {
                return "b5";
            }
            case 182: {
                return "b6";
            }
            case 183: {
                return "b7";
            }
            case 184: {
                return "b8";
            }
            case 185: {
                return "b9";
            }
            case 186: {
                return "ba";
            }
            case 187: {
                return "bb";
            }
            case 188: {
                return "bc";
            }
            case 189: {
                return "bd";
            }
            case 190: {
                return "be";
            }
            case 191: {
                return "bf";
            }
            case 192: {
                return "c0";
            }
            case 193: {
                return "c1";
            }
            case 194: {
                return "c2";
            }
            case 195: {
                return "c3";
            }
            case 196: {
                return "c4";
            }
            case 197: {
                return "c5";
            }
            case 198: {
                return "c6";
            }
            case 199: {
                return "c7";
            }
            case 200: {
                return "c8";
            }
            case 201: {
                return "c9";
            }
            case 202: {
                return "ca";
            }
            case 203: {
                return "cb";
            }
            case 204: {
                return "cc";
            }
            case 205: {
                return "cd";
            }
            case 206: {
                return "ce";
            }
            case 207: {
                return "cf";
            }
            case 208: {
                return "d0";
            }
            case 209: {
                return "d1";
            }
            case 210: {
                return "d2";
            }
            case 211: {
                return "d3";
            }
            case 212: {
                return "d4";
            }
            case 213: {
                return "d5";
            }
            case 214: {
                return "d6";
            }
            case 215: {
                return "d7";
            }
            case 216: {
                return "d8";
            }
            case 217: {
                return "d9";
            }
            case 218: {
                return "da";
            }
            case 219: {
                return "db";
            }
            case 220: {
                return "dc";
            }
            case 221: {
                return "dd";
            }
            case 222: {
                return "de";
            }
            case 223: {
                return "df";
            }
            case 224: {
                return "e0";
            }
            case 225: {
                return "e1";
            }
            case 226: {
                return "e2";
            }
            case 227: {
                return "e3";
            }
            case 228: {
                return "e4";
            }
            case 229: {
                return "e5";
            }
            case 230: {
                return "e6";
            }
            case 231: {
                return "e7";
            }
            case 232: {
                return "e8";
            }
            case 233: {
                return "e9";
            }
            case 234: {
                return "ea";
            }
            case 235: {
                return "eb";
            }
            case 236: {
                return "ec";
            }
            case 237: {
                return "ed";
            }
            case 238: {
                return "ee";
            }
            case 239: {
                return "ef";
            }
            case 240: {
                return "f0";
            }
            case 241: {
                return "f1";
            }
            case 242: {
                return "f2";
            }
            case 243: {
                return "f3";
            }
            case 244: {
                return "f4";
            }
            case 245: {
                return "f5";
            }
            case 246: {
                return "f6";
            }
            case 247: {
                return "f7";
            }
            case 248: {
                return "f8";
            }
            case 249: {
                return "f9";
            }
            case 250: {
                return "fa";
            }
            case 251: {
                return "fb";
            }
            case 252: {
                return "fc";
            }
            case 253: {
                return "fd";
            }
            case 254: {
                return "fe";
            }
            case 255: {
                return "ff";
            }
        }
        return "??";
    }

    public static char byteToASCII(byte b) {
        if (b >= 32 && b <= 126) {
            return (char)b;
        }
        return ' ';
    }

    public static String bytesToHex(byte[] b) {
        if (b == null || b.length == 0) {
            return "";
        }
        int arrayLength = b.length;
        StringBuilder buffer = new StringBuilder((arrayLength - 1) * 3 + 2);
        buffer.append(StaticUtils.byteToHex(b[0]));
        for (int i = 1; i < arrayLength; ++i) {
            buffer.append(" ");
            buffer.append(StaticUtils.byteToHex(b[i]));
        }
        return buffer.toString();
    }

    public static String bytesToColonDelimitedHex(byte[] b) {
        if (b == null || b.length == 0) {
            return "";
        }
        int arrayLength = b.length;
        StringBuilder buffer = new StringBuilder((arrayLength - 1) * 3 + 2);
        buffer.append(StaticUtils.byteToHex(b[0]));
        for (int i = 1; i < arrayLength; ++i) {
            buffer.append(":");
            buffer.append(StaticUtils.byteToHex(b[i]));
        }
        return buffer.toString();
    }

    public static String bytesToHex(ByteBuffer b) {
        if (b == null) {
            return "";
        }
        int position = b.position();
        int limit = b.limit();
        int length = limit - position;
        if (length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder((length - 1) * 3 + 2);
        buffer.append(StaticUtils.byteToHex(b.get()));
        for (int i = 1; i < length; ++i) {
            buffer.append(" ");
            buffer.append(StaticUtils.byteToHex(b.get()));
        }
        b.position(position);
        b.limit(limit);
        return buffer.toString();
    }

    public static void byteArrayToHexPlusAscii(StringBuilder buffer, byte[] b, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        int length = b.length;
        int pos = 0;
        while (length - pos >= 16) {
            StringBuilder asciiBuf = new StringBuilder(17);
            buffer.append((CharSequence)indentBuf);
            buffer.append(StaticUtils.byteToHex(b[pos]));
            asciiBuf.append(StaticUtils.byteToASCII(b[pos]));
            ++pos;
            int i = 1;
            while (i < 16) {
                buffer.append(' ');
                buffer.append(StaticUtils.byteToHex(b[pos]));
                asciiBuf.append(StaticUtils.byteToASCII(b[pos]));
                if (i == 7) {
                    buffer.append("  ");
                    asciiBuf.append(' ');
                }
                ++i;
                ++pos;
            }
            buffer.append("  ");
            buffer.append((CharSequence)asciiBuf);
            buffer.append(ServerConstants.EOL);
        }
        int remaining = length - pos;
        if (remaining > 0) {
            StringBuilder asciiBuf = new StringBuilder(remaining + 1);
            buffer.append((CharSequence)indentBuf);
            buffer.append(StaticUtils.byteToHex(b[pos]));
            asciiBuf.append(StaticUtils.byteToASCII(b[pos]));
            ++pos;
            for (int i = 1; i < 16; ++i) {
                buffer.append(' ');
                if (i < remaining) {
                    buffer.append(StaticUtils.byteToHex(b[pos]));
                    asciiBuf.append(StaticUtils.byteToASCII(b[pos]));
                    ++pos;
                } else {
                    buffer.append("  ");
                }
                if (i != 7) continue;
                buffer.append("  ");
                if (i >= remaining) continue;
                asciiBuf.append(' ');
            }
            buffer.append("  ");
            buffer.append((CharSequence)asciiBuf);
            buffer.append(ServerConstants.EOL);
        }
    }

    public static void byteArrayToHexPlusAscii(StringBuilder buffer, ByteBuffer b, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        int position = b.position();
        int limit = b.limit();
        int length = limit - position;
        int pos = 0;
        while (length - pos >= 16) {
            StringBuilder asciiBuf = new StringBuilder(17);
            byte currentByte = b.get();
            buffer.append((CharSequence)indentBuf);
            buffer.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                currentByte = b.get();
                buffer.append(' ');
                buffer.append(StaticUtils.byteToHex(currentByte));
                asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                if (i == 7) {
                    buffer.append("  ");
                    asciiBuf.append(' ');
                }
                ++i;
                ++pos;
            }
            buffer.append("  ");
            buffer.append((CharSequence)asciiBuf);
            buffer.append(ServerConstants.EOL);
        }
        int remaining = length - pos;
        if (remaining > 0) {
            StringBuilder asciiBuf = new StringBuilder(remaining + 1);
            byte currentByte = b.get();
            buffer.append((CharSequence)indentBuf);
            buffer.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            for (int i = 1; i < 16; ++i) {
                buffer.append(' ');
                if (i < remaining) {
                    currentByte = b.get();
                    buffer.append(StaticUtils.byteToHex(currentByte));
                    asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                } else {
                    buffer.append("  ");
                }
                if (i != 7) continue;
                buffer.append("  ");
                if (i >= remaining) continue;
                asciiBuf.append(' ');
            }
            buffer.append("  ");
            buffer.append((CharSequence)asciiBuf);
            buffer.append(ServerConstants.EOL);
        }
        b.position(position);
        b.limit(limit);
    }

    public static String byteToBinary(byte b) {
        switch (b & 0xFF) {
            case 0: {
                return "00000000";
            }
            case 1: {
                return "00000001";
            }
            case 2: {
                return "00000010";
            }
            case 3: {
                return "00000011";
            }
            case 4: {
                return "00000100";
            }
            case 5: {
                return "00000101";
            }
            case 6: {
                return "00000110";
            }
            case 7: {
                return "00000111";
            }
            case 8: {
                return "00001000";
            }
            case 9: {
                return "00001001";
            }
            case 10: {
                return "00001010";
            }
            case 11: {
                return "00001011";
            }
            case 12: {
                return "00001100";
            }
            case 13: {
                return "00001101";
            }
            case 14: {
                return "00001110";
            }
            case 15: {
                return "00001111";
            }
            case 16: {
                return "00010000";
            }
            case 17: {
                return "00010001";
            }
            case 18: {
                return "00010010";
            }
            case 19: {
                return "00010011";
            }
            case 20: {
                return "00010100";
            }
            case 21: {
                return "00010101";
            }
            case 22: {
                return "00010110";
            }
            case 23: {
                return "00010111";
            }
            case 24: {
                return "00011000";
            }
            case 25: {
                return "00011001";
            }
            case 26: {
                return "00011010";
            }
            case 27: {
                return "00011011";
            }
            case 28: {
                return "00011100";
            }
            case 29: {
                return "00011101";
            }
            case 30: {
                return "00011110";
            }
            case 31: {
                return "00011111";
            }
            case 32: {
                return "00100000";
            }
            case 33: {
                return "00100001";
            }
            case 34: {
                return "00100010";
            }
            case 35: {
                return "00100011";
            }
            case 36: {
                return "00100100";
            }
            case 37: {
                return "00100101";
            }
            case 38: {
                return "00100110";
            }
            case 39: {
                return "00100111";
            }
            case 40: {
                return "00101000";
            }
            case 41: {
                return "00101001";
            }
            case 42: {
                return "00101010";
            }
            case 43: {
                return "00101011";
            }
            case 44: {
                return "00101100";
            }
            case 45: {
                return "00101101";
            }
            case 46: {
                return "00101110";
            }
            case 47: {
                return "00101111";
            }
            case 48: {
                return "00110000";
            }
            case 49: {
                return "00110001";
            }
            case 50: {
                return "00110010";
            }
            case 51: {
                return "00110011";
            }
            case 52: {
                return "00110100";
            }
            case 53: {
                return "00110101";
            }
            case 54: {
                return "00110110";
            }
            case 55: {
                return "00110111";
            }
            case 56: {
                return "00111000";
            }
            case 57: {
                return "00111001";
            }
            case 58: {
                return "00111010";
            }
            case 59: {
                return "00111011";
            }
            case 60: {
                return "00111100";
            }
            case 61: {
                return "00111101";
            }
            case 62: {
                return "00111110";
            }
            case 63: {
                return "00111111";
            }
            case 64: {
                return "01000000";
            }
            case 65: {
                return "01000001";
            }
            case 66: {
                return "01000010";
            }
            case 67: {
                return "01000011";
            }
            case 68: {
                return "01000100";
            }
            case 69: {
                return "01000101";
            }
            case 70: {
                return "01000110";
            }
            case 71: {
                return "01000111";
            }
            case 72: {
                return "01001000";
            }
            case 73: {
                return "01001001";
            }
            case 74: {
                return "01001010";
            }
            case 75: {
                return "01001011";
            }
            case 76: {
                return "01001100";
            }
            case 77: {
                return "01001101";
            }
            case 78: {
                return "01001110";
            }
            case 79: {
                return "01001111";
            }
            case 80: {
                return "01010000";
            }
            case 81: {
                return "01010001";
            }
            case 82: {
                return "01010010";
            }
            case 83: {
                return "01010011";
            }
            case 84: {
                return "01010100";
            }
            case 85: {
                return "01010101";
            }
            case 86: {
                return "01010110";
            }
            case 87: {
                return "01010111";
            }
            case 88: {
                return "01011000";
            }
            case 89: {
                return "01011001";
            }
            case 90: {
                return "01011010";
            }
            case 91: {
                return "01011011";
            }
            case 92: {
                return "01011100";
            }
            case 93: {
                return "01011101";
            }
            case 94: {
                return "01011110";
            }
            case 95: {
                return "01011111";
            }
            case 96: {
                return "01100000";
            }
            case 97: {
                return "01100001";
            }
            case 98: {
                return "01100010";
            }
            case 99: {
                return "01100011";
            }
            case 100: {
                return "01100100";
            }
            case 101: {
                return "01100101";
            }
            case 102: {
                return "01100110";
            }
            case 103: {
                return "01100111";
            }
            case 104: {
                return "01101000";
            }
            case 105: {
                return "01101001";
            }
            case 106: {
                return "01101010";
            }
            case 107: {
                return "01101011";
            }
            case 108: {
                return "01101100";
            }
            case 109: {
                return "01101101";
            }
            case 110: {
                return "01101110";
            }
            case 111: {
                return "01101111";
            }
            case 112: {
                return "01110000";
            }
            case 113: {
                return "01110001";
            }
            case 114: {
                return "01110010";
            }
            case 115: {
                return "01110011";
            }
            case 116: {
                return "01110100";
            }
            case 117: {
                return "01110101";
            }
            case 118: {
                return "01110110";
            }
            case 119: {
                return "01110111";
            }
            case 120: {
                return "01111000";
            }
            case 121: {
                return "01111001";
            }
            case 122: {
                return "01111010";
            }
            case 123: {
                return "01111011";
            }
            case 124: {
                return "01111100";
            }
            case 125: {
                return "01111101";
            }
            case 126: {
                return "01111110";
            }
            case 127: {
                return "01111111";
            }
            case 128: {
                return "10000000";
            }
            case 129: {
                return "10000001";
            }
            case 130: {
                return "10000010";
            }
            case 131: {
                return "10000011";
            }
            case 132: {
                return "10000100";
            }
            case 133: {
                return "10000101";
            }
            case 134: {
                return "10000110";
            }
            case 135: {
                return "10000111";
            }
            case 136: {
                return "10001000";
            }
            case 137: {
                return "10001001";
            }
            case 138: {
                return "10001010";
            }
            case 139: {
                return "10001011";
            }
            case 140: {
                return "10001100";
            }
            case 141: {
                return "10001101";
            }
            case 142: {
                return "10001110";
            }
            case 143: {
                return "10001111";
            }
            case 144: {
                return "10010000";
            }
            case 145: {
                return "10010001";
            }
            case 146: {
                return "10010010";
            }
            case 147: {
                return "10010011";
            }
            case 148: {
                return "10010100";
            }
            case 149: {
                return "10010101";
            }
            case 150: {
                return "10010110";
            }
            case 151: {
                return "10010111";
            }
            case 152: {
                return "10011000";
            }
            case 153: {
                return "10011001";
            }
            case 154: {
                return "10011010";
            }
            case 155: {
                return "10011011";
            }
            case 156: {
                return "10011100";
            }
            case 157: {
                return "10011101";
            }
            case 158: {
                return "10011110";
            }
            case 159: {
                return "10011111";
            }
            case 160: {
                return "10100000";
            }
            case 161: {
                return "10100001";
            }
            case 162: {
                return "10100010";
            }
            case 163: {
                return "10100011";
            }
            case 164: {
                return "10100100";
            }
            case 165: {
                return "10100101";
            }
            case 166: {
                return "10100110";
            }
            case 167: {
                return "10100111";
            }
            case 168: {
                return "10101000";
            }
            case 169: {
                return "10101001";
            }
            case 170: {
                return "10101010";
            }
            case 171: {
                return "10101011";
            }
            case 172: {
                return "10101100";
            }
            case 173: {
                return "10101101";
            }
            case 174: {
                return "10101110";
            }
            case 175: {
                return "10101111";
            }
            case 176: {
                return "10110000";
            }
            case 177: {
                return "10110001";
            }
            case 178: {
                return "10110010";
            }
            case 179: {
                return "10110011";
            }
            case 180: {
                return "10110100";
            }
            case 181: {
                return "10110101";
            }
            case 182: {
                return "10110110";
            }
            case 183: {
                return "10110111";
            }
            case 184: {
                return "10111000";
            }
            case 185: {
                return "10111001";
            }
            case 186: {
                return "10111010";
            }
            case 187: {
                return "10111011";
            }
            case 188: {
                return "10111100";
            }
            case 189: {
                return "10111101";
            }
            case 190: {
                return "10111110";
            }
            case 191: {
                return "10111111";
            }
            case 192: {
                return "11000000";
            }
            case 193: {
                return "11000001";
            }
            case 194: {
                return "11000010";
            }
            case 195: {
                return "11000011";
            }
            case 196: {
                return "11000100";
            }
            case 197: {
                return "11000101";
            }
            case 198: {
                return "11000110";
            }
            case 199: {
                return "11000111";
            }
            case 200: {
                return "11001000";
            }
            case 201: {
                return "11001001";
            }
            case 202: {
                return "11001010";
            }
            case 203: {
                return "11001011";
            }
            case 204: {
                return "11001100";
            }
            case 205: {
                return "11001101";
            }
            case 206: {
                return "11001110";
            }
            case 207: {
                return "11001111";
            }
            case 208: {
                return "11010000";
            }
            case 209: {
                return "11010001";
            }
            case 210: {
                return "11010010";
            }
            case 211: {
                return "11010011";
            }
            case 212: {
                return "11010100";
            }
            case 213: {
                return "11010101";
            }
            case 214: {
                return "11010110";
            }
            case 215: {
                return "11010111";
            }
            case 216: {
                return "11011000";
            }
            case 217: {
                return "11011001";
            }
            case 218: {
                return "11011010";
            }
            case 219: {
                return "11011011";
            }
            case 220: {
                return "11011100";
            }
            case 221: {
                return "11011101";
            }
            case 222: {
                return "11011110";
            }
            case 223: {
                return "11011111";
            }
            case 224: {
                return "11100000";
            }
            case 225: {
                return "11100001";
            }
            case 226: {
                return "11100010";
            }
            case 227: {
                return "11100011";
            }
            case 228: {
                return "11100100";
            }
            case 229: {
                return "11100101";
            }
            case 230: {
                return "11100110";
            }
            case 231: {
                return "11100111";
            }
            case 232: {
                return "11101000";
            }
            case 233: {
                return "11101001";
            }
            case 234: {
                return "11101010";
            }
            case 235: {
                return "11101011";
            }
            case 236: {
                return "11101100";
            }
            case 237: {
                return "11101101";
            }
            case 238: {
                return "11101110";
            }
            case 239: {
                return "11101111";
            }
            case 240: {
                return "11110000";
            }
            case 241: {
                return "11110001";
            }
            case 242: {
                return "11110010";
            }
            case 243: {
                return "11110011";
            }
            case 244: {
                return "11110100";
            }
            case 245: {
                return "11110101";
            }
            case 246: {
                return "11110110";
            }
            case 247: {
                return "11110111";
            }
            case 248: {
                return "11111000";
            }
            case 249: {
                return "11111001";
            }
            case 250: {
                return "11111010";
            }
            case 251: {
                return "11111011";
            }
            case 252: {
                return "11111100";
            }
            case 253: {
                return "11111101";
            }
            case 254: {
                return "11111110";
            }
            case 255: {
                return "11111111";
            }
        }
        return "????????";
    }

    public static int compare(byte[] a, byte[] a2) {
        if (a == a2) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        int minLength = Math.min(a.length, a2.length);
        for (int i = 0; i < minLength; ++i) {
            if (a[i] == a2[i]) continue;
            if (a[i] < a2[i]) {
                return -1;
            }
            if (a[i] <= a2[i]) continue;
            return 1;
        }
        return a.length - a2.length;
    }

    public static boolean listsAreEqual(List list1, List list2) {
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        int numElements = list1.size();
        if (numElements != list2.size()) {
            return false;
        }
        if (!(list1 instanceof RandomAccess) || !(list2 instanceof RandomAccess)) {
            return ((Object)list1).equals(list2);
        }
        for (int i = 0; i < numElements; ++i) {
            Object o1 = list1.get(i);
            Object o2 = list2.get(i);
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    public static boolean objectsAreEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String getExceptionMessage(Throwable t) {
        if (t instanceof IdentifiedException) {
            IdentifiedException ie = (IdentifiedException)t;
            StringBuilder message = new StringBuilder();
            message.append(ie.getMessage());
            message.append(" (id=");
            message.append(ie.getMessageID());
            message.append(")");
            return message.toString();
        }
        if (t instanceof NullPointerException) {
            StackTraceElement[] stackElements = t.getStackTrace();
            StringBuilder message = new StringBuilder();
            message.append("NullPointerException(");
            message.append(stackElements[0].getFileName());
            message.append(":");
            message.append(stackElements[0].getLineNumber());
            message.append(")");
            return message.toString();
        }
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return StaticUtils.getExceptionMessage(t.getCause());
        }
        StringBuilder message = new StringBuilder();
        String className = t.getClass().getName();
        int periodPos = className.lastIndexOf(46);
        if (periodPos > 0) {
            message.append(className.substring(periodPos + 1));
        } else {
            message.append(className);
        }
        message.append("(");
        if (t.getMessage() == null) {
            StackTraceElement[] stackElements = t.getStackTrace();
            message.append(stackElements[0].getFileName());
            message.append(":");
            message.append(stackElements[0].getLineNumber());
        } else {
            message.append(t.getMessage());
        }
        message.append(")");
        return message.toString();
    }

    public static String stackTraceToSingleLineString(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.stackTraceToSingleLineString(buffer, t);
        return buffer.toString();
    }

    public static void stackTraceToSingleLineString(StringBuilder buffer, Throwable t) {
        String message;
        if (t == null) {
            return;
        }
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if ((message = t.getMessage()) == null || message.length() == 0) {
            String className = t.getClass().getName();
            try {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            buffer.append(className);
        } else {
            buffer.append(message);
        }
        int i = 0;
        buffer.append("(");
        for (StackTraceElement e : t.getStackTrace()) {
            if (i > 20) {
                buffer.append(" ...");
                break;
            }
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(e.getFileName());
            buffer.append(":");
            buffer.append(e.getLineNumber());
            ++i;
        }
        buffer.append(")");
    }

    public static String stackTraceToString(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.stackTraceToString(buffer, t);
        return buffer.toString();
    }

    public static void stackTraceToString(StringBuilder buffer, Throwable t) {
        if (t == null) {
            return;
        }
        buffer.append(t);
        for (StackTraceElement e : t.getStackTrace()) {
            buffer.append(ServerConstants.EOL);
            buffer.append("  ");
            buffer.append(e.getClassName());
            buffer.append(".");
            buffer.append(e.getMethodName());
            buffer.append("(");
            buffer.append(e.getFileName());
            buffer.append(":");
            buffer.append(e.getLineNumber());
            buffer.append(")");
        }
        while (t.getCause() != null) {
            t = t.getCause();
            buffer.append(ServerConstants.EOL);
            buffer.append("Caused by ");
            buffer.append(t);
            for (StackTraceElement e : t.getStackTrace()) {
                buffer.append(ServerConstants.EOL);
                buffer.append("  ");
                buffer.append(e.getClassName());
                buffer.append(".");
                buffer.append(e.getMethodName());
                buffer.append("(");
                buffer.append(e.getFileName());
                buffer.append(":");
                buffer.append(e.getLineNumber());
                buffer.append(")");
            }
        }
        buffer.append(ServerConstants.EOL);
    }

    public static String getBacktrace() {
        StringBuilder buffer = new StringBuilder();
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length > 1) {
            buffer.append(elements[1].getFileName());
            buffer.append(":");
            buffer.append(elements[1].getLineNumber());
            for (int i = 2; i < elements.length; ++i) {
                buffer.append(" ");
                buffer.append(elements[i].getFileName());
                buffer.append(":");
                buffer.append(elements[i].getLineNumber());
            }
        }
        return buffer.toString();
    }

    public static String getBacktrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StackTraceElement[] elements = t.getStackTrace();
        if (elements.length > 0) {
            buffer.append(elements[0].getFileName());
            buffer.append(":");
            buffer.append(elements[0].getLineNumber());
            for (int i = 1; i < elements.length; ++i) {
                buffer.append(" ");
                buffer.append(elements[i].getFileName());
                buffer.append(":");
                buffer.append(elements[i].getLineNumber());
            }
        }
        return buffer.toString();
    }

    public static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static boolean isAlpha(char c) {
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                return true;
            }
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': {
                return false;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexDigit(byte b) {
        switch (b) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    public static byte[] hexStringToByteArray(String hexString) throws ParseException {
        int length;
        if (hexString == null || (length = hexString.length()) == 0) {
            return new byte[0];
        }
        if (length % 2 == 1) {
            int msgID = 0x530003;
            String message = MessageHandler.getMessage(msgID, hexString);
            throw new ParseException(message, 0);
        }
        int pos = 0;
        int arrayLength = length / 2;
        byte[] returnArray = new byte[arrayLength];
        block36: for (int i = 0; i < arrayLength; ++i) {
            switch (hexString.charAt(pos++)) {
                case '0': {
                    returnArray[i] = 0;
                    break;
                }
                case '1': {
                    returnArray[i] = 16;
                    break;
                }
                case '2': {
                    returnArray[i] = 32;
                    break;
                }
                case '3': {
                    returnArray[i] = 48;
                    break;
                }
                case '4': {
                    returnArray[i] = 64;
                    break;
                }
                case '5': {
                    returnArray[i] = 80;
                    break;
                }
                case '6': {
                    returnArray[i] = 96;
                    break;
                }
                case '7': {
                    returnArray[i] = 112;
                    break;
                }
                case '8': {
                    returnArray[i] = -128;
                    break;
                }
                case '9': {
                    returnArray[i] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    returnArray[i] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    returnArray[i] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    returnArray[i] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    returnArray[i] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    returnArray[i] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    returnArray[i] = -16;
                    break;
                }
                default: {
                    int msgID = 5439492;
                    String message = MessageHandler.getMessage(msgID, hexString, Character.valueOf(hexString.charAt(pos - 1)));
                    throw new ParseException(message, 0);
                }
            }
            switch (hexString.charAt(pos++)) {
                case '0': {
                    continue block36;
                }
                case '1': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 1);
                    continue block36;
                }
                case '2': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 2);
                    continue block36;
                }
                case '3': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 3);
                    continue block36;
                }
                case '4': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 4);
                    continue block36;
                }
                case '5': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 5);
                    continue block36;
                }
                case '6': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 6);
                    continue block36;
                }
                case '7': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 7);
                    continue block36;
                }
                case '8': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 8);
                    continue block36;
                }
                case '9': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 9);
                    continue block36;
                }
                case 'A': 
                case 'a': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xA);
                    continue block36;
                }
                case 'B': 
                case 'b': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xB);
                    continue block36;
                }
                case 'C': 
                case 'c': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xC);
                    continue block36;
                }
                case 'D': 
                case 'd': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xD);
                    continue block36;
                }
                case 'E': 
                case 'e': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xE);
                    continue block36;
                }
                case 'F': 
                case 'f': {
                    int n = i;
                    returnArray[n] = (byte)(returnArray[n] | 0xF);
                    continue block36;
                }
                default: {
                    int msgID = 5439492;
                    String message = MessageHandler.getMessage(msgID, hexString, Character.valueOf(hexString.charAt(pos - 1)));
                    throw new ParseException(message, 0);
                }
            }
        }
        return returnArray;
    }

    public static boolean needsBase64Encoding(byte[] valueBytes) {
        int length;
        if (valueBytes == null || (length = valueBytes.length) == 0) {
            return false;
        }
        switch (valueBytes[0]) {
            case 32: 
            case 58: 
            case 60: {
                return true;
            }
        }
        if (length > 1 && valueBytes[length - 1] == 32) {
            return true;
        }
        for (byte b : valueBytes) {
            if (b > 127 || b < 0) {
                return true;
            }
            switch (b) {
                case 0: 
                case 10: 
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean needsBase64Encoding(String valueString) {
        int length;
        if (valueString == null || (length = valueString.length()) == 0) {
            return false;
        }
        switch (valueString.charAt(0)) {
            case ' ': 
            case ':': 
            case '<': {
                return true;
            }
        }
        if (length > 1 && valueString.charAt(length - 1) == ' ') {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            if (c > '\u0000' && c != '\n' && c != '\r' && c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static boolean mayUseExec() {
        String s = System.getProperty("org.opends.server.DisableExec");
        if (s == null) {
            return true;
        }
        return (s = StaticUtils.toLowerCase(s)).equals("false") || s.equals("off") || s.equals("no") || s.equals("0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exec(String command, String[] args, File workingDirectory, Map<String, String> environment, List<String> output) throws IOException, SecurityException {
        if (!StaticUtils.mayUseExec()) {
            int msgID = 5439635;
            String message = MessageHandler.getMessage(msgID, String.valueOf(command));
            throw new SecurityException(message);
        }
        ArrayList<String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(command);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                commandAndArgs.add(arg);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandAndArgs);
        processBuilder.redirectErrorStream(true);
        if (workingDirectory != null && workingDirectory.isDirectory()) {
            processBuilder.directory(workingDirectory);
        }
        if (environment != null && !environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        Process process = processBuilder.start();
        if (output == null) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException ie) {
                block25: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                    try {
                        process.destroy();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block25;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                return process.exitValue();
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        finally {
            block27: {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block27;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        try {
            return process.waitFor();
        }
        catch (InterruptedException ie) {
            block28: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                try {
                    process.destroy();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block28;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            return process.exitValue();
        }
    }

    public static boolean isValidSchemaElement(String element, int startPos, int endPos, StringBuilder invalidReason) {
        if (element == null || startPos >= endPos) {
            int msgID = 5505056;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        char c = element.charAt(startPos);
        if (StaticUtils.isAlpha(c)) {
            for (int i = startPos + 1; i < endPos; ++i) {
                c = element.charAt(i);
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 5505057;
                invalidReason.append(MessageHandler.getMessage(msgID, element, Character.valueOf(c), i));
                return false;
            }
        } else if (StaticUtils.isDigit(c)) {
            boolean isKnown = !DirectoryServer.allowAttributeNameExceptions();
            boolean isNumeric = true;
            boolean lastWasDot = false;
            for (int i = startPos + 1; i < endPos; ++i) {
                c = element.charAt(i);
                if (c == '.') {
                    if (isKnown) {
                        if (isNumeric) {
                            if (lastWasDot) {
                                int msgID = 5505058;
                                invalidReason.append(MessageHandler.getMessage(msgID, element, i));
                                return false;
                            }
                            lastWasDot = true;
                            continue;
                        }
                        int msgID = 5505057;
                        invalidReason.append(MessageHandler.getMessage(msgID, element, Character.valueOf(c), i));
                        return false;
                    }
                    lastWasDot = true;
                    isKnown = true;
                    isNumeric = true;
                    continue;
                }
                lastWasDot = false;
                if (StaticUtils.isAlpha(c) || c == '-' || c == '_') {
                    if (isKnown) {
                        if (!isNumeric) continue;
                        int msgID = 5505057;
                        invalidReason.append(MessageHandler.getMessage(msgID, element, Character.valueOf(c), i));
                        return false;
                    }
                    isKnown = true;
                    isNumeric = false;
                    continue;
                }
                if (StaticUtils.isDigit(c)) continue;
                int msgID = 5505057;
                invalidReason.append(MessageHandler.getMessage(msgID, element, Character.valueOf(c), i));
                return false;
            }
        } else {
            int msgID = 5505057;
            invalidReason.append(MessageHandler.getMessage(msgID, element, Character.valueOf(c), startPos));
            return false;
        }
        return true;
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StaticUtils.toLowerCase(s, buffer);
        return buffer.toString();
    }

    public static void toLowerCase(String s, StringBuilder buffer) {
        if (s == null) {
            return;
        }
        int length = s.length();
        block28: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if ((c & 0x7F) != c) {
                buffer.append(s.substring(i).toLowerCase());
                return;
            }
            switch (c) {
                case 'A': {
                    buffer.append('a');
                    continue block28;
                }
                case 'B': {
                    buffer.append('b');
                    continue block28;
                }
                case 'C': {
                    buffer.append('c');
                    continue block28;
                }
                case 'D': {
                    buffer.append('d');
                    continue block28;
                }
                case 'E': {
                    buffer.append('e');
                    continue block28;
                }
                case 'F': {
                    buffer.append('f');
                    continue block28;
                }
                case 'G': {
                    buffer.append('g');
                    continue block28;
                }
                case 'H': {
                    buffer.append('h');
                    continue block28;
                }
                case 'I': {
                    buffer.append('i');
                    continue block28;
                }
                case 'J': {
                    buffer.append('j');
                    continue block28;
                }
                case 'K': {
                    buffer.append('k');
                    continue block28;
                }
                case 'L': {
                    buffer.append('l');
                    continue block28;
                }
                case 'M': {
                    buffer.append('m');
                    continue block28;
                }
                case 'N': {
                    buffer.append('n');
                    continue block28;
                }
                case 'O': {
                    buffer.append('o');
                    continue block28;
                }
                case 'P': {
                    buffer.append('p');
                    continue block28;
                }
                case 'Q': {
                    buffer.append('q');
                    continue block28;
                }
                case 'R': {
                    buffer.append('r');
                    continue block28;
                }
                case 'S': {
                    buffer.append('s');
                    continue block28;
                }
                case 'T': {
                    buffer.append('t');
                    continue block28;
                }
                case 'U': {
                    buffer.append('u');
                    continue block28;
                }
                case 'V': {
                    buffer.append('v');
                    continue block28;
                }
                case 'W': {
                    buffer.append('w');
                    continue block28;
                }
                case 'X': {
                    buffer.append('x');
                    continue block28;
                }
                case 'Y': {
                    buffer.append('y');
                    continue block28;
                }
                case 'Z': {
                    buffer.append('z');
                    continue block28;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }

    public static void toLowerCase(byte[] b, StringBuilder buffer, boolean trim) {
        int i;
        if (b == null) {
            return;
        }
        int length = b.length;
        block31: for (i = 0; i < length; ++i) {
            if ((b[i] & 0x7F) != b[i]) {
                try {
                    buffer.append(new String(b, i, length - i, "UTF-8").toLowerCase());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    buffer.append(new String(b, i, length - i).toLowerCase());
                }
                break;
            }
            int bufferLength = buffer.length();
            switch (b[i]) {
                case 32: {
                    if (trim && bufferLength == 0) continue block31;
                    buffer.append(' ');
                    continue block31;
                }
                case 65: {
                    buffer.append('a');
                    continue block31;
                }
                case 66: {
                    buffer.append('b');
                    continue block31;
                }
                case 67: {
                    buffer.append('c');
                    continue block31;
                }
                case 68: {
                    buffer.append('d');
                    continue block31;
                }
                case 69: {
                    buffer.append('e');
                    continue block31;
                }
                case 70: {
                    buffer.append('f');
                    continue block31;
                }
                case 71: {
                    buffer.append('g');
                    continue block31;
                }
                case 72: {
                    buffer.append('h');
                    continue block31;
                }
                case 73: {
                    buffer.append('i');
                    continue block31;
                }
                case 74: {
                    buffer.append('j');
                    continue block31;
                }
                case 75: {
                    buffer.append('k');
                    continue block31;
                }
                case 76: {
                    buffer.append('l');
                    continue block31;
                }
                case 77: {
                    buffer.append('m');
                    continue block31;
                }
                case 78: {
                    buffer.append('n');
                    continue block31;
                }
                case 79: {
                    buffer.append('o');
                    continue block31;
                }
                case 80: {
                    buffer.append('p');
                    continue block31;
                }
                case 81: {
                    buffer.append('q');
                    continue block31;
                }
                case 82: {
                    buffer.append('r');
                    continue block31;
                }
                case 83: {
                    buffer.append('s');
                    continue block31;
                }
                case 84: {
                    buffer.append('t');
                    continue block31;
                }
                case 85: {
                    buffer.append('u');
                    continue block31;
                }
                case 86: {
                    buffer.append('v');
                    continue block31;
                }
                case 87: {
                    buffer.append('w');
                    continue block31;
                }
                case 88: {
                    buffer.append('x');
                    continue block31;
                }
                case 89: {
                    buffer.append('y');
                    continue block31;
                }
                case 90: {
                    buffer.append('z');
                    continue block31;
                }
                default: {
                    buffer.append((char)b[i]);
                }
            }
        }
        if (trim) {
            for (i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' '; --i) {
                buffer.delete(i, i + 1);
            }
        }
    }

    public static String toUpperCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StaticUtils.toUpperCase(s, buffer);
        return buffer.toString();
    }

    public static void toUpperCase(String s, StringBuilder buffer) {
        if (s == null) {
            return;
        }
        int length = s.length();
        block28: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if ((c & 0x7F) != c) {
                buffer.append(s.substring(i).toUpperCase());
                return;
            }
            switch (c) {
                case 'a': {
                    buffer.append('A');
                    continue block28;
                }
                case 'b': {
                    buffer.append('B');
                    continue block28;
                }
                case 'c': {
                    buffer.append('C');
                    continue block28;
                }
                case 'd': {
                    buffer.append('D');
                    continue block28;
                }
                case 'e': {
                    buffer.append('E');
                    continue block28;
                }
                case 'f': {
                    buffer.append('F');
                    continue block28;
                }
                case 'g': {
                    buffer.append('G');
                    continue block28;
                }
                case 'h': {
                    buffer.append('H');
                    continue block28;
                }
                case 'i': {
                    buffer.append('I');
                    continue block28;
                }
                case 'j': {
                    buffer.append('J');
                    continue block28;
                }
                case 'k': {
                    buffer.append('K');
                    continue block28;
                }
                case 'l': {
                    buffer.append('L');
                    continue block28;
                }
                case 'm': {
                    buffer.append('M');
                    continue block28;
                }
                case 'n': {
                    buffer.append('N');
                    continue block28;
                }
                case 'o': {
                    buffer.append('O');
                    continue block28;
                }
                case 'p': {
                    buffer.append('P');
                    continue block28;
                }
                case 'q': {
                    buffer.append('Q');
                    continue block28;
                }
                case 'r': {
                    buffer.append('R');
                    continue block28;
                }
                case 's': {
                    buffer.append('S');
                    continue block28;
                }
                case 't': {
                    buffer.append('T');
                    continue block28;
                }
                case 'u': {
                    buffer.append('U');
                    continue block28;
                }
                case 'v': {
                    buffer.append('V');
                    continue block28;
                }
                case 'w': {
                    buffer.append('W');
                    continue block28;
                }
                case 'x': {
                    buffer.append('X');
                    continue block28;
                }
                case 'y': {
                    buffer.append('Y');
                    continue block28;
                }
                case 'z': {
                    buffer.append('Z');
                    continue block28;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }

    public static void toUpperCase(byte[] b, StringBuilder buffer, boolean trim) {
        int i;
        if (b == null) {
            return;
        }
        int length = b.length;
        block31: for (i = 0; i < length; ++i) {
            if ((b[i] & 0x7F) != b[i]) {
                try {
                    buffer.append(new String(b, i, length - i, "UTF-8").toUpperCase());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    buffer.append(new String(b, i, length - i).toUpperCase());
                }
                break;
            }
            int bufferLength = buffer.length();
            switch (b[i]) {
                case 32: {
                    if (trim && bufferLength == 0) continue block31;
                    buffer.append(' ');
                    continue block31;
                }
                case 97: {
                    buffer.append('A');
                    continue block31;
                }
                case 98: {
                    buffer.append('B');
                    continue block31;
                }
                case 99: {
                    buffer.append('C');
                    continue block31;
                }
                case 100: {
                    buffer.append('D');
                    continue block31;
                }
                case 101: {
                    buffer.append('E');
                    continue block31;
                }
                case 102: {
                    buffer.append('F');
                    continue block31;
                }
                case 103: {
                    buffer.append('G');
                    continue block31;
                }
                case 104: {
                    buffer.append('H');
                    continue block31;
                }
                case 105: {
                    buffer.append('I');
                    continue block31;
                }
                case 106: {
                    buffer.append('J');
                    continue block31;
                }
                case 107: {
                    buffer.append('K');
                    continue block31;
                }
                case 108: {
                    buffer.append('L');
                    continue block31;
                }
                case 109: {
                    buffer.append('M');
                    continue block31;
                }
                case 110: {
                    buffer.append('N');
                    continue block31;
                }
                case 111: {
                    buffer.append('O');
                    continue block31;
                }
                case 112: {
                    buffer.append('P');
                    continue block31;
                }
                case 113: {
                    buffer.append('Q');
                    continue block31;
                }
                case 114: {
                    buffer.append('R');
                    continue block31;
                }
                case 115: {
                    buffer.append('S');
                    continue block31;
                }
                case 116: {
                    buffer.append('T');
                    continue block31;
                }
                case 117: {
                    buffer.append('U');
                    continue block31;
                }
                case 118: {
                    buffer.append('V');
                    continue block31;
                }
                case 119: {
                    buffer.append('W');
                    continue block31;
                }
                case 120: {
                    buffer.append('X');
                    continue block31;
                }
                case 121: {
                    buffer.append('Y');
                    continue block31;
                }
                case 122: {
                    buffer.append('Z');
                    continue block31;
                }
                default: {
                    buffer.append((char)b[i]);
                }
            }
        }
        if (trim) {
            for (i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' '; --i) {
                buffer.delete(i, i + 1);
            }
        }
    }

    public static StringBuilder toRFC3641StringValue(StringBuilder builder, String string) {
        builder.append('\"');
        for (char c : string.toCharArray()) {
            if (c == '\"') {
                builder.append('\"');
            }
            builder.append(c);
        }
        builder.append('\"');
        return builder;
    }

    public static String[] listToArray(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        String[] stringArray = new String[stringList.size()];
        stringList.toArray(stringArray);
        return stringArray;
    }

    public static String listToString(List<?> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static ArrayList<String> arrayToList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>(stringArray.length);
        for (String s : stringArray) {
            stringList.add(s);
        }
        return stringList;
    }

    public static boolean recursiveDelete(File file) {
        File[] childList;
        boolean successful = true;
        if (file.isDirectory() && (childList = file.listFiles()) != null) {
            for (File f : childList) {
                successful &= StaticUtils.recursiveDelete(f);
            }
        }
        return successful & file.delete();
    }

    public static void moveFile(File fileToMove, File targetDirectory) throws IOException {
        int bytesRead;
        if (!fileToMove.exists()) {
            int msgID = 5505096;
            String message = MessageHandler.getMessage(msgID, fileToMove.getPath());
            throw new IOException(message);
        }
        if (!fileToMove.isFile()) {
            int msgID = 5505097;
            String message = MessageHandler.getMessage(msgID, fileToMove.getPath());
            throw new IOException(message);
        }
        if (!targetDirectory.exists()) {
            int msgID = 5505098;
            String message = MessageHandler.getMessage(msgID, targetDirectory.getPath());
            throw new IOException(message);
        }
        if (!targetDirectory.isDirectory()) {
            int msgID = 5505099;
            String message = MessageHandler.getMessage(msgID, targetDirectory.getPath());
            throw new IOException(message);
        }
        String newFilePath = targetDirectory.getPath() + File.separator + fileToMove.getName();
        FileInputStream inputStream = new FileInputStream(fileToMove);
        FileOutputStream outputStream = new FileOutputStream(newFilePath, false);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        fileToMove.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFile(File fileToRename, File target) throws IOException {
        if (fileToRename != null && target != null) {
            File file = target;
            synchronized (file) {
                if (target.exists() && !target.delete()) {
                    int msgID = 5505182;
                    String message = MessageHandler.getMessage(msgID, target.getPath());
                    throw new IOException(message);
                }
            }
            if (!fileToRename.renameTo(target)) {
                int msgID = 5505181;
                String message = MessageHandler.getMessage(msgID, fileToRename.getPath(), target.getPath());
                throw new IOException(message);
            }
        }
    }

    public static boolean isRelativePath(String path) {
        File f = new File(path);
        return !f.isAbsolute();
    }

    public static File getFileForPath(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(DirectoryServer.getServerRoot() + File.separator + path);
    }

    public static Entry createEntry(DN dn) {
        AttributeType attrType;
        if (dn == null || dn.isNullDN()) {
            return null;
        }
        RDN rdn = dn.getRDN();
        int numAVAs = rdn.getNumValues();
        ObjectClass structuralClass = numAVAs == 1 ? ((attrType = rdn.getAttributeType(0)).hasName("c") ? DirectoryServer.getObjectClass("country", true) : (attrType.hasName("dc") ? DirectoryServer.getObjectClass("domain", true) : (attrType.hasName("o") ? DirectoryServer.getObjectClass("organization", true) : (attrType.hasName("ou") ? DirectoryServer.getObjectClass("organizationalunit", true) : DirectoryServer.getObjectClass("untypedobject", true))))) : DirectoryServer.getObjectClass("untypedobject", true);
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>(3);
        objectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        objectClasses.put(structuralClass, structuralClass.getNameOrOID());
        LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        boolean extensibleObjectAdded = false;
        for (int i = 0; i < numAVAs; ++i) {
            Attribute attr;
            List<Attribute> attrList;
            AttributeType attrType2 = rdn.getAttributeType(i);
            AttributeValue attrValue = rdn.getAttributeValue(i);
            String attrName = rdn.getAttributeName(i);
            if (!structuralClass.isRequiredOrOptional(attrType2) && !extensibleObjectAdded) {
                ObjectClass extensibleObjectOC = DirectoryServer.getObjectClass("extensibleobject");
                if (extensibleObjectOC == null) {
                    extensibleObjectOC = DirectoryServer.getDefaultObjectClass("extensibleObject");
                }
                objectClasses.put(extensibleObjectOC, "extensibleObject");
                extensibleObjectAdded = true;
            }
            LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
            valueSet.add(attrValue);
            if (attrType2.isOperational()) {
                attrList = operationalAttributes.get(attrType2);
                if (attrList == null || attrList.isEmpty()) {
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(new Attribute(attrType2, attrName, valueSet));
                    operationalAttributes.put(attrType2, attrList);
                    continue;
                }
                attr = attrList.get(0);
                attr.getValues().add(attrValue);
                continue;
            }
            attrList = userAttributes.get(attrType2);
            if (attrList == null || attrList.isEmpty()) {
                attrList = new ArrayList<Attribute>(1);
                attrList.add(new Attribute(attrType2, attrName, valueSet));
                userAttributes.put(attrType2, attrList);
                continue;
            }
            attr = attrList.get(0);
            attr.getValues().add(attrValue);
        }
        return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
    }

    public static String secondsToTimeString(int numSeconds) {
        if (numSeconds < 60) {
            return MessageHandler.getMessage(5243005, numSeconds);
        }
        if (numSeconds < 3600) {
            int m = numSeconds / 60;
            int s = numSeconds % 60;
            return MessageHandler.getMessage(5243006, m, s);
        }
        if (numSeconds < 86400) {
            int h = numSeconds / 3600;
            int m = numSeconds % 3600 / 60;
            int s = numSeconds % 3600 % 60;
            return MessageHandler.getMessage(5243007, h, m, s);
        }
        int d = numSeconds / 86400;
        int h = numSeconds % 86400 / 3600;
        int m = numSeconds % 86400 % 3600 / 60;
        int s = numSeconds % 86400 % 3600 % 60;
        return MessageHandler.getMessage(0x500080, d, h, m, s);
    }

    public static String wrapText(String text, int width) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer lineTokenizer = new StringTokenizer(text, "\r\n", true);
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            if (line.equals("\r") || line.equals("\n")) {
                buffer.append(line);
                continue;
            }
            if (line.length() < width) {
                buffer.append(line);
                continue;
            }
            StringBuilder lineBuffer = new StringBuilder();
            StringBuilder delimBuffer = new StringBuilder();
            StringTokenizer wordTokenizer = new StringTokenizer(line, " ", true);
            while (wordTokenizer.hasMoreTokens()) {
                String word = wordTokenizer.nextToken();
                if (word.equals(" ")) {
                    if (lineBuffer.length() <= 0) continue;
                    delimBuffer.append(word);
                    continue;
                }
                if (word.length() > width) {
                    if (lineBuffer.length() > 0) {
                        buffer.append((CharSequence)lineBuffer);
                        buffer.append(ServerConstants.EOL);
                        lineBuffer = new StringBuilder();
                    }
                    buffer.append(word);
                    if (wordTokenizer.hasMoreTokens()) {
                        wordTokenizer.nextToken();
                        if (wordTokenizer.hasMoreTokens()) {
                            buffer.append(ServerConstants.EOL);
                        }
                    }
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                int newLineLength = lineBuffer.length() + delimBuffer.length() + word.length();
                if (newLineLength < width) {
                    lineBuffer.append((CharSequence)delimBuffer).append(word);
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                buffer.append((CharSequence)lineBuffer);
                buffer.append(ServerConstants.EOL);
                lineBuffer = new StringBuilder();
                lineBuffer.append(word);
                if (delimBuffer.length() <= 0) continue;
                delimBuffer = new StringBuilder();
            }
            buffer.append((CharSequence)lineBuffer);
        }
        return buffer.toString();
    }

    public static int filterExitCode(int exitCode) {
        if (exitCode < 0) {
            return 255;
        }
        if (exitCode > 255) {
            return 255;
        }
        return exitCode;
    }
}

