/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMailMessage {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<String> recipients;
    private LinkedList<MimeBodyPart> attachments;
    private String bodyMIMEType;
    private String sender;
    private String subject;
    private StringBuilder body;

    public EMailMessage(String sender, String recipient, String subject) {
        this.sender = sender;
        this.subject = subject;
        this.recipients = new ArrayList();
        this.recipients.add(recipient);
        this.body = new StringBuilder();
        this.attachments = new LinkedList();
        this.bodyMIMEType = "text/plain";
    }

    public EMailMessage(String sender, ArrayList<String> recipients, String subject) {
        this.sender = sender;
        this.recipients = recipients;
        this.subject = subject;
        this.body = new StringBuilder();
        this.attachments = new LinkedList();
        this.bodyMIMEType = "text/plain";
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public ArrayList<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ArrayList<String> recipients) {
        this.recipients = recipients;
    }

    public void addRecipient(String recipient) {
        this.recipients.add(recipient);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public StringBuilder getBody() {
        return this.body;
    }

    public void setBody(StringBuilder body) {
        this.body = body;
    }

    public void setBody(String bodyString) {
        this.body = new StringBuilder(bodyString);
    }

    public void appendToBody(String text) {
        this.body.append(text);
    }

    public LinkedList<MimeBodyPart> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(MimeBodyPart attachment) {
        this.attachments.add(attachment);
    }

    public void addAttachment(String attachmentText) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        attachment.setText(attachmentText);
        this.attachments.add(attachment);
    }

    public void addAttachment(File attachmentFile) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource dataSource = new FileDataSource(attachmentFile);
        attachment.setDataHandler(new DataHandler((DataSource)dataSource));
        this.attachments.add(attachment);
    }

    public void send() throws MessagingException {
        SendFailedException sendException = null;
        for (Properties props : DirectoryServer.getMailServerPropertySets()) {
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setSubject(this.subject);
            message.setSentDate(new Date());
            try {
                message.setFrom((Address)new InternetAddress(this.sender));
            }
            catch (MessagingException me) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, me);
                }
                int msgID = 5505100;
                String msg = MessageHandler.getMessage(msgID, String.valueOf(this.sender), me.getMessage());
                throw new MessagingException(msg, (Exception)((Object)me));
            }
            InternetAddress[] recipientAddresses = new InternetAddress[this.recipients.size()];
            for (int i = 0; i < recipientAddresses.length; ++i) {
                String recipient = this.recipients.get(i);
                try {
                    recipientAddresses[i] = new InternetAddress(recipient);
                    continue;
                }
                catch (MessagingException me) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, me);
                    }
                    int msgID = 5505101;
                    String msg = MessageHandler.getMessage(msgID, String.valueOf(recipient), me.getMessage());
                    throw new MessagingException(msg, (Exception)((Object)me));
                }
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses);
            if (this.attachments.isEmpty()) {
                message.setText(this.body.toString());
            } else {
                MimeMultipart multiPart = new MimeMultipart();
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setText(this.body.toString());
                multiPart.addBodyPart((BodyPart)bodyPart);
                for (MimeBodyPart attachment : this.attachments) {
                    multiPart.addBodyPart((BodyPart)attachment);
                }
            }
            try {
                Transport.send((Message)message);
                return;
            }
            catch (SendFailedException sfe) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, sfe);
                }
                if (sendException != null) continue;
                sendException = sfe;
            }
        }
        if (sendException == null) {
            int msgID = 5505102;
            String message = MessageHandler.getMessage(msgID);
            throw new MessagingException(message);
        }
        throw sendException;
    }
}

