/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.nio.ByteBuffer;
import java.text.ParseException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.Validator;

public final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static String encode(byte[] rawData) {
        Validator.ensureNotNull(rawData);
        StringBuilder buffer = new StringBuilder(4 * rawData.length / 3);
        int pos = 0;
        int iterations = rawData.length / 3;
        for (int i = 0; i < iterations; ++i) {
            int value = (rawData[pos++] & 0xFF) << 16 | (rawData[pos++] & 0xFF) << 8 | rawData[pos++] & 0xFF;
            buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value & 0x3F]);
        }
        switch (rawData.length % 3) {
            case 1: {
                buffer.append(BASE64_ALPHABET[rawData[pos] >>> 2 & 0x3F]);
                buffer.append(BASE64_ALPHABET[rawData[pos] << 4 & 0x3F]);
                buffer.append("==");
                break;
            }
            case 2: {
                int value = (rawData[pos++] & 0xFF) << 8 | rawData[pos] & 0xFF;
                buffer.append(BASE64_ALPHABET[value >>> 10 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 4 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value << 2 & 0x3F]);
                buffer.append("=");
            }
        }
        return buffer.toString();
    }

    public static byte[] decode(String encodedData) throws ParseException {
        Validator.ensureNotNull(encodedData);
        int length = encodedData.length();
        if (length % 4 != 0) {
            int msgID = 5439489;
            String message = MessageHandler.getMessage(msgID, encodedData);
            throw new ParseException(message, 0);
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        for (int i = 0; i < length; i += 4) {
            boolean append = true;
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                switch (encodedData.charAt(i + j)) {
                    case 'A': {
                        value <<= 6;
                        break;
                    }
                    case 'B': {
                        value = value << 6 | 1;
                        break;
                    }
                    case 'C': {
                        value = value << 6 | 2;
                        break;
                    }
                    case 'D': {
                        value = value << 6 | 3;
                        break;
                    }
                    case 'E': {
                        value = value << 6 | 4;
                        break;
                    }
                    case 'F': {
                        value = value << 6 | 5;
                        break;
                    }
                    case 'G': {
                        value = value << 6 | 6;
                        break;
                    }
                    case 'H': {
                        value = value << 6 | 7;
                        break;
                    }
                    case 'I': {
                        value = value << 6 | 8;
                        break;
                    }
                    case 'J': {
                        value = value << 6 | 9;
                        break;
                    }
                    case 'K': {
                        value = value << 6 | 0xA;
                        break;
                    }
                    case 'L': {
                        value = value << 6 | 0xB;
                        break;
                    }
                    case 'M': {
                        value = value << 6 | 0xC;
                        break;
                    }
                    case 'N': {
                        value = value << 6 | 0xD;
                        break;
                    }
                    case 'O': {
                        value = value << 6 | 0xE;
                        break;
                    }
                    case 'P': {
                        value = value << 6 | 0xF;
                        break;
                    }
                    case 'Q': {
                        value = value << 6 | 0x10;
                        break;
                    }
                    case 'R': {
                        value = value << 6 | 0x11;
                        break;
                    }
                    case 'S': {
                        value = value << 6 | 0x12;
                        break;
                    }
                    case 'T': {
                        value = value << 6 | 0x13;
                        break;
                    }
                    case 'U': {
                        value = value << 6 | 0x14;
                        break;
                    }
                    case 'V': {
                        value = value << 6 | 0x15;
                        break;
                    }
                    case 'W': {
                        value = value << 6 | 0x16;
                        break;
                    }
                    case 'X': {
                        value = value << 6 | 0x17;
                        break;
                    }
                    case 'Y': {
                        value = value << 6 | 0x18;
                        break;
                    }
                    case 'Z': {
                        value = value << 6 | 0x19;
                        break;
                    }
                    case 'a': {
                        value = value << 6 | 0x1A;
                        break;
                    }
                    case 'b': {
                        value = value << 6 | 0x1B;
                        break;
                    }
                    case 'c': {
                        value = value << 6 | 0x1C;
                        break;
                    }
                    case 'd': {
                        value = value << 6 | 0x1D;
                        break;
                    }
                    case 'e': {
                        value = value << 6 | 0x1E;
                        break;
                    }
                    case 'f': {
                        value = value << 6 | 0x1F;
                        break;
                    }
                    case 'g': {
                        value = value << 6 | 0x20;
                        break;
                    }
                    case 'h': {
                        value = value << 6 | 0x21;
                        break;
                    }
                    case 'i': {
                        value = value << 6 | 0x22;
                        break;
                    }
                    case 'j': {
                        value = value << 6 | 0x23;
                        break;
                    }
                    case 'k': {
                        value = value << 6 | 0x24;
                        break;
                    }
                    case 'l': {
                        value = value << 6 | 0x25;
                        break;
                    }
                    case 'm': {
                        value = value << 6 | 0x26;
                        break;
                    }
                    case 'n': {
                        value = value << 6 | 0x27;
                        break;
                    }
                    case 'o': {
                        value = value << 6 | 0x28;
                        break;
                    }
                    case 'p': {
                        value = value << 6 | 0x29;
                        break;
                    }
                    case 'q': {
                        value = value << 6 | 0x2A;
                        break;
                    }
                    case 'r': {
                        value = value << 6 | 0x2B;
                        break;
                    }
                    case 's': {
                        value = value << 6 | 0x2C;
                        break;
                    }
                    case 't': {
                        value = value << 6 | 0x2D;
                        break;
                    }
                    case 'u': {
                        value = value << 6 | 0x2E;
                        break;
                    }
                    case 'v': {
                        value = value << 6 | 0x2F;
                        break;
                    }
                    case 'w': {
                        value = value << 6 | 0x30;
                        break;
                    }
                    case 'x': {
                        value = value << 6 | 0x31;
                        break;
                    }
                    case 'y': {
                        value = value << 6 | 0x32;
                        break;
                    }
                    case 'z': {
                        value = value << 6 | 0x33;
                        break;
                    }
                    case '0': {
                        value = value << 6 | 0x34;
                        break;
                    }
                    case '1': {
                        value = value << 6 | 0x35;
                        break;
                    }
                    case '2': {
                        value = value << 6 | 0x36;
                        break;
                    }
                    case '3': {
                        value = value << 6 | 0x37;
                        break;
                    }
                    case '4': {
                        value = value << 6 | 0x38;
                        break;
                    }
                    case '5': {
                        value = value << 6 | 0x39;
                        break;
                    }
                    case '6': {
                        value = value << 6 | 0x3A;
                        break;
                    }
                    case '7': {
                        value = value << 6 | 0x3B;
                        break;
                    }
                    case '8': {
                        value = value << 6 | 0x3C;
                        break;
                    }
                    case '9': {
                        value = value << 6 | 0x3D;
                        break;
                    }
                    case '+': {
                        value = value << 6 | 0x3E;
                        break;
                    }
                    case '/': {
                        value = value << 6 | 0x3F;
                        break;
                    }
                    case '=': {
                        append = false;
                        switch (j) {
                            case 2: {
                                buffer.put((byte)(value >>> 4 & 0xFF));
                                break;
                            }
                            case 3: {
                                buffer.put((byte)(value >>> 10 & 0xFF));
                                buffer.put((byte)(value >>> 2 & 0xFF));
                            }
                        }
                        break;
                    }
                    default: {
                        int msgID = 5439490;
                        String message = MessageHandler.getMessage(msgID, encodedData, Character.valueOf(encodedData.charAt(i + j)));
                        throw new ParseException(message, i + j);
                    }
                }
                if (!append) break;
            }
            if (!append) break;
            buffer.put((byte)(value >>> 16 & 0xFF));
            buffer.put((byte)(value >>> 8 & 0xFF));
            buffer.put((byte)(value & 0xFF));
        }
        buffer.flip();
        byte[] returnArray = new byte[buffer.limit()];
        buffer.get(returnArray);
        return returnArray;
    }
}

