/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilterType;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType attributeType;
    private final AttributeValue assertionValue;
    private final boolean dnAttributes;
    private final ByteString subFinalElement;
    private final ByteString subInitialElement;
    private final FilterType filterType;
    private final List<ByteString> subAnyElements;
    private final LinkedHashSet<SearchFilter> filterComponents;
    private final SearchFilter notComponent;
    private final Set<String> attributeOptions;
    private final String matchingRuleID;

    public SearchFilter(FilterType filterType, Collection<SearchFilter> filterComponents, SearchFilter notComponent, AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement, String matchingRuleID, boolean dnAttributes) {
        if (subAnyElements == null) {
            subAnyElements = new ArrayList<ByteString>(0);
        }
        if (filterComponents == null) {
            filterComponents = Collections.emptyList();
        }
        this.filterType = filterType;
        this.filterComponents = new LinkedHashSet<SearchFilter>(filterComponents);
        this.notComponent = notComponent;
        this.attributeType = attributeType;
        this.attributeOptions = attributeOptions;
        this.assertionValue = assertionValue;
        this.subInitialElement = subInitialElement;
        this.subAnyElements = subAnyElements;
        this.subFinalElement = subFinalElement;
        this.matchingRuleID = matchingRuleID;
        this.dnAttributes = dnAttributes;
    }

    public static SearchFilter createANDFilter(Collection<SearchFilter> filterComponents) {
        return new SearchFilter(FilterType.AND, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createORFilter(Collection<SearchFilter> filterComponents) {
        return new SearchFilter(FilterType.OR, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createNOTFilter(SearchFilter notComponent) {
        return new SearchFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement) {
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, null, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, Set<String> attributeOptions, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement) {
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, attributeOptions, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType) {
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType, Set<String> attributeOptions) {
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, attributeOptions, null, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, AttributeValue assertionValue, String matchingRuleID, boolean dnAttributes) throws DirectoryException {
        if (attributeType == null && matchingRuleID == null) {
            int msgID = 262769;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, null, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue, String matchingRuleID, boolean dnAttributes) throws DirectoryException {
        if (attributeType == null && matchingRuleID == null) {
            int msgID = 262769;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, attributeOptions, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public static SearchFilter createFilterFromString(String filterString) throws DirectoryException {
        if (filterString == null) {
            int msgID = 196751;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        try {
            return SearchFilter.createFilterFromString(filterString, 0, filterString.length());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 196752;
            String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(e));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID, e);
        }
    }

    private static SearchFilter createFilterFromString(String filterString, int startPos, int endPos) throws DirectoryException {
        ASN1OctetString userValue;
        String valueStr;
        int i;
        int attrEndPos;
        FilterType filterType;
        char c;
        int length = endPos - startPos;
        if (length <= 0) {
            int msgID = 196751;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        if (filterString.charAt(startPos) == '(') {
            if (filterString.charAt(endPos - 1) == ')') {
                ++startPos;
                --endPos;
            } else {
                int msgID = 196753;
                String message = MessageHandler.getMessage(msgID, filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
        }
        if ((c = filterString.charAt(startPos)) == '&') {
            return SearchFilter.decodeCompoundFilter(FilterType.AND, filterString, startPos + 1, endPos);
        }
        if (c == '|') {
            return SearchFilter.decodeCompoundFilter(FilterType.OR, filterString, startPos + 1, endPos);
        }
        if (c == '!') {
            return SearchFilter.decodeCompoundFilter(FilterType.NOT, filterString, startPos + 1, endPos);
        }
        int equalPos = -1;
        for (int i2 = startPos; i2 < endPos; ++i2) {
            if (filterString.charAt(i2) != '=') continue;
            equalPos = i2;
            break;
        }
        if (equalPos <= startPos) {
            int msgID = 196754;
            String message = MessageHandler.getMessage(msgID, filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        switch (filterString.charAt(equalPos - 1)) {
            case '~': {
                filterType = FilterType.APPROXIMATE_MATCH;
                attrEndPos = equalPos - 1;
                break;
            }
            case '>': {
                filterType = FilterType.GREATER_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case '<': {
                filterType = FilterType.LESS_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case ':': {
                return SearchFilter.decodeExtensibleMatchFilter(filterString, startPos, equalPos, endPos);
            }
            default: {
                filterType = FilterType.EQUALITY;
                attrEndPos = equalPos;
            }
        }
        String attrType = filterString.substring(startPos, attrEndPos);
        StringBuilder lowerType = new StringBuilder(attrType.length());
        HashSet<String> attributeOptions = new HashSet<String>();
        int semicolonPos = attrType.indexOf(59);
        if (semicolonPos < 0) {
            for (i = 0; i < attrType.length(); ++i) {
                lowerType.append(Character.toLowerCase(attrType.charAt(i)));
            }
        } else {
            for (i = 0; i < semicolonPos; ++i) {
                lowerType.append(Character.toLowerCase(attrType.charAt(i)));
            }
            int nextPos = attrType.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                attributeOptions.add(attrType.substring(semicolonPos + 1, nextPos));
                semicolonPos = nextPos;
                nextPos = attrType.indexOf(59, semicolonPos + 1);
            }
            attributeOptions.add(attrType.substring(semicolonPos + 1));
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerType.toString());
        if (attributeType == null) {
            String typeStr = attrType.substring(0, lowerType.length());
            attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
        }
        if ((valueStr = filterString.substring(equalPos + 1, endPos)).length() == 0) {
            return new SearchFilter(filterType, null, null, attributeType, attributeOptions, new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString()), null, null, null, null, false);
        }
        if (valueStr.equals("*")) {
            return new SearchFilter(FilterType.PRESENT, null, null, attributeType, attributeOptions, null, null, null, null, null, false);
        }
        if (valueStr.indexOf(42) >= 0) {
            return SearchFilter.decodeSubstringFilter(filterString, attributeType, attributeOptions, equalPos, endPos);
        }
        boolean hasEscape = false;
        byte[] valueBytes = StaticUtils.getBytes(valueStr);
        for (int i3 = 0; i3 < valueBytes.length; ++i3) {
            if (valueBytes[i3] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueStr.length());
            for (int i4 = 0; i4 < valueBytes.length; ++i4) {
                if (valueBytes[i4] == 92) {
                    if (i4 + 2 >= valueBytes.length) {
                        int msgID = 196755;
                        String message = MessageHandler.getMessage(msgID, filterString, equalPos + i4 + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i4]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            int msgID = 196755;
                            String message = MessageHandler.getMessage(msgID, filterString, equalPos + i4 + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                        }
                    }
                    switch (valueBytes[++i4]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            int msgID = 196755;
                            String message = MessageHandler.getMessage(msgID, filterString, equalPos + i4 + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                        }
                    }
                    valueBuffer.put(byteValue);
                    continue;
                }
                valueBuffer.put(valueBytes[i4]);
            }
            valueBytes = new byte[valueBuffer.position()];
            valueBuffer.flip();
            valueBuffer.get(valueBytes);
            userValue = new ASN1OctetString(valueBytes);
        } else {
            userValue = new ASN1OctetString(valueBytes);
        }
        AttributeValue value = new AttributeValue(attributeType, (ByteString)userValue);
        return new SearchFilter(filterType, null, null, attributeType, attributeOptions, value, null, null, null, null, false);
    }

    private static SearchFilter decodeCompoundFilter(FilterType filterType, String filterString, int startPos, int endPos) throws DirectoryException {
        int msgID;
        ArrayList<SearchFilter> filterComponents = new ArrayList<SearchFilter>();
        if (startPos == endPos) {
            if (filterType == FilterType.NOT) {
                int msgID2 = 197210;
                String message = MessageHandler.getMessage(msgID2, filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID2);
            }
            return new SearchFilter(filterType, filterComponents, null, null, null, null, null, null, null, null, false);
        }
        if (filterString.charAt(startPos) != '(' || filterString.charAt(endPos - 1) != ')') {
            int msgID3 = 196756;
            String message = MessageHandler.getMessage(msgID3, filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID3);
        }
        int pendingOpens = 0;
        int openPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            char c = filterString.charAt(i);
            if (c == '(') {
                if (openPos < 0) {
                    openPos = i;
                }
                ++pendingOpens;
                continue;
            }
            if (c == ')') {
                if (--pendingOpens == 0) {
                    filterComponents.add(SearchFilter.createFilterFromString(filterString, openPos, i + 1));
                    openPos = -1;
                    continue;
                }
                if (pendingOpens >= 0) continue;
                int msgID4 = 196757;
                String message = MessageHandler.getMessage(msgID4, filterString, i);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID4);
            }
            if (pendingOpens > 0) continue;
            int msgID5 = 196756;
            String message = MessageHandler.getMessage(msgID5, filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID5);
        }
        if (pendingOpens != 0) {
            msgID = 196758;
            String message = MessageHandler.getMessage(msgID, filterString, openPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        if (filterType == FilterType.NOT) {
            if (filterComponents.size() != 1) {
                msgID = 197210;
                String message = MessageHandler.getMessage(msgID, filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
            SearchFilter notComponent = (SearchFilter)filterComponents.get(0);
            return new SearchFilter(filterType, null, notComponent, null, null, null, null, null, null, null, false);
        }
        return new SearchFilter(filterType, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    private static SearchFilter decodeSubstringFilter(String filterString, AttributeType attrType, Set<String> options, int equalPos, int endPos) throws DirectoryException {
        ASN1OctetString subFinal;
        int msgID;
        ASN1OctetString subInitial;
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        LinkedList<Integer> asteriskPositions = new LinkedList<Integer>();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 42) {
                asteriskPositions.add(i);
                continue;
            }
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
        }
        if (asteriskPositions.isEmpty()) {
            int msgID2 = 196759;
            String message = MessageHandler.getMessage(msgID2, filterString, equalPos + 1, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID2);
        }
        endPos = valueBytes.length;
        int firstPos = (Integer)asteriskPositions.removeFirst();
        if (firstPos == 0) {
            subInitial = null;
        } else if (hasEscape) {
            ByteBuffer buffer = ByteBuffer.allocate(firstPos);
            for (int i = 0; i < firstPos; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        int msgID3 = 196755;
                        String message = MessageHandler.getMessage(msgID3, filterString, equalPos + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID3);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            int msgID4 = 196755;
                            String message = MessageHandler.getMessage(msgID4, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID4);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            int msgID5 = 196755;
                            String message = MessageHandler.getMessage(msgID5, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID5);
                        }
                    }
                    buffer.put(byteValue);
                    continue;
                }
                buffer.put(valueBytes[i]);
            }
            byte[] subInitialBytes = new byte[buffer.position()];
            buffer.flip();
            buffer.get(subInitialBytes);
            subInitial = new ASN1OctetString(subInitialBytes);
        } else {
            byte[] subInitialBytes = new byte[firstPos];
            System.arraycopy(valueBytes, 0, subInitialBytes, 0, firstPos);
            subInitial = new ASN1OctetString(subInitialBytes);
        }
        ArrayList<ByteString> subAny = new ArrayList<ByteString>();
        Iterator i$ = asteriskPositions.iterator();
        while (i$.hasNext()) {
            int asteriskPos = (Integer)i$.next();
            int length = asteriskPos - firstPos - 1;
            if (hasEscape) {
                ByteBuffer buffer = ByteBuffer.allocate(length);
                for (int i = firstPos + 1; i < asteriskPos; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            msgID = 196755;
                            String message = MessageHandler.getMessage(msgID, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                int msgID6 = 196755;
                                String message = MessageHandler.getMessage(msgID6, filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID6);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                int msgID7 = 196755;
                                String message = MessageHandler.getMessage(msgID7, filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID7);
                            }
                        }
                        buffer.put(byteValue);
                        continue;
                    }
                    buffer.put(valueBytes[i]);
                }
                byte[] subAnyBytes = new byte[buffer.position()];
                buffer.flip();
                buffer.get(subAnyBytes);
                subAny.add(new ASN1OctetString(subAnyBytes));
            } else {
                byte[] subAnyBytes = new byte[length];
                System.arraycopy(valueBytes, firstPos + 1, subAnyBytes, 0, length);
                subAny.add(new ASN1OctetString(subAnyBytes));
            }
            firstPos = asteriskPos;
        }
        if (firstPos == endPos - 1) {
            subFinal = null;
        } else {
            int length = endPos - firstPos - 1;
            if (hasEscape) {
                ByteBuffer buffer = ByteBuffer.allocate(length);
                for (int i = firstPos + 1; i < endPos; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            int msgID8 = 196755;
                            String message = MessageHandler.getMessage(msgID8, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID8);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                msgID = 196755;
                                String message = MessageHandler.getMessage(msgID, filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                msgID = 196755;
                                String message = MessageHandler.getMessage(msgID, filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                            }
                        }
                        buffer.put(byteValue);
                        continue;
                    }
                    buffer.put(valueBytes[i]);
                }
                byte[] subFinalBytes = new byte[buffer.position()];
                buffer.flip();
                buffer.get(subFinalBytes);
                subFinal = new ASN1OctetString(subFinalBytes);
            } else {
                byte[] subFinalBytes = new byte[length];
                System.arraycopy(valueBytes, firstPos + 1, subFinalBytes, 0, length);
                subFinal = new ASN1OctetString(subFinalBytes);
            }
        }
        return new SearchFilter(FilterType.SUBSTRING, null, null, attrType, options, null, subInitial, subAny, subFinal, null, false);
    }

    private static SearchFilter decodeExtensibleMatchFilter(String filterString, int startPos, int equalPos, int endPos) throws DirectoryException {
        AttributeValue value;
        ASN1OctetString userValue;
        int msgID;
        AttributeType attributeType = null;
        HashSet<String> attributeOptions = new HashSet<String>();
        boolean dnAttributes = false;
        String matchingRuleID = null;
        String lowerLeftStr = StaticUtils.toLowerCase(filterString.substring(startPos, equalPos));
        if (filterString.charAt(startPos) == ':') {
            if (lowerLeftStr.startsWith(":dn:")) {
                dnAttributes = true;
                matchingRuleID = filterString.substring(startPos + 4, equalPos - 1);
            } else {
                matchingRuleID = filterString.substring(startPos + 1, equalPos - 1);
            }
        } else {
            int i;
            int colonPos = filterString.indexOf(58, startPos);
            if (colonPos < 0) {
                int msgID2 = 196760;
                String message = MessageHandler.getMessage(msgID2, filterString, startPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID2);
            }
            String attrType = filterString.substring(startPos, colonPos);
            StringBuilder lowerType = new StringBuilder(attrType.length());
            int semicolonPos = attrType.indexOf(59);
            if (semicolonPos < 0) {
                for (i = 0; i < attrType.length(); ++i) {
                    lowerType.append(Character.toLowerCase(attrType.charAt(i)));
                }
            } else {
                for (i = 0; i < semicolonPos; ++i) {
                    lowerType.append(Character.toLowerCase(attrType.charAt(i)));
                }
                int nextPos = attrType.indexOf(59, semicolonPos + 1);
                while (nextPos > 0) {
                    attributeOptions.add(attrType.substring(semicolonPos + 1, nextPos));
                    semicolonPos = nextPos;
                    nextPos = attrType.indexOf(59, semicolonPos + 1);
                }
                attributeOptions.add(attrType.substring(semicolonPos + 1));
            }
            attributeType = DirectoryServer.getAttributeType(lowerType.toString());
            if (attributeType == null) {
                String typeStr = attrType.substring(0, lowerType.length());
                attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
            }
            if (colonPos < equalPos - 1) {
                if (lowerLeftStr.startsWith(":dn:", colonPos)) {
                    dnAttributes = true;
                    if (colonPos + 4 < equalPos - 1) {
                        matchingRuleID = filterString.substring(colonPos + 4, equalPos - 1);
                    }
                } else {
                    matchingRuleID = filterString.substring(colonPos + 1, equalPos - 1);
                }
            }
        }
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueBytes.length);
            for (int i = 0; i < valueBytes.length; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        msgID = 196755;
                        String message = MessageHandler.getMessage(msgID, filterString, equalPos + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            int msgID3 = 196755;
                            String message = MessageHandler.getMessage(msgID3, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID3);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            int msgID4 = 196755;
                            String message = MessageHandler.getMessage(msgID4, filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID4);
                        }
                    }
                    valueBuffer.put(byteValue);
                    continue;
                }
                valueBuffer.put(valueBytes[i]);
            }
            valueBytes = new byte[valueBuffer.position()];
            valueBuffer.flip();
            valueBuffer.get(valueBytes);
            userValue = new ASN1OctetString(valueBytes);
        } else {
            userValue = new ASN1OctetString(valueBytes);
        }
        if (attributeType == null) {
            if (matchingRuleID == null) {
                int msgID5 = 262770;
                String message = MessageHandler.getMessage(msgID5, filterString, startPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID5);
            }
            MatchingRule mr = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(matchingRuleID));
            if (mr == null) {
                msgID = 262771;
                String message = MessageHandler.getMessage(msgID, filterString, startPos, matchingRuleID);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
            value = new AttributeValue(userValue, mr.normalizeValue(userValue));
        } else {
            value = new AttributeValue(attributeType, (ByteString)userValue);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, attributeOptions, value, null, null, null, matchingRuleID, dnAttributes);
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Set<SearchFilter> getFilterComponents() {
        return this.filterComponents;
    }

    public SearchFilter getNotComponent() {
        return this.notComponent;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public AttributeValue getAssertionValue() {
        return this.assertionValue;
    }

    public ByteString getSubInitialElement() {
        return this.subInitialElement;
    }

    public List<ByteString> getSubAnyElements() {
        return this.subAnyElements;
    }

    public ByteString getSubFinalElement() {
        return this.subFinalElement;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public boolean getDNAttributes() {
        return this.dnAttributes;
    }

    public boolean matchesEntry(Entry entry) throws DirectoryException {
        ConditionResult result = this.matchesEntryInternal(this, entry, 0);
        switch (result) {
            case TRUE: {
                return true;
            }
            case FALSE: 
            case UNDEFINED: {
                return false;
            }
        }
        int msgID = 196762;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), String.valueOf((Object)result));
        ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, message, msgID);
        return false;
    }

    private ConditionResult matchesEntryInternal(SearchFilter completeFilter, Entry entry, int depth) throws DirectoryException {
        switch (this.filterType) {
            case AND: {
                if (this.filterComponents == null) {
                    int msgID = 196763;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)this.filterType));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                if (this.filterComponents.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning TRUE for LDAP TRUE filter (&)");
                    }
                    return ConditionResult.TRUE;
                }
                if (depth >= 100) {
                    int msgID = 196764;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                block47: for (SearchFilter f : this.filterComponents) {
                    ConditionResult result = f.matchesEntryInternal(completeFilter, entry, depth + 1);
                    switch (result) {
                        case TRUE: {
                            continue block47;
                        }
                        case FALSE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning FALSE for AND component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                            }
                            return result;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Undefined result for AND component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                            }
                            return result;
                        }
                    }
                    int msgID = 196762;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning TRUE for AND component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                }
                return ConditionResult.TRUE;
            }
            case OR: {
                if (this.filterComponents == null) {
                    int msgID = 196763;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)this.filterType));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                if (this.filterComponents.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning FALSE for LDAP FALSE filter (|)");
                    }
                    return ConditionResult.FALSE;
                }
                if (depth >= 100) {
                    int msgID = 196764;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                ConditionResult result = ConditionResult.FALSE;
                block48: for (SearchFilter f : this.filterComponents) {
                    switch (f.matchesEntryInternal(completeFilter, entry, depth + 1)) {
                        case TRUE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning TRUE for OR component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                            }
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            continue block48;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Undefined result for OR component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                            }
                            result = ConditionResult.UNDEFINED;
                            continue block48;
                        }
                    }
                    int msgID = 196762;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning %s for OR component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
                }
                return result;
            }
            case NOT: {
                if (this.notComponent == null) {
                    int msgID = 196765;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                if (depth >= 100) {
                    int msgID = 196764;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
                }
                ConditionResult result = this.notComponent.matchesEntryInternal(completeFilter, entry, depth + 1);
                switch (result) {
                    case TRUE: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugVerbose("Returning FALSE for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                        }
                        return ConditionResult.FALSE;
                    }
                    case FALSE: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugVerbose("Returning TRUE for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                        }
                        return ConditionResult.TRUE;
                    }
                    case UNDEFINED: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Undefined result for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                        }
                        return ConditionResult.UNDEFINED;
                    }
                }
                int msgID = 196762;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            case EQUALITY: {
                if (this.attributeType == null) {
                    int msgID = 196766;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (this.assertionValue == null) {
                    int msgID = 196767;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (attrs == null || attrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for equality component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
                    }
                    return ConditionResult.FALSE;
                }
                for (Attribute a : attrs) {
                    if (!a.hasValue(this.assertionValue)) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for equality component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning FALSE for equality component %s in filter %s because entry %s didn't have attribute type %s with value %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID(), this.assertionValue.getStringValue());
                }
                return ConditionResult.FALSE;
            }
            case SUBSTRING: {
                if (this.attributeType == null) {
                    int msgID = 196768;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (this.subInitialElement == null && this.subFinalElement == null && (this.subAnyElements == null || this.subAnyElements.isEmpty())) {
                    int msgID = 196769;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (attrs == null || attrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for substring component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
                    }
                    return ConditionResult.FALSE;
                }
                ConditionResult result = ConditionResult.FALSE;
                for (Attribute a : attrs) {
                    switch (a.matchesSubstring(this.subInitialElement, this.subAnyElements, this.subFinalElement)) {
                        case TRUE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning TRUE for substring component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Undefined result encountered for substring component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning %s for substring component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
                }
                return result;
            }
            case GREATER_OR_EQUAL: {
                if (this.attributeType == null) {
                    int msgID = 196770;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (this.assertionValue == null) {
                    int msgID = 196771;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (attrs == null || attrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for greater-or-equal component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
                    }
                    return ConditionResult.FALSE;
                }
                ConditionResult result = ConditionResult.FALSE;
                for (Attribute a : attrs) {
                    switch (a.greaterThanOrEqualTo(this.assertionValue)) {
                        case TRUE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning TRUE for greater-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Undefined result encountered for greater-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning %s for greater-or-equal component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
                }
                return result;
            }
            case LESS_OR_EQUAL: {
                if (this.attributeType == null) {
                    int msgID = 196772;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (this.assertionValue == null) {
                    int msgID = 196773;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (attrs == null || attrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for less-or-equal component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
                    }
                    return ConditionResult.FALSE;
                }
                ConditionResult result = ConditionResult.FALSE;
                for (Attribute a : attrs) {
                    switch (a.lessThanOrEqualTo(this.assertionValue)) {
                        case TRUE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning TRUE for less-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Undefined result encountered for less-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning %s for less-or-equal component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
                }
                return result;
            }
            case PRESENT: {
                if (this.attributeType == null) {
                    int msgID = 196774;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (entry.hasAttribute(this.attributeType, this.attributeOptions)) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for presence component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning FALSE for presence component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                }
                return ConditionResult.FALSE;
            }
            case APPROXIMATE_MATCH: {
                if (this.attributeType == null) {
                    int msgID = 196775;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                if (this.assertionValue == null) {
                    int msgID = 196776;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                }
                List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (attrs == null || attrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for approximate component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
                    }
                    return ConditionResult.FALSE;
                }
                ConditionResult result = ConditionResult.FALSE;
                for (Attribute a : attrs) {
                    switch (a.approximatelyEqualTo(this.assertionValue)) {
                        case TRUE: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Returning TRUE for approximate component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugVerbose("Undefined result encountered for approximate component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                            }
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning %s for approximate component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
                }
                return result;
            }
            case EXTENSIBLE_MATCH: {
                return this.processExtensibleMatch(completeFilter, entry);
            }
        }
        int msgID = 196761;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), this.toString(), this.filterType.toString());
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
    }

    private ConditionResult processExtensibleMatch(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        ByteString normalizedValue;
        MatchingRuleUse mru;
        if (this.assertionValue == null) {
            int msgID = 196777;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
        }
        MatchingRule matchingRule = null;
        if (this.matchingRuleID != null) {
            matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
            if (matchingRule == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Unknown matching rule %s defined in extensibleMatch component of filter %s -- returning undefined.", this.matchingRuleID, this);
                }
                return ConditionResult.UNDEFINED;
            }
        } else {
            if (this.attributeType == null) {
                int msgID = 196778;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
            matchingRule = this.attributeType.getEqualityMatchingRule();
            if (matchingRule == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Attribute type %s does not have an equality matching rule -- returning undefined.", this.attributeType.getNameOrOID());
                }
                return ConditionResult.UNDEFINED;
            }
        }
        if (this.attributeType != null && (mru = DirectoryServer.getMatchingRuleUse(matchingRule)) != null && !mru.appliesToAttribute(this.attributeType)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Attribute type %s is not allowed for use with matching rule %s because of matching rule use definition %s", this.attributeType.getNameOrOID(), matchingRule.getNameOrOID(), mru.getName());
            }
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = matchingRule.normalizeValue(this.assertionValue.getValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        if (this.attributeType == null) {
            ConditionResult r;
            ByteString nv;
            for (List<Attribute> attrList : entry.getUserAttributes().values()) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a.getValues()) {
                        try {
                            nv = matchingRule.normalizeValue(v.getValue());
                            r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int msgID = 196762;
                                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            for (List<Attribute> attrList : entry.getOperationalAttributes().values()) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a.getValues()) {
                        try {
                            nv = matchingRule.normalizeValue(v.getValue());
                            r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int msgID = 196762;
                                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            Attribute a = entry.getObjectClassAttribute();
            for (AttributeValue v : a.getValues()) {
                try {
                    ByteString nv2 = matchingRule.normalizeValue(v.getValue());
                    ConditionResult r2 = matchingRule.valuesMatch(nv2, normalizedValue);
                    switch (r2) {
                        case TRUE: {
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                        default: {
                            int msgID = 196762;
                            String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r2));
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                        }
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
        } else {
            List<Attribute> attrList = entry.getAttribute(this.attributeType, this.attributeOptions);
            if (attrList != null) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a.getValues()) {
                        try {
                            ByteString nv = matchingRule.normalizeValue(v.getValue());
                            ConditionResult r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int msgID = 196762;
                                    String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
        }
        if (this.dnAttributes) {
            DN entryDN = entry.getDN();
            int count = entryDN.getNumComponents();
            for (int rdnIndex = 0; rdnIndex < count; ++rdnIndex) {
                RDN rdn = entryDN.getRDN(rdnIndex);
                int numAVAs = rdn.getNumValues();
                for (int i = 0; i < numAVAs; ++i) {
                    try {
                        if (this.attributeType != null && !this.attributeType.equals(rdn.getAttributeType(i))) continue;
                        AttributeValue v = rdn.getAttributeValue(i);
                        ByteString nv = matchingRule.normalizeValue(v.getValue());
                        ConditionResult r = matchingRule.valuesMatch(nv, normalizedValue);
                        switch (r) {
                            case TRUE: {
                                return ConditionResult.TRUE;
                            }
                            case FALSE: {
                                break;
                            }
                            case UNDEFINED: {
                                result = ConditionResult.UNDEFINED;
                                break;
                            }
                            default: {
                                int msgID = 196762;
                                String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        result = ConditionResult.UNDEFINED;
                    }
                }
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchFilter)) {
            return false;
        }
        SearchFilter f = (SearchFilter)o;
        if (this.filterType != f.filterType) {
            return false;
        }
        switch (this.filterType) {
            case AND: 
            case OR: {
                if (this.filterComponents.size() != f.filterComponents.size()) {
                    return false;
                }
                block19: for (SearchFilter outerFilter : this.filterComponents) {
                    for (SearchFilter innerFilter : f.filterComponents) {
                        if (!outerFilter.equals(innerFilter)) continue;
                        continue block19;
                    }
                    return false;
                }
                return true;
            }
            case NOT: {
                return this.notComponent.equals(f.notComponent);
            }
            case EQUALITY: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && this.assertionValue.equals(f.assertionValue);
            }
            case SUBSTRING: {
                if (!this.attributeType.equals(f.attributeType)) {
                    return false;
                }
                SubstringMatchingRule smr = this.attributeType.getSubstringMatchingRule();
                if (smr == null) {
                    return false;
                }
                if (!SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions)) {
                    return false;
                }
                if (this.subInitialElement == null) {
                    if (f.subInitialElement != null) {
                        return false;
                    }
                } else {
                    try {
                        ByteString nSI1 = smr.normalizeSubstring(this.subInitialElement);
                        ByteString nSI2 = smr.normalizeSubstring(f.subInitialElement);
                        if (!Arrays.equals(nSI1.value(), nSI2.value())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (this.subFinalElement == null) {
                    if (f.subFinalElement != null) {
                        return false;
                    }
                } else {
                    try {
                        ByteString nSF1 = smr.normalizeSubstring(this.subFinalElement);
                        ByteString nSF2 = smr.normalizeSubstring(f.subFinalElement);
                        if (!Arrays.equals(nSF1.value(), nSF2.value())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (this.subAnyElements.size() != f.subAnyElements.size()) {
                    return false;
                }
                for (int i = 0; i < this.subAnyElements.size(); ++i) {
                    try {
                        ByteString nSA1 = smr.normalizeSubstring(this.subAnyElements.get(i));
                        ByteString nSA2 = smr.normalizeSubstring(f.subAnyElements.get(i));
                        if (Arrays.equals(nSA1.value(), nSA2.value())) continue;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && this.assertionValue.equals(f.assertionValue);
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && this.assertionValue.equals(f.assertionValue);
            }
            case PRESENT: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions);
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && this.assertionValue.equals(f.assertionValue);
            }
            case EXTENSIBLE_MATCH: {
                if (this.attributeType == null) {
                    if (f.attributeType != null) {
                        return false;
                    }
                } else {
                    if (!this.attributeType.equals(f.attributeType)) {
                        return false;
                    }
                    if (!SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions)) {
                        return false;
                    }
                }
                if (this.dnAttributes != f.dnAttributes) {
                    return false;
                }
                if (this.matchingRuleID == null ? f.matchingRuleID != null : !this.matchingRuleID.equals(f.matchingRuleID)) {
                    return false;
                }
                if (this.assertionValue == null) {
                    if (f.assertionValue != null) {
                        return false;
                    }
                } else if (this.matchingRuleID == null) {
                    if (!this.assertionValue.equals(f.assertionValue)) {
                        return false;
                    }
                } else {
                    MatchingRule mr = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
                    if (mr == null) {
                        return false;
                    }
                    try {
                        ConditionResult cr = mr.valuesMatch(mr.normalizeValue(this.assertionValue.getValue()), mr.normalizeValue(f.assertionValue.getValue()));
                        if (cr != ConditionResult.TRUE) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean optionsEqual(Set<String> options1, Set<String> options2) {
        if (options1 == null || options1.isEmpty()) {
            return options2 == null || options2.isEmpty();
        }
        if (options2 == null || options2.isEmpty()) {
            return false;
        }
        if (options1.size() != options2.size()) {
            return false;
        }
        HashSet<String> lowerOptions = new HashSet<String>(options1.size());
        for (String option : options1) {
            lowerOptions.add(StaticUtils.toLowerCase(option));
        }
        for (String option : options2) {
            if (lowerOptions.remove(StaticUtils.toLowerCase(option))) continue;
            return false;
        }
        return lowerOptions.isEmpty();
    }

    public int hashCode() {
        switch (this.filterType) {
            case AND: 
            case OR: {
                int hashCode = 0;
                for (SearchFilter filterComp : this.filterComponents) {
                    hashCode += filterComp.hashCode();
                }
                return hashCode;
            }
            case NOT: {
                return this.notComponent.hashCode();
            }
            case EQUALITY: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case SUBSTRING: {
                int hashCode = this.attributeType.hashCode();
                SubstringMatchingRule smr = this.attributeType.getSubstringMatchingRule();
                if (this.subInitialElement != null) {
                    if (smr == null) {
                        hashCode += this.subInitialElement.hashCode();
                    } else {
                        try {
                            hashCode += smr.normalizeSubstring(this.subInitialElement).hashCode();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (this.subAnyElements != null) {
                    for (ByteString e : this.subAnyElements) {
                        if (smr == null) {
                            hashCode += e.hashCode();
                            continue;
                        }
                        try {
                            hashCode += smr.normalizeSubstring(e).hashCode();
                        }
                        catch (Exception e2) {}
                    }
                }
                if (this.subFinalElement != null) {
                    if (smr == null) {
                        hashCode += this.subFinalElement.hashCode();
                    } else {
                        try {
                            hashCode += smr.normalizeSubstring(this.subFinalElement).hashCode();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return hashCode;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case PRESENT: {
                return this.attributeType.hashCode();
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case EXTENSIBLE_MATCH: {
                int hashCode = 0;
                if (this.attributeType != null) {
                    hashCode += this.attributeType.hashCode();
                }
                if (this.dnAttributes) {
                    ++hashCode;
                }
                if (this.matchingRuleID != null) {
                    hashCode += this.matchingRuleID.hashCode();
                }
                if (this.assertionValue != null) {
                    hashCode += this.assertionValue.hashCode();
                }
                return hashCode;
            }
        }
        return 1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        switch (this.filterType) {
            case AND: {
                buffer.append("(&");
                for (SearchFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case OR: {
                buffer.append("(|");
                for (SearchFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case NOT: {
                buffer.append("(!");
                this.notComponent.toString(buffer);
                buffer.append(")");
                break;
            }
            case EQUALITY: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case SUBSTRING: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=");
                if (this.subInitialElement != null) {
                    this.valueToFilterString(buffer, this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ByteString s : this.subAnyElements) {
                        buffer.append("*");
                        this.valueToFilterString(buffer, s);
                    }
                }
                buffer.append("*");
                if (this.subFinalElement != null) {
                    this.valueToFilterString(buffer, this.subFinalElement);
                }
                buffer.append(")");
                break;
            }
            case GREATER_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append(">=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case LESS_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("<=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case PRESENT: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=*)");
                break;
            }
            case APPROXIMATE_MATCH: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("~=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case EXTENSIBLE_MATCH: {
                buffer.append("(");
                if (this.attributeType != null) {
                    buffer.append(this.attributeType.getNameOrOID());
                    if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                        for (String option : this.attributeOptions) {
                            buffer.append(";");
                            buffer.append(option);
                        }
                    }
                }
                if (this.dnAttributes) {
                    buffer.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    buffer.append(":");
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
            }
        }
    }

    private void valueToFilterString(StringBuilder buffer, ByteString value) {
        if (value == null) {
            return;
        }
        byte[] valueBytes = value.value();
        buffer.ensureCapacity(buffer.length() + valueBytes.length);
        for (byte b : valueBytes) {
            if ((b & 0x7F) != b || b <= 31 || b == 40 || b == 41 || b == 42 || b == 92 || b == 127) {
                buffer.append("\\");
                buffer.append(StaticUtils.byteToHex(b));
                continue;
            }
            buffer.append((char)b);
        }
    }
}

