/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResultCode {
    UNDEFINED(-1, -1),
    SUCCESS(0, 63),
    OPERATIONS_ERROR(1, 64),
    PROTOCOL_ERROR(2, 65),
    TIME_LIMIT_EXCEEDED(3, 66),
    SIZE_LIMIT_EXCEEDED(4, 67),
    COMPARE_FALSE(5, 68),
    COMPARE_TRUE(6, 69),
    AUTH_METHOD_NOT_SUPPORTED(7, 70),
    STRONG_AUTH_REQUIRED(8, 71),
    REFERRAL(10, 72),
    ADMIN_LIMIT_EXCEEDED(11, 73),
    UNAVAILABLE_CRITICAL_EXTENSION(12, 74),
    CONFIDENTIALITY_REQUIRED(13, 75),
    SASL_BIND_IN_PROGRESS(14, 76),
    NO_SUCH_ATTRIBUTE(16, 77),
    UNDEFINED_ATTRIBUTE_TYPE(17, 78),
    INAPPROPRIATE_MATCHING(18, 79),
    CONSTRAINT_VIOLATION(19, 80),
    ATTRIBUTE_OR_VALUE_EXISTS(20, 81),
    INVALID_ATTRIBUTE_SYNTAX(21, 82),
    NO_SUCH_OBJECT(32, 83),
    ALIAS_PROBLEM(33, 84),
    INVALID_DN_SYNTAX(34, 85),
    ALIAS_DEREFERENCING_PROBLEM(36, 86),
    INAPPROPRIATE_AUTHENTICATION(48, 87),
    INVALID_CREDENTIALS(49, 88),
    INSUFFICIENT_ACCESS_RIGHTS(50, 89),
    BUSY(51, 90),
    UNAVAILABLE(52, 91),
    UNWILLING_TO_PERFORM(53, 92),
    LOOP_DETECT(54, 93),
    SORT_CONTROL_MISSING(60, 608),
    OFFSET_RANGE_ERROR(61, 609),
    NAMING_VIOLATION(64, 94),
    OBJECTCLASS_VIOLATION(65, 95),
    NOT_ALLOWED_ON_NONLEAF(66, 96),
    NOT_ALLOWED_ON_RDN(67, 97),
    ENTRY_ALREADY_EXISTS(68, 98),
    OBJECTCLASS_MODS_PROHIBITED(69, 99),
    AFFECTS_MULTIPLE_DSAS(71, 100),
    VIRTUAL_LIST_VIEW_ERROR(76, 610),
    OTHER(80, 105),
    CLIENT_SIDE_SERVER_DOWN(81, 325),
    CLIENT_SIDE_LOCAL_ERROR(82, 326),
    CLIENT_SIDE_ENCODING_ERROR(83, 327),
    CLIENT_SIDE_DECODING_ERROR(84, 328),
    CLIENT_SIDE_TIMEOUT(85, 329),
    CLIENT_SIDE_AUTH_UNKNOWN(86, 330),
    CLIENT_SIDE_FILTER_ERROR(87, 331),
    CLIENT_SIDE_USER_CANCELLED(88, 332),
    CLIENT_SIDE_PARAM_ERROR(89, 333),
    CLIENT_SIDE_NO_MEMORY(90, 334),
    CLIENT_SIDE_CONNECT_ERROR(91, 335),
    CLIENT_SIDE_NOT_SUPPORTED(92, 336),
    CLIENT_SIDE_CONTROL_NOT_FOUND(93, 337),
    CLIENT_SIDE_NO_RESULTS_RETURNED(94, 338),
    CLIENT_SIDE_MORE_RESULTS_TO_RETURN(95, 339),
    CLIENT_SIDE_CLIENT_LOOP(96, 340),
    CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED(97, 341),
    CANCELED(118, 101),
    NO_SUCH_OPERATION(119, 102),
    TOO_LATE(120, 103),
    CANNOT_CANCEL(121, 104),
    ASSERTION_FAILED(122, 399),
    AUTHORIZATION_DENIED(123, 384),
    NO_OPERATION(16654, 624);

    private int intValue;
    private int resultCodeID;
    private String resultCodeName;

    private ResultCode(int intValue, int resultCodeID) {
        this.intValue = intValue;
        this.resultCodeID = resultCodeID;
        this.resultCodeName = null;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static ResultCode valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONS_ERROR;
            }
            case 2: {
                return PROTOCOL_ERROR;
            }
            case 3: {
                return TIME_LIMIT_EXCEEDED;
            }
            case 4: {
                return SIZE_LIMIT_EXCEEDED;
            }
            case 5: {
                return COMPARE_FALSE;
            }
            case 6: {
                return COMPARE_TRUE;
            }
            case 7: {
                return AUTH_METHOD_NOT_SUPPORTED;
            }
            case 8: {
                return STRONG_AUTH_REQUIRED;
            }
            case 10: {
                return REFERRAL;
            }
            case 11: {
                return ADMIN_LIMIT_EXCEEDED;
            }
            case 12: {
                return UNAVAILABLE_CRITICAL_EXTENSION;
            }
            case 13: {
                return CONFIDENTIALITY_REQUIRED;
            }
            case 14: {
                return SASL_BIND_IN_PROGRESS;
            }
            case 16: {
                return NO_SUCH_ATTRIBUTE;
            }
            case 17: {
                return UNDEFINED_ATTRIBUTE_TYPE;
            }
            case 18: {
                return INAPPROPRIATE_MATCHING;
            }
            case 19: {
                return CONSTRAINT_VIOLATION;
            }
            case 20: {
                return ATTRIBUTE_OR_VALUE_EXISTS;
            }
            case 21: {
                return INVALID_ATTRIBUTE_SYNTAX;
            }
            case 32: {
                return NO_SUCH_OBJECT;
            }
            case 33: {
                return ALIAS_PROBLEM;
            }
            case 34: {
                return INVALID_DN_SYNTAX;
            }
            case 36: {
                return ALIAS_DEREFERENCING_PROBLEM;
            }
            case 48: {
                return INAPPROPRIATE_AUTHENTICATION;
            }
            case 49: {
                return INVALID_CREDENTIALS;
            }
            case 50: {
                return INSUFFICIENT_ACCESS_RIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 52: {
                return UNAVAILABLE;
            }
            case 53: {
                return UNWILLING_TO_PERFORM;
            }
            case 54: {
                return LOOP_DETECT;
            }
            case 60: {
                return SORT_CONTROL_MISSING;
            }
            case 61: {
                return OFFSET_RANGE_ERROR;
            }
            case 64: {
                return NAMING_VIOLATION;
            }
            case 65: {
                return OBJECTCLASS_VIOLATION;
            }
            case 66: {
                return NOT_ALLOWED_ON_NONLEAF;
            }
            case 67: {
                return NOT_ALLOWED_ON_RDN;
            }
            case 68: {
                return ENTRY_ALREADY_EXISTS;
            }
            case 69: {
                return OBJECTCLASS_MODS_PROHIBITED;
            }
            case 71: {
                return AFFECTS_MULTIPLE_DSAS;
            }
            case 76: {
                return VIRTUAL_LIST_VIEW_ERROR;
            }
            case 81: {
                return CLIENT_SIDE_SERVER_DOWN;
            }
            case 82: {
                return CLIENT_SIDE_LOCAL_ERROR;
            }
            case 83: {
                return CLIENT_SIDE_ENCODING_ERROR;
            }
            case 84: {
                return CLIENT_SIDE_DECODING_ERROR;
            }
            case 85: {
                return CLIENT_SIDE_TIMEOUT;
            }
            case 86: {
                return CLIENT_SIDE_AUTH_UNKNOWN;
            }
            case 87: {
                return CLIENT_SIDE_FILTER_ERROR;
            }
            case 88: {
                return CLIENT_SIDE_USER_CANCELLED;
            }
            case 89: {
                return CLIENT_SIDE_PARAM_ERROR;
            }
            case 90: {
                return CLIENT_SIDE_NO_MEMORY;
            }
            case 91: {
                return CLIENT_SIDE_CONNECT_ERROR;
            }
            case 92: {
                return CLIENT_SIDE_NOT_SUPPORTED;
            }
            case 93: {
                return CLIENT_SIDE_CONTROL_NOT_FOUND;
            }
            case 94: {
                return CLIENT_SIDE_NO_RESULTS_RETURNED;
            }
            case 95: {
                return CLIENT_SIDE_MORE_RESULTS_TO_RETURN;
            }
            case 96: {
                return CLIENT_SIDE_CLIENT_LOOP;
            }
            case 97: {
                return CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED;
            }
            case 118: {
                return CANCELED;
            }
            case 119: {
                return NO_SUCH_OPERATION;
            }
            case 120: {
                return TOO_LATE;
            }
            case 121: {
                return CANNOT_CANCEL;
            }
            case 122: {
                return ASSERTION_FAILED;
            }
            case 123: {
                return AUTHORIZATION_DENIED;
            }
            case 16654: {
                return NO_OPERATION;
            }
        }
        return OTHER;
    }

    public int getResultCodeID() {
        return this.resultCodeID;
    }

    public String getResultCodeName() {
        if (this.resultCodeName == null) {
            this.resultCodeName = MessageHandler.getMessage(this.resultCodeID);
        }
        return this.resultCodeName;
    }

    public String toString() {
        return this.getResultCodeName();
    }
}

