/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilterType;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RawFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawFilter create(String filterString) throws LDAPException {
        return LDAPFilter.decode(filterString);
    }

    public static RawFilter create(SearchFilter filter) {
        return new LDAPFilter(filter);
    }

    public static LDAPFilter createANDFilter(ArrayList<RawFilter> filterComponents) {
        return new LDAPFilter(FilterType.AND, filterComponents, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createORFilter(ArrayList<RawFilter> filterComponents) {
        return new LDAPFilter(FilterType.OR, filterComponents, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createNOTFilter(RawFilter notComponent) {
        return new LDAPFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createEqualityFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.EQUALITY, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createSubstringFilter(String attributeType, ByteString subInitialElement, ArrayList<ByteString> subAnyElements, ByteString subFinalElement) {
        return new LDAPFilter(FilterType.SUBSTRING, null, null, attributeType, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static LDAPFilter createGreaterOrEqualFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createLessOrEqualFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createPresenceFilter(String attributeType) {
        return new LDAPFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, false);
    }

    public static LDAPFilter createApproximateFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createExtensibleFilter(String matchingRuleID, String attributeType, ByteString assertionValue, boolean dnAttributes) {
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public abstract FilterType getFilterType();

    public abstract ArrayList<RawFilter> getFilterComponents();

    public abstract void setFilterComponents(ArrayList<RawFilter> var1);

    public abstract RawFilter getNOTComponent();

    public abstract void setNOTComponent(RawFilter var1);

    public abstract String getAttributeType();

    public abstract void setAttributeType(String var1);

    public abstract ByteString getAssertionValue();

    public abstract void setAssertionValue(ByteString var1);

    public abstract ByteString getSubInitialElement();

    public abstract void setSubInitialElement(ByteString var1);

    public abstract ArrayList<ByteString> getSubAnyElements();

    public abstract void setSubAnyElements(ArrayList<ByteString> var1);

    public abstract ByteString getSubFinalElement();

    public abstract void setSubFinalElement(ByteString var1);

    public abstract String getMatchingRuleID();

    public abstract void setMatchingRuleID(String var1);

    public abstract boolean getDNAttributes();

    public abstract void setDNAttributes(boolean var1);

    public final ASN1Element encode() {
        FilterType filterType = this.getFilterType();
        switch (filterType) {
            case AND: 
            case OR: {
                ArrayList<RawFilter> filterComponents = this.getFilterComponents();
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(filterComponents.size());
                for (RawFilter f : filterComponents) {
                    elements.add(f.encode());
                }
                return new ASN1Set(filterType.getBERType(), elements);
            }
            case NOT: {
                return new ASN1Element(filterType.getBERType(), this.getNOTComponent().encode().encode());
            }
            case EQUALITY: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case APPROXIMATE_MATCH: {
                String attributeType = this.getAttributeType();
                ByteString assertionValue = this.getAssertionValue();
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
                elements.add(new ASN1OctetString(attributeType));
                elements.add(assertionValue.toASN1OctetString());
                return new ASN1Sequence(filterType.getBERType(), elements);
            }
            case SUBSTRING: {
                ByteString subFinalElement;
                ArrayList<ByteString> subAnyElements;
                String attributeType = this.getAttributeType();
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
                elements.add(new ASN1OctetString(attributeType));
                ByteString subInitialElement = this.getSubInitialElement();
                ArrayList<ASN1Element> subElements = new ArrayList<ASN1Element>();
                if (subInitialElement != null) {
                    ASN1OctetString subInitialOS = subInitialElement.toASN1OctetString();
                    subInitialOS.setType((byte)-128);
                    subElements.add(subInitialOS);
                }
                if ((subAnyElements = this.getSubAnyElements()) != null && !subAnyElements.isEmpty()) {
                    for (ByteString s : subAnyElements) {
                        ASN1OctetString os = s.toASN1OctetString();
                        os.setType((byte)-127);
                        subElements.add(os);
                    }
                }
                if ((subFinalElement = this.getSubFinalElement()) != null) {
                    ASN1OctetString subFinalOS = subFinalElement.toASN1OctetString();
                    subFinalOS.setType((byte)-126);
                    subElements.add(subFinalOS);
                }
                elements.add(new ASN1Sequence(subElements));
                return new ASN1Sequence(filterType.getBERType(), elements);
            }
            case PRESENT: {
                return new ASN1OctetString(filterType.getBERType(), this.getAttributeType());
            }
            case EXTENSIBLE_MATCH: {
                String attributeType;
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
                String matchingRuleID = this.getMatchingRuleID();
                if (matchingRuleID != null) {
                    elements.add(new ASN1OctetString(-127, matchingRuleID));
                }
                if ((attributeType = this.getAttributeType()) != null) {
                    elements.add(new ASN1OctetString(-126, attributeType));
                }
                ASN1OctetString assertionValueOS = this.getAssertionValue().toASN1OctetString();
                assertionValueOS.setType((byte)-125);
                elements.add(assertionValueOS);
                if (this.getDNAttributes()) {
                    elements.add(new ASN1Boolean(-124, true));
                }
                return new ASN1Sequence(filterType.getBERType(), elements);
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugError("Invalid search filter type: %s", new Object[]{filterType});
        }
        return null;
    }

    public static LDAPFilter decode(ASN1Element element) throws LDAPException {
        if (element == null) {
            int msgID = 2293898;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        switch (element.getType()) {
            case -96: 
            case -95: {
                return RawFilter.decodeCompoundFilter(element);
            }
            case -94: {
                return RawFilter.decodeNotFilter(element);
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                return RawFilter.decodeTypeAndValueFilter(element);
            }
            case -92: {
                return RawFilter.decodeSubstringFilter(element);
            }
            case -121: {
                return RawFilter.decodePresenceFilter(element);
            }
            case -87: {
                return RawFilter.decodeExtensibleMatchFilter(element);
            }
        }
        int msgID = 2293899;
        String message = MessageHandler.getMessage(msgID, element.getType());
        throw new LDAPException(2, msgID, message);
    }

    private static LDAPFilter decodeCompoundFilter(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        FilterType filterType;
        switch (element.getType()) {
            case -96: {
                filterType = FilterType.AND;
                break;
            }
            case -95: {
                filterType = FilterType.OR;
                break;
            }
            default: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Invalid filter type %x for a compound filter", element.getType());
                }
                filterType = null;
            }
        }
        try {
            elements = element.decodeAsSet().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293900;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ArrayList<RawFilter> filterComponents = new ArrayList<RawFilter>(elements.size());
        try {
            for (ASN1Element e : elements) {
                filterComponents.add(LDAPFilter.decode(e));
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293901;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(filterType, filterComponents, null, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeNotFilter(ASN1Element element) throws LDAPException {
        LDAPFilter notComponent;
        ASN1Element notFilterElement;
        try {
            notFilterElement = ASN1Element.decode(element.value());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293902;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            notComponent = RawFilter.decode(notFilterElement);
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293903;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeTypeAndValueFilter(ASN1Element element) throws LDAPException {
        ASN1OctetString assertionValue;
        String attributeType;
        ArrayList<ASN1Element> elements;
        FilterType filterType;
        switch (element.getType()) {
            case -93: {
                filterType = FilterType.EQUALITY;
                break;
            }
            case -91: {
                filterType = FilterType.GREATER_OR_EQUAL;
                break;
            }
            case -90: {
                filterType = FilterType.LESS_OR_EQUAL;
                break;
            }
            case -88: {
                filterType = FilterType.APPROXIMATE_MATCH;
                break;
            }
            default: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Invalid filter type %x for a type-and-value filter", element.getType());
                }
                filterType = null;
            }
        }
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293904;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        if (elements.size() != 2) {
            int msgID = 2293905;
            String message = MessageHandler.getMessage(msgID, elements.size());
            throw new LDAPException(2, msgID, message);
        }
        try {
            attributeType = elements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293906;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            assertionValue = elements.get(1).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293907;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(filterType, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    private static LDAPFilter decodeSubstringFilter(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> subElements;
        String attributeType;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293908;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        if (elements.size() != 2) {
            int msgID = 2293909;
            String message = MessageHandler.getMessage(msgID, elements.size());
            throw new LDAPException(2, msgID, message);
        }
        try {
            attributeType = elements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293910;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            subElements = elements.get(1).decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293911;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        if (subElements.isEmpty()) {
            int msgID = 2293912;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        ASN1OctetString subInitialElement = null;
        ASN1OctetString subFinalElement = null;
        ArrayList<ByteString> subAnyElements = null;
        try {
            block14: for (ASN1Element e : subElements) {
                switch (e.getType()) {
                    case -128: {
                        subInitialElement = e.decodeAsOctetString();
                        continue block14;
                    }
                    case -126: {
                        subFinalElement = e.decodeAsOctetString();
                        continue block14;
                    }
                    case -127: {
                        if (subAnyElements == null) {
                            subAnyElements = new ArrayList<ByteString>();
                        }
                        subAnyElements.add(e.decodeAsOctetString());
                        continue block14;
                    }
                }
                int msgID = 2293913;
                String message = MessageHandler.getMessage(msgID);
                throw new LDAPException(2, msgID, message);
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293914;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(FilterType.SUBSTRING, null, null, attributeType, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    private static LDAPFilter decodePresenceFilter(ASN1Element element) throws LDAPException {
        String attributeType;
        try {
            attributeType = element.decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293915;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeExtensibleMatchFilter(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293916;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ASN1OctetString assertionValue = null;
        boolean dnAttributes = false;
        String attributeType = null;
        String matchingRuleID = null;
        try {
            block11: for (ASN1Element e : elements) {
                switch (e.getType()) {
                    case -127: {
                        matchingRuleID = e.decodeAsOctetString().stringValue();
                        continue block11;
                    }
                    case -126: {
                        attributeType = e.decodeAsOctetString().stringValue();
                        continue block11;
                    }
                    case -125: {
                        assertionValue = e.decodeAsOctetString();
                        continue block11;
                    }
                    case -124: {
                        dnAttributes = e.decodeAsBoolean().booleanValue();
                        continue block11;
                    }
                }
                int msgID = 2293917;
                String message = MessageHandler.getMessage(msgID, e.getType());
                throw new LDAPException(2, msgID, message);
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293918;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public abstract SearchFilter toSearchFilter() throws DirectoryException;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public static void valueToFilterString(StringBuilder buffer, ByteString value) {
        if (value == null) {
            return;
        }
        byte[] valueBytes = value.value();
        buffer.ensureCapacity(buffer.length() + valueBytes.length);
        for (byte b : valueBytes) {
            if ((b & 0x7F) != b || b <= 31 || b == 40 || b == 41 || b == 42 || b == 92 || b == 127) {
                buffer.append("\\");
                buffer.append(StaticUtils.byteToHex(b));
                continue;
            }
            buffer.append((char)b);
        }
    }
}

