/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Random;
import java.util.SortedSet;
import org.opends.server.config.ConfigException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedCharacterSet {
    private char[] characters;
    private Random random;
    private String name;

    public NamedCharacterSet(String name, char[] characters) throws ConfigException {
        this.name = name;
        this.characters = characters;
        this.random = new Random();
        if (name == null || name.length() == 0) {
            int msgID = 5439609;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (StaticUtils.isAlpha(name.charAt(i))) continue;
            int msgID = 5439610;
            String message = MessageHandler.getMessage(msgID, String.valueOf(name.charAt(i)), i);
            throw new ConfigException(msgID, message);
        }
    }

    public NamedCharacterSet(String name, char[] characters, Random random) throws ConfigException {
        this.name = name;
        this.characters = characters;
        this.random = random;
        if (name == null || name.length() == 0) {
            int msgID = 5439609;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (StaticUtils.isAlpha(name.charAt(i))) continue;
            int msgID = 5439610;
            String message = MessageHandler.getMessage(msgID, String.valueOf(name.charAt(i)), i);
            throw new ConfigException(msgID, message);
        }
    }

    public String getName() {
        return this.name;
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public char getRandomCharacter() {
        if (this.characters == null || this.characters.length == 0) {
            return '\u0000';
        }
        return this.characters[this.random.nextInt(this.characters.length)];
    }

    public void getRandomCharacters(StringBuilder buffer, int count) {
        if (this.characters == null || this.characters.length == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            buffer.append(this.characters[this.random.nextInt(this.characters.length)]);
        }
    }

    public String encode() {
        return this.name + ":" + new String(this.characters);
    }

    public static NamedCharacterSet[] decodeCharacterSets(SortedSet<String> values) throws ConfigException {
        NamedCharacterSet[] sets = new NamedCharacterSet[values.size()];
        int i = 0;
        for (String value : values) {
            String message;
            int colonPos = value.indexOf(58);
            if (colonPos < 0) {
                int msgID = 5439608;
                message = MessageHandler.getMessage(msgID, String.valueOf(value));
                throw new ConfigException(msgID, message);
            }
            if (colonPos == 0) {
                int msgID = 5439611;
                message = MessageHandler.getMessage(msgID, String.valueOf(value));
                throw new ConfigException(msgID, message);
            }
            if (colonPos == value.length() - 1) {
                int msgID = 5439612;
                message = MessageHandler.getMessage(msgID, String.valueOf(value));
                throw new ConfigException(msgID, message);
            }
            String name = value.substring(0, colonPos);
            char[] characters = value.substring(colonPos + 1).toCharArray();
            sets[i] = new NamedCharacterSet(name, characters);
            ++i;
        }
        return sets;
    }
}

