/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.api.MatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.MatchingRuleUseSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingRuleUse
implements SchemaFileElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final boolean isObsolete;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> names;
    private final MatchingRule matchingRule;
    private final Set<AttributeType> attributes;
    private final String definition;
    private final String description;

    public MatchingRuleUse(String definition, MatchingRule matchingRule, Map<String, String> names, String description, boolean isObsolete, Set<AttributeType> attributes, Map<String, List<String>> extraProperties) {
        Validator.ensureNotNull(definition, matchingRule);
        this.matchingRule = matchingRule;
        this.description = description;
        this.isObsolete = isObsolete;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.names = names == null || names.isEmpty() ? new LinkedHashMap<String, String>(0) : new LinkedHashMap<String, String>(names);
        this.attributes = attributes == null || attributes.isEmpty() ? new LinkedHashSet<AttributeType>(0) : new LinkedHashSet<AttributeType>(attributes);
        this.extraProperties = extraProperties == null || extraProperties.isEmpty() ? new LinkedHashMap<String, List<String>>(0) : new LinkedHashMap<String, List<String>>(extraProperties);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public MatchingRuleUse recreateFromDefinition() throws DirectoryException {
        ByteString value = ByteStringFactory.create(this.definition);
        Schema schema = DirectoryConfig.getSchema();
        MatchingRuleUse mru = MatchingRuleUseSyntax.decodeMatchingRuleUse(value, schema, false);
        mru.setSchemaFile(this.getSchemaFile());
        return mru;
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public String getName() {
        if (this.names.isEmpty()) {
            return null;
        }
        return this.names.values().iterator().next();
    }

    public boolean hasName(String lowerName) {
        return this.names.containsKey(lowerName);
    }

    @Override
    public String getSchemaFile() {
        List<String> values = this.extraProperties.get("X-SCHEMA-FILE");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public void setSchemaFile(String schemaFile) {
        this.setExtraProperty("X-SCHEMA-FILE", schemaFile);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public Set<AttributeType> getAttributes() {
        return this.attributes;
    }

    public boolean appliesToAttribute(AttributeType attributeType) {
        return this.attributes.contains(attributeType);
    }

    public Map<String, List<String>> getExtraProperties() {
        return this.extraProperties;
    }

    public List<String> getExtraProperty(String propertyName) {
        return this.extraProperties.get(propertyName);
    }

    public void setExtraProperty(String name, String value) {
        Validator.ensureNotNull(name);
        if (value == null) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.extraProperties.put(name, values);
        }
    }

    public void setExtraProperty(String name, List<String> values) {
        Validator.ensureNotNull(name);
        if (values == null || values.isEmpty()) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> valuesCopy = new LinkedList<String>(values);
            this.extraProperties.put(name, valuesCopy);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MatchingRuleUse)) {
            return false;
        }
        return this.matchingRule.equals(((MatchingRuleUse)o).matchingRule);
    }

    public int hashCode() {
        return this.matchingRule.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean includeFileElement) {
        String firstName;
        Iterator<Object> iterator;
        buffer.append("( ");
        buffer.append(this.matchingRule.getOID());
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append((String)iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" APPLIES ");
        iterator = this.attributes.iterator();
        firstName = ((AttributeType)iterator.next()).getNameOrOID();
        if (iterator.hasNext()) {
            buffer.append("( ");
            buffer.append(firstName);
            while (iterator.hasNext()) {
                buffer.append(" $ ");
                buffer.append(((AttributeType)iterator.next()).getNameOrOID());
            }
            buffer.append(" )");
        } else {
            buffer.append(firstName);
        }
        if (!this.extraProperties.isEmpty()) {
            for (String property : this.extraProperties.keySet()) {
                if (!includeFileElement && property.equals("X-SCHEMA-FILE")) continue;
                List<String> valueList = this.extraProperties.get(property);
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
    }
}

