/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.DN;
import org.opends.server.types.IdentifiedException;

public class LDAPException
extends IdentifiedException {
    private static final long serialVersionUID = -7273984376022613884L;
    private final DN matchedDN;
    private final int messageID;
    private final int resultCode;
    private final String errorMessage;

    public LDAPException(int resultCode, int messageID, String message) {
        super(message);
        this.resultCode = resultCode;
        this.messageID = messageID;
        this.errorMessage = null;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, String errorMessage, int messageID, String message) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.messageID = messageID;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, int messageID, String message, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.messageID = messageID;
        this.errorMessage = null;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, String errorMessage, int messageID, String message, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.messageID = messageID;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, String errorMessage, int messageID, String message, DN matchedDN, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.messageID = messageID;
        this.matchedDN = matchedDN;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }
}

