/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashMap;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorLogCategory {
    ACCESS_CONTROL(39),
    BACKEND(40),
    CONFIGURATION(41),
    CONNECTION_HANDLING(42),
    CORE_SERVER(43),
    EXTENDED_OPERATION(45),
    EXTENSIONS(137),
    PASSWORD_POLICY(546),
    PLUGIN(46),
    REQUEST_HANDLING(47),
    SASL_MECHANISM(48),
    SCHEMA(124),
    SHUTDOWN(49),
    STARTUP(50),
    SYNCHRONIZATION(51),
    TASK(345);

    private static HashMap<String, ErrorLogCategory> nameMap;
    private int categoryID;
    private String categoryName;

    private ErrorLogCategory(int categoryID) {
        this.categoryID = categoryID;
        this.categoryName = null;
    }

    public static ErrorLogCategory getByName(String name) {
        return nameMap.get(name);
    }

    public int getCategoryID() {
        return this.categoryID;
    }

    public String getCategoryName() {
        if (this.categoryName == null) {
            this.categoryName = MessageHandler.getMessage(this.categoryID);
        }
        return this.categoryName;
    }

    public String toString() {
        return this.getCategoryName();
    }

    static {
        nameMap = new HashMap(16);
        nameMap.put("ACCESS_CONTROL", ACCESS_CONTROL);
        nameMap.put("BACKEND", BACKEND);
        nameMap.put("CONFIG", CONFIGURATION);
        nameMap.put("CONNECTION", CONNECTION_HANDLING);
        nameMap.put("CORE", CORE_SERVER);
        nameMap.put("EXTENDED_OP", EXTENDED_OPERATION);
        nameMap.put("EXTENTIONS", EXTENSIONS);
        nameMap.put("PW_POLICY", PASSWORD_POLICY);
        nameMap.put("PLUGIN", PLUGIN);
        nameMap.put("REQUEST", REQUEST_HANDLING);
        nameMap.put("SASL", SASL_MECHANISM);
        nameMap.put("SCHEMA", SCHEMA);
        nameMap.put("SHUTDOWN", SHUTDOWN);
        nameMap.put("STARTUP", STARTUP);
        nameMap.put("SYNC", SYNCHRONIZATION);
        nameMap.put("TASK", TASK);
    }
}

