/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeValueIterable
implements Iterable<AttributeValue> {
    private Iterable<Attribute> attributes;
    private HashSet<String> options;

    public AttributeValueIterable(Iterable<Attribute> attributes) {
        this(attributes, null);
    }

    public AttributeValueIterable(Iterable<Attribute> attributes, HashSet<String> options) {
        this.attributes = attributes;
        this.options = options;
    }

    @Override
    public Iterator<AttributeValue> iterator() {
        return new AttributeValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeValueIterator
    implements Iterator<AttributeValue> {
        private boolean hasNext;
        private Iterator<Attribute> attributeIterator;
        private Iterator<AttributeValue> valueIterator = null;

        private AttributeValueIterator() {
            if (AttributeValueIterable.this.attributes != null) {
                this.attributeIterator = AttributeValueIterable.this.attributes.iterator();
                this.hasNext = this.skipNonMatchingAttributes();
            } else {
                this.attributeIterator = null;
                this.hasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public AttributeValue next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            AttributeValue value = this.valueIterator.next();
            if (!this.valueIterator.hasNext()) {
                this.hasNext = this.skipNonMatchingAttributes();
            }
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean skipNonMatchingAttributes() {
            while (this.attributeIterator.hasNext()) {
                Attribute attribute = this.attributeIterator.next();
                if (!attribute.hasOptions(AttributeValueIterable.this.options)) continue;
                this.valueIterator = attribute.getValues().iterator();
                if (!this.valueIterator.hasNext()) continue;
                return true;
            }
            return false;
        }
    }
}

