/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnderscoreDNTag
extends Tag {
    private int numComponents = 0;

    @Override
    public String getName() {
        return "_DN";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber) throws InitializationException {
        if (arguments.length == 0) {
            this.numComponents = 0;
        } else if (arguments.length == 1) {
            try {
                this.numComponents = Integer.parseInt(arguments[0]);
            }
            catch (NumberFormatException nfe) {
                int msgID = 10682907;
                String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber);
                throw new InitializationException(msgID, message);
            }
        } else {
            int msgID = 10682904;
            String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 0, 1, arguments.length);
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN dn = templateEntry.getDN();
        if (dn == null || dn.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.numComponents == 0) {
            dn.getRDN(0).toString(templateValue.getValue());
            for (int i = 1; i < dn.getNumComponents(); ++i) {
                templateValue.append("_");
                dn.getRDN(i).toString(templateValue.getValue());
            }
        } else if (this.numComponents > 0) {
            int count = Math.min(this.numComponents, dn.getNumComponents());
            dn.getRDN(0).toString(templateValue.getValue());
            for (int i = 1; i < count; ++i) {
                templateValue.append("_");
                dn.getRDN(i).toString(templateValue.getValue());
            }
        } else {
            int sz = dn.getNumComponents();
            int count = Math.min(Math.abs(this.numComponents), sz);
            dn.getRDN(sz - count).toString(templateValue.getValue());
            for (int i = 1; i < count; ++i) {
                templateValue.append("_");
                dn.getRDN(sz - count + i).toString(templateValue.getValue());
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

