/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEntry {
    private Branch branch;
    private DN dn;
    private DN parentDN;
    private LinkedHashMap<AttributeType, ArrayList<TemplateValue>> attributes;
    private Template template;

    public TemplateEntry(Branch branch) {
        this.branch = branch;
        this.dn = branch.getBranchDN();
        this.template = null;
        this.parentDN = null;
        this.attributes = new LinkedHashMap();
    }

    public TemplateEntry(Template template, DN parentDN) {
        this.template = template;
        this.parentDN = parentDN;
        this.dn = null;
        this.branch = null;
        this.attributes = new LinkedHashMap();
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Template getTemplate() {
        return this.template;
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public DN getDN() {
        if (this.dn == null) {
            RDN rdn;
            AttributeType[] rdnAttrs = this.template.getRDNAttributes();
            if (rdnAttrs.length == 1) {
                AttributeType t = rdnAttrs[0];
                TemplateValue v = this.getValue(t);
                if (v == null) {
                    return null;
                }
                AttributeValue value = new AttributeValue(t, v.getValue().toString());
                rdn = new RDN(t, value);
            } else {
                String[] names = new String[rdnAttrs.length];
                AttributeValue[] values = new AttributeValue[rdnAttrs.length];
                for (int i = 0; i < rdnAttrs.length; ++i) {
                    AttributeType t = rdnAttrs[i];
                    TemplateValue v = this.getValue(t);
                    if (v == null) {
                        return null;
                    }
                    names[i] = t.getPrimaryName();
                    values[i] = new AttributeValue(t, v.getValue().toString());
                }
                rdn = new RDN(rdnAttrs, names, values);
            }
            this.dn = this.parentDN.concat(rdn);
        }
        return this.dn;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.containsKey(attributeType);
    }

    public TemplateValue getValue(AttributeType attributeType) {
        ArrayList<TemplateValue> valueList = this.attributes.get(attributeType);
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return valueList.get(0);
    }

    public List<TemplateValue> getValues(AttributeType attributeType) {
        ArrayList<TemplateValue> valueList = this.attributes.get(attributeType);
        return valueList;
    }

    public void addValue(TemplateValue value) {
        ArrayList<TemplateValue> valueList = this.attributes.get(value.getAttributeType());
        if (valueList == null) {
            valueList = new ArrayList();
            valueList.add(value);
            this.attributes.put(value.getAttributeType(), valueList);
        } else {
            valueList.add(value);
        }
    }

    public Entry toEntry() {
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
        LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        for (AttributeType t : this.attributes.keySet()) {
            ArrayList<Attribute> attrList;
            LinkedHashSet<AttributeValue> values;
            ArrayList<TemplateValue> valueList = this.attributes.get(t);
            if (t.isObjectClassType()) {
                for (TemplateValue v : valueList) {
                    String ocName = StaticUtils.toLowerCase(v.getValue().toString());
                    ObjectClass oc = DirectoryServer.getObjectClass(ocName, true);
                    objectClasses.put(oc, ocName);
                }
                continue;
            }
            if (t.isOperational()) {
                values = new LinkedHashSet<AttributeValue>();
                for (TemplateValue v : valueList) {
                    values.add(new AttributeValue(t, v.getValue().toString()));
                }
                attrList = new ArrayList<Attribute>(1);
                attrList.add(new Attribute(t, t.getNameOrOID(), values));
                operationalAttributes.put(t, attrList);
                continue;
            }
            values = new LinkedHashSet();
            for (TemplateValue v : valueList) {
                values.add(new AttributeValue(t, v.getValue().toString()));
            }
            attrList = new ArrayList(1);
            attrList.add(new Attribute(t, t.getNameOrOID(), values));
            userAttributes.put(t, attrList);
        }
        return new Entry(this.getDN(), objectClasses, userAttributes, operationalAttributes);
    }
}

