/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class MakeLDIF
implements EntryWriter {
    private static final String CLASS_NAME = "org.opends.server.tools.makeldif.MakeLDIF";
    private LDIFWriter ldifWriter = null;
    private long entriesWritten = 0L;

    public static void main(String[] args) {
        MakeLDIF makeLDIF = new MakeLDIF();
        int returnCode = makeLDIF.makeLDIFMain(args);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int makeLDIFMain(String[] args) {
        File resourceDir;
        Random random;
        IntegerArgument randomSeed;
        StringArgument ldifFile;
        StringArgument templatePath;
        StringArgument resourcePath;
        StringArgument configClass;
        StringArgument configFile;
        String toolDescription = MessageHandler.getMessage(10486457);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", null, null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            resourcePath = new StringArgument("resourcepath", Character.valueOf('r'), "resourcePath", true, false, true, "{path}", null, null, 10486351, new Object[0]);
            resourcePath.setHidden(true);
            argParser.addArgument(resourcePath);
            templatePath = new StringArgument("templatefile", Character.valueOf('t'), "templateFile", true, false, true, "{file}", null, null, 10486336, new Object[0]);
            argParser.addArgument(templatePath);
            ldifFile = new StringArgument("ldiffile", Character.valueOf('o'), "ldifFile", true, false, true, "{file}", null, null, 10486337, new Object[0]);
            argParser.addArgument(ldifFile);
            randomSeed = new IntegerArgument("randomseed", Character.valueOf('s'), "randomSeed", false, false, true, "{seed}", 0, null, 10486338, new Object[0]);
            argParser.addArgument(randomSeed);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 10486339, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception e) {
            int msgID = 10748486;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
        }
        catch (Exception e) {
            int msgID = 10748487;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception e) {
            int msgID = 10748488;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (randomSeed.isPresent()) {
            try {
                random = new Random(randomSeed.getIntValue());
            }
            catch (Exception e) {
                random = new Random();
            }
        } else {
            random = new Random();
        }
        if (!(resourceDir = new File(resourcePath.getValue())).exists()) {
            int msgID = 10682961;
            String message = MessageHandler.getMessage(msgID, resourcePath.getValue());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        LinkedList<String> warnings = new LinkedList<String>();
        TemplateFile templateFile = new TemplateFile(resourcePath.getValue(), random);
        try {
            templateFile.parse(templatePath.getValue(), warnings);
        }
        catch (IOException ioe) {
            int msgID = 10748489;
            String message = MessageHandler.getMessage(msgID, ioe.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            int msgID = 10748490;
            String message = MessageHandler.getMessage(msgID, e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (!warnings.isEmpty()) {
            for (String s : warnings) {
                System.err.println(StaticUtils.wrapText(s, ServerConstants.MAX_LINE_WIDTH));
            }
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFile.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            this.ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (IOException ioe) {
            int msgID = 10682966;
            String message = MessageHandler.getMessage(msgID, ldifFile.getValue(), String.valueOf(ioe));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            templateFile.generateLDIF(this);
        }
        catch (Exception e) {
            int msgID = 10682967;
            String message = MessageHandler.getMessage(msgID, ldifFile.getValue(), StaticUtils.stackTraceToSingleLineString(e));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            int n = 1;
            return n;
        }
        finally {
            try {
                this.ldifWriter.close();
            }
            catch (Exception e) {}
        }
        return 0;
    }

    public boolean writeEntry(Entry entry) throws IOException, MakeLDIFException {
        try {
            this.ldifWriter.writeEntry(entry);
            if (++this.entriesWritten % 1000L == 0L) {
                int msgID = 10486360;
                String message = MessageHandler.getMessage(msgID, this.entriesWritten);
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return true;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            int msgID = 10682969;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
            throw new MakeLDIFException(msgID, message, e);
        }
    }

    public void closeEntryWriter() {
        int msgID = 10486362;
        String message = MessageHandler.getMessage(msgID, this.entriesWritten);
        System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
    }
}

