/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTag
extends Tag {
    private boolean sequential = false;
    private File dataFile = null;
    private int nextIndex = 0;
    private Random random = null;
    private String[] fileLines = null;

    @Override
    public String getName() {
        return "File";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber, warnings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.random = templateFile.getRandom();
        if (arguments.length < 1 || arguments.length > 2) {
            int msgID = 10682904;
            String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 1, 2, arguments.length);
            throw new InitializationException(msgID, message);
        }
        this.dataFile = templateFile.getFile(arguments[0]);
        if (this.dataFile == null || !this.dataFile.exists()) {
            int msgID = 10682963;
            String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber);
            throw new InitializationException(msgID, message);
        }
        if (arguments.length == 2) {
            if (arguments[1].equalsIgnoreCase("sequential")) {
                this.sequential = true;
                this.nextIndex = 0;
            } else {
                if (!arguments[1].equalsIgnoreCase("random")) {
                    int msgID = 10682964;
                    String message = MessageHandler.getMessage(msgID, arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
                this.sequential = false;
            }
        } else {
            this.sequential = false;
        }
        try {
            this.fileLines = templateFile.getFileLines(this.dataFile);
            return;
        }
        catch (IOException ioe) {
            int msgID = 10682965;
            String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber, String.valueOf(ioe));
            throw new InitializationException(msgID, message, ioe);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        if (this.sequential) {
            templateValue.append(this.fileLines[this.nextIndex++]);
            if (this.nextIndex >= this.fileLines.length) {
                this.nextIndex = 0;
            }
        } else {
            templateValue.append(this.fileLines[this.random.nextInt(this.fileLines.length)]);
        }
        return TagResult.SUCCESS_RESULT;
    }
}

