/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueTag
extends Tag {
    private AttributeType attributeType = null;
    private int numCharacters = 0;

    @Override
    public String getName() {
        return "AttributeValue";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        block6: {
            if (arguments.length < 1 || arguments.length > 2) {
                int msgID = 10682904;
                String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 1, 2, arguments.length);
                throw new InitializationException(msgID, message);
            }
            String lowerName = StaticUtils.toLowerCase(arguments[0]);
            this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
            if (!branch.hasAttribute(this.attributeType)) {
                int msgID = 10682905;
                String message = MessageHandler.getMessage(msgID, arguments[0], lineNumber);
                throw new InitializationException(msgID, message);
            }
            if (arguments.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(arguments[1]);
                    if (this.numCharacters < 0) {
                        int msgID = 10682906;
                        String message = MessageHandler.getMessage(msgID, this.numCharacters, 0, this.getName(), lineNumber);
                        throw new InitializationException(msgID, message);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    int msgID = 10682907;
                    String message = MessageHandler.getMessage(msgID, arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        block6: {
            if (arguments.length < 1 || arguments.length > 2) {
                int msgID = 10682904;
                String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 1, 2, arguments.length);
                throw new InitializationException(msgID, message);
            }
            String lowerName = StaticUtils.toLowerCase(arguments[0]);
            this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
            if (!template.hasAttribute(this.attributeType)) {
                int msgID = 10682905;
                String message = MessageHandler.getMessage(msgID, arguments[0], lineNumber);
                throw new InitializationException(msgID, message);
            }
            if (arguments.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(arguments[1]);
                    if (this.numCharacters < 0) {
                        int msgID = 10682906;
                        String message = MessageHandler.getMessage(msgID, this.numCharacters, 0, this.getName(), lineNumber);
                        throw new InitializationException(msgID, message);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    int msgID = 10682907;
                    String message = MessageHandler.getMessage(msgID, arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        TemplateValue v = templateEntry.getValue(this.attributeType);
        if (v == null) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.numCharacters > 0) {
            String valueString = v.getValue().toString();
            if (valueString.length() > this.numCharacters) {
                templateValue.append(valueString.substring(0, this.numCharacters));
            } else {
                templateValue.append(valueString);
            }
        } else {
            templateValue.getValue().append((CharSequence)v.getValue());
        }
        return TagResult.SUCCESS_RESULT;
    }
}

