/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static ListSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(app, parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(app, parser, p, r, r.getName(), r.getUserFriendlyName());
    }

    private ListSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, String rname, String rufn) throws ArgumentException {
        super(app);
        this.path = p;
        this.relation = r;
        String name = "list-" + rname;
        int descriptionID = 10486766;
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, descriptionID, rufn);
        this.namingArgs = this.createNamingArgs(this.subCommand, this.path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        ManagedObject<?> parent;
        String ufn;
        Set<String> propertyNames = this.getPropertyNames();
        if (propertyNames.isEmpty()) {
            propertyNames = CLIProfile.getInstance().getDefaultListPropertyNames(this.relation);
        }
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), this.getConsoleApplication().isScriptFriendly());
        List<String> names = this.getNamingArgValues(this.namingArgs);
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            ufn = irelation.getUserFriendlyPluralName();
        } else {
            ufn = this.relation.getUserFriendlyName();
        }
        try {
            parent = this.getManagedObject(this.path, names);
        }
        catch (AuthorizationException e) {
            int msgID = 10748961;
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(50, msgID, msg);
        }
        catch (DefinitionDecodingException e) {
            int msgID = 10748930;
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn, ufn, ufn);
            throw new ClientException(1, msgID, msg);
        }
        catch (ManagedObjectDecodingException e) {
            int msgID = 10748931;
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(1, msgID, msg);
        }
        catch (CommunicationException e) {
            int msgID = 10748962;
            String msg = MessageHandler.getMessage(msgID, ufn, e.getMessage());
            throw new ClientException(81, msgID, msg);
        }
        catch (ConcurrentModificationException e) {
            int msgID = 10748963;
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(19, msgID, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            int msgID = 0xA40404;
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(32, msgID, msg);
        }
        TreeMap children = new TreeMap();
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(irelation)) {
                    try {
                        children.put(s, parent.getChild(irelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                int msgID = 10748958;
                String msg = MessageHandler.getMessage(msgID, ufn, ufn, ufn);
                throw new ClientException(1, msgID, msg);
            }
            catch (ManagedObjectDecodingException e) {
                int msgID = 10748959;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(1, msgID, msg);
            }
            catch (AuthorizationException e) {
                int msgID = 10748961;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(50, msgID, msg);
            }
            catch (ConcurrentModificationException e) {
                int msgID = 10748963;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(19, msgID, msg);
            }
            catch (CommunicationException e) {
                int msgID = 10748962;
                String msg = MessageHandler.getMessage(msgID, ufn, e.getMessage());
                throw new ClientException(81, msgID, msg);
            }
        }
        if (this.relation instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
            try {
                if (!parent.hasChild(orelation)) {
                    throw new ManagedObjectNotFoundException();
                }
                ManagedObject child = parent.getChild(orelation);
                children.put(child.getManagedObjectDefinition().getName(), child);
            }
            catch (AuthorizationException e) {
                int msgID = 10748961;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(50, msgID, msg);
            }
            catch (DefinitionDecodingException e) {
                int msgID = 10748958;
                String msg = MessageHandler.getMessage(msgID, ufn, ufn, ufn);
                throw new ClientException(1, msgID, msg);
            }
            catch (ManagedObjectDecodingException e) {
                int msgID = 10748959;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(1, msgID, msg);
            }
            catch (ConcurrentModificationException e) {
                int msgID = 10748963;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(19, msgID, msg);
            }
            catch (CommunicationException e) {
                int msgID = 10748962;
                String msg = MessageHandler.getMessage(msgID, ufn, e.getMessage());
                throw new ClientException(81, msgID, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                int msgID = 10748960;
                String msg = MessageHandler.getMessage(msgID, ufn);
                throw new ClientException(32, msgID, msg);
            }
        }
        if (this.getConsoleApplication().isScriptFriendly()) {
            PrintStream out = this.getConsoleApplication().getOutputStream();
            for (String name : children.keySet()) {
                out.println(name);
            }
        } else {
            TablePrinter printer;
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(this.relation.getUserFriendlyName());
            builder.appendHeading(MessageHandler.getMessage(10486842));
            if (!propertyNames.isEmpty()) {
                // empty if block
            }
            for (String propertyName : propertyNames) {
                builder.appendHeading(propertyName);
            }
            builder.addSortKey(0);
            String baseType = this.relation.getName();
            String typeSuffix = "-" + baseType;
            for (String name : children.keySet()) {
                ManagedObject child = (ManagedObject)children.get(name);
                ManagedObjectDefinition d = child.getManagedObjectDefinition();
                builder.startRow();
                builder.appendCell(name);
                String childType = d.getName();
                if (baseType.equals(childType)) {
                    builder.appendCell("generic");
                } else if (childType.endsWith(typeSuffix)) {
                    builder.appendCell(childType.substring(0, childType.length() - typeSuffix.length()));
                } else {
                    builder.appendCell(childType);
                }
                for (String propertyName : propertyNames) {
                    try {
                        PropertyDefinition<?> pd = d.getPropertyDefinition(propertyName);
                        this.displayProperty(builder, child, pd, valuePrinter);
                    }
                    catch (IllegalArgumentException e) {
                        if (this.getConsoleApplication().isScriptFriendly()) {
                            builder.appendCell();
                            continue;
                        }
                        builder.appendCell("-");
                    }
                }
            }
            PrintStream out = this.getConsoleApplication().getOutputStream();
            if (this.getConsoleApplication().isScriptFriendly()) {
                printer = this.createScriptFriendlyTablePrinter(out);
                builder.print(printer);
            } else {
                printer = new TextTablePrinter(out);
                ((TextTablePrinter)printer).setColumnSeparator(":");
                builder.print(printer);
            }
        }
        return 0;
    }

    private <T> void displayProperty(TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            if (this.getConsoleApplication().isScriptFriendly()) {
                builder.appendCell();
            } else {
                builder.appendCell("-");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object value : values) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(valuePrinter.print(pd, value));
                isFirst = false;
            }
            builder.appendCell(sb.toString());
        }
    }
}

