/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.LDAPManagementContextFactory;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.SubCommandBuilder;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

public final class DSConfig
extends ConsoleApplication {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean environmentInitialized = false;
    private final ManagementContextFactory factory;
    private boolean globalArgumentsInitialized = false;
    private final Map<SubCommand, SubCommandHandler> handlers = new HashMap<SubCommand, SubCommandHandler>();
    private BooleanArgument interactiveArgument;
    private final SubCommandArgumentParser parser = new SubCommandArgumentParser(this.getClass().getName(), MessageHandler.getMessage(10486444), false);
    private BooleanArgument quietArgument;
    private BooleanArgument scriptFriendlyArgument;
    private BooleanArgument showUsageArgument;
    private boolean subCommandsInitialized = false;
    private BooleanArgument verboseArgument;

    public static void main(String[] args) {
        int exitCode = DSConfig.main(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int main(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        DSConfig app = new DSConfig(System.in, outStream, errStream, new LDAPManagementContextFactory());
        if (initializeServer) {
            try {
                app.initializeClientEnvironment();
            }
            catch (InitializationException e) {
                app.printMessage(e.getMessage());
                return 1;
            }
        }
        return app.run(args);
    }

    public DSConfig(InputStream in, OutputStream out, OutputStream err, ManagementContextFactory factory) {
        super(in, out, err);
        this.factory = factory;
    }

    public void initializeClientEnvironment() throws InitializationException {
        if (!this.environmentInitialized) {
            DirectoryServer.bootstrapClient();
            ClassLoaderProvider.getInstance().enable();
            ClassPropertyDefinition.setAllowClassValidation(false);
            AttributeTypePropertyDefinition.setCheckSchema(false);
            this.environmentInitialized = true;
        }
    }

    public boolean isInteractive() {
        return this.interactiveArgument.isPresent();
    }

    public boolean isQuiet() {
        return this.quietArgument.isPresent();
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendlyArgument.isPresent();
    }

    public boolean isVerbose() {
        return this.verboseArgument.isPresent();
    }

    public ManagementContext getManagementContext() throws ArgumentException, ClientException {
        return this.factory.getManagementContext(this);
    }

    private void displayMessageAndUsageReference(String message) {
        this.printMessage(message);
        this.printMessage("");
        this.printMessage(this.parser.getHelpUsageReference());
    }

    private void initializeGlobalArguments() throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.verboseArgument = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            this.quietArgument = new BooleanArgument("quiet", Character.valueOf('q'), "quiet", 10486835, new Object[0]);
            this.scriptFriendlyArgument = new BooleanArgument("script-friendly", Character.valueOf('s'), "script-friendly", 10486836, new Object[0]);
            this.interactiveArgument = new BooleanArgument("interactive", Character.valueOf('i'), "interactive", 10486837, new Object[0]);
            this.showUsageArgument = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 10486845, new Object[0]);
            this.parser.addGlobalArgument(this.showUsageArgument);
            this.parser.setUsageArgument(this.showUsageArgument, this.getOutputStream());
            this.parser.addGlobalArgument(this.verboseArgument);
            this.parser.addGlobalArgument(this.quietArgument);
            this.parser.addGlobalArgument(this.scriptFriendlyArgument);
            this.parser.addGlobalArgument(this.interactiveArgument);
            this.factory.registerGlobalArguments(this.parser);
            this.globalArgumentsInitialized = true;
        }
    }

    private void initializeSubCommands() throws ArgumentException {
        if (!this.subCommandsInitialized) {
            Comparator<SubCommand> c = new Comparator<SubCommand>(){

                @Override
                public int compare(SubCommand o1, SubCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            SubCommandBuilder builder = new SubCommandBuilder();
            TreeMap<Tag, TreeSet<SubCommand>> groups = new TreeMap<Tag, TreeSet<SubCommand>>();
            TreeSet<SubCommand> allSubCommands = new TreeSet<SubCommand>(c);
            for (SubCommandHandler subCommandHandler : builder.getSubCommandHandlers(this, this.parser)) {
                SubCommand sc = subCommandHandler.getSubCommand();
                this.handlers.put(sc, subCommandHandler);
                allSubCommands.add(sc);
                for (Tag tag : subCommandHandler.getTags()) {
                    TreeSet<SubCommand> group = (TreeSet<SubCommand>)groups.get(tag);
                    if (group == null) {
                        group = new TreeSet<SubCommand>(c);
                        groups.put(tag, group);
                    }
                    group.add(sc);
                }
            }
            for (Map.Entry entry : groups.entrySet()) {
                Tag tag = (Tag)entry.getKey();
                SortedSet subCommands = (SortedSet)entry.getValue();
                String option = "help-" + tag.getName();
                String synopsis = tag.getSynopsis().toLowerCase();
                BooleanArgument arg = new BooleanArgument(option, null, option, 10486843, synopsis);
                this.parser.addGlobalArgument(arg);
                this.parser.setUsageGroupArgument(arg, subCommands);
            }
            String option = "help-all";
            BooleanArgument booleanArgument = new BooleanArgument(option, null, option, 10486844, new Object[0]);
            this.parser.addGlobalArgument(booleanArgument);
            this.parser.setUsageGroupArgument(booleanArgument, allSubCommands);
            this.subCommandsInitialized = true;
        }
    }

    private int run(String[] args) {
        try {
            this.initializeGlobalArguments();
            this.initializeSubCommands();
        }
        catch (ArgumentException e) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, e.getMessage());
            this.printMessage(message);
            return 1;
        }
        try {
            this.parser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (this.parser.getSubCommand() == null) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, MessageHandler.getMessage(10748913));
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.quietArgument.isPresent() && this.verboseArgument.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.quietArgument.getLongIdentifier(), this.verboseArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.quietArgument.isPresent() && this.interactiveArgument.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.quietArgument.getLongIdentifier(), this.interactiveArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.scriptFriendlyArgument.isPresent() && this.verboseArgument.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.scriptFriendlyArgument.getLongIdentifier(), this.verboseArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        try {
            this.factory.validateGlobalArguments();
        }
        catch (ArgumentException e) {
            this.printMessage(e.getMessage());
            return 1;
        }
        SubCommandHandler handler = this.handlers.get(this.parser.getSubCommand());
        try {
            return handler.run();
        }
        catch (ArgumentException e) {
            this.printMessage(e.getMessage());
            return 1;
        }
        catch (ClientException e) {
            this.printMessage(e.getMessage());
            Throwable cause = e.getCause();
            if (cause instanceof ManagedObjectDecodingException) {
                ManagedObjectDecodingException de = (ManagedObjectDecodingException)cause;
                this.printMessage("");
                TableBuilder builder = new TableBuilder();
                for (PropertyException pe : de.getCauses()) {
                    ManagedObjectDefinition<?, Configuration> d = de.getPartialManagedObject().getManagedObjectDefinition();
                    ArgumentException ae = ArgumentExceptionFactory.adaptPropertyException(pe, d);
                    builder.startRow();
                    builder.appendCell("*");
                    builder.appendCell(ae.getMessage());
                }
                TextTablePrinter printer = new TextTablePrinter(this.getErrorStream());
                printer.setDisplayHeadings(false);
                printer.setColumnWidth(1, 0);
                builder.print(printer);
                this.printMessage("");
            }
            return 1;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.printMessage(StaticUtils.stackTraceToString(e));
            return 1;
        }
    }
}

