/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.RandomAccessFile;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class WaitForFileDelete {
    private static final String CLASS_NAME = "org.opends.server.tools.WaitForFileDelete";
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INTERNAL_ERROR = 1;
    public static final int EXIT_CODE_TIMEOUT = 2;

    public static void main(String[] args) {
        try {
            int exitCode = WaitForFileDelete.mainWait(args);
            if (exitCode != 0) {
                System.exit(StaticUtils.filterExitCode(exitCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static int mainWait(String[] args) {
        long stopWaitingTime;
        BooleanArgument showUsage = null;
        IntegerArgument timeout = null;
        StringArgument logFilePath = null;
        StringArgument targetFilePath = null;
        StringArgument outputFilePath = null;
        String toolDescription = MessageHandler.getMessage(10486461);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            targetFilePath = new StringArgument("targetfile", Character.valueOf('f'), "targetFile", true, false, true, "{path}", null, null, 10486435, new Object[0]);
            argParser.addArgument(targetFilePath);
            logFilePath = new StringArgument("logfile", Character.valueOf('l'), "logFile", false, false, true, "{path}", null, null, 10486436, new Object[0]);
            argParser.addArgument(logFilePath);
            outputFilePath = new StringArgument("outputfile", Character.valueOf('o'), "outputFile", false, false, true, "{path}", null, null, 10486599, new Object[0]);
            argParser.addArgument(outputFilePath);
            timeout = new IntegerArgument("timeout", Character.valueOf('t'), "timeout", true, false, true, "{seconds}", 60, null, true, 0, false, 0, 10486437, new Object[0]);
            argParser.addArgument(timeout);
            showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 10486438, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        File targetFile = new File(targetFilePath.getValue());
        if (!targetFile.exists()) {
            return 0;
        }
        long logFileOffset = 0L;
        RandomAccessFile logFile = null;
        if (logFilePath.isPresent()) {
            try {
                File f = new File(logFilePath.getValue());
                if (f.exists()) {
                    logFile = new RandomAccessFile(f, "r");
                    logFileOffset = logFile.length();
                    logFile.seek(logFileOffset);
                }
            }
            catch (Exception e) {
                int msgID = 10617513;
                String message = MessageHandler.getMessage(msgID, logFilePath.getValue(), String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                logFile = null;
            }
        }
        RandomAccessFile outputFile = null;
        long outputFileOffset = 0L;
        if (logFile != null && outputFilePath.isPresent()) {
            try {
                File f = new File(outputFilePath.getValue());
                if (f.exists()) {
                    outputFile = new RandomAccessFile(f, "rw");
                    outputFileOffset = outputFile.length();
                    outputFile.seek(outputFileOffset);
                }
            }
            catch (Exception e) {
                int msgID = 10617672;
                String message = MessageHandler.getMessage(msgID, outputFilePath.getValue(), String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                outputFile = null;
            }
        }
        try {
            long timeoutMillis = 1000L * (long)Integer.parseInt(timeout.getValue());
            stopWaitingTime = timeoutMillis > 0L ? System.currentTimeMillis() + timeoutMillis : Long.MAX_VALUE;
        }
        catch (Exception e) {
            stopWaitingTime = System.currentTimeMillis() + 60000L;
        }
        byte[] logBuffer = new byte[8192];
        while (System.currentTimeMillis() < stopWaitingTime) {
            if (logFile != null) {
                try {
                    while (logFile.length() > logFileOffset) {
                        int bytesRead = logFile.read(logBuffer);
                        if (bytesRead <= 0) continue;
                        if (outputFile == null) {
                            System.out.write(logBuffer, 0, bytesRead);
                            System.out.flush();
                        } else {
                            outputFile.write(logBuffer, 0, bytesRead);
                        }
                        logFileOffset += (long)bytesRead;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!targetFile.exists()) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {}
        }
        if (outputFile != null) {
            try {
                outputFile.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (targetFile.exists()) {
            return 2;
        }
        return 0;
    }
}

