/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tasks.ShutdownTask;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class StopDS {
    private static final String CLASS_NAME = "org.opends.server.tools.StopDS";
    private static int SERVER_ALREADY_STOPPED = 98;
    private static int START_SERVER = 99;
    private static int STOP_USING_SYSTEM_CALL = 100;
    private static int RESTART_USING_SYSTEM_CALL = 101;
    private static int STOP_USING_PROTOCOL = 102;
    private static int STOP_AS_WINDOW_SERVICE = 103;
    private static int RESTART_AS_WINDOW_SERVICE = 104;

    public static void main(String[] args) {
        int result = StopDS.stopDS(args, System.out, System.err);
        if (result != 0) {
            System.exit(StaticUtils.filterExitCode(result));
        }
    }

    public static int stopDS(String[] args) {
        return StopDS.stopDS(args, System.out, System.err);
    }

    public static int stopDS(String[] args, OutputStream outStream, OutputStream errStream) {
        LDAPMessage responseMessage;
        LDAPConnection connection;
        FileBasedArgument trustStorePWFile;
        StringArgument trustStorePW;
        StringArgument trustStoreFile;
        StringArgument certNickname;
        FileBasedArgument keyStorePWFile;
        StringArgument keyStorePW;
        StringArgument keyStoreFile;
        BooleanArgument trustAll;
        StringArgument stopTimeStr;
        BooleanArgument restart;
        BooleanArgument checkStoppability;
        StringArgument stopReason;
        StringArgument proxyAuthzID;
        StringArgument saslOption;
        FileBasedArgument bindPWFile;
        StringArgument bindPW;
        StringArgument bindDN;
        BooleanArgument useStartTLS;
        BooleanArgument useSSL;
        IntegerArgument port;
        StringArgument host;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String toolDescription = MessageHandler.getMessage(10486459);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            host = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "127.0.0.1", null, 10486134, new Object[0]);
            argParser.addArgument(host);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, true, 1, true, 65535, 10486135, new Object[0]);
            argParser.addArgument(port);
            useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", 10486136, new Object[0]);
            argParser.addArgument(useSSL);
            useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", 10486137, new Object[0]);
            argParser.addArgument(useStartTLS);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 10486138, new Object[0]);
            argParser.addArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10486139, new Object[0]);
            argParser.addArgument(bindPW);
            bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10486140, new Object[0]);
            argParser.addArgument(bindPWFile);
            saslOption = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, 10486141, new Object[0]);
            argParser.addArgument(saslOption);
            proxyAuthzID = new StringArgument("proxyauthzid", Character.valueOf('Y'), "proxyAs", false, false, true, "{authzID}", null, null, 10486142, new Object[0]);
            argParser.addArgument(proxyAuthzID);
            stopReason = new StringArgument("stopreason", Character.valueOf('r'), "stopReason", false, false, true, "{stopReason}", null, null, 10486143, new Object[0]);
            argParser.addArgument(stopReason);
            checkStoppability = new BooleanArgument("checkstoppability", null, "checkStoppability", 10486564, new Object[0]);
            checkStoppability.setHidden(true);
            argParser.addArgument(checkStoppability);
            BooleanArgument windowsNetStop = new BooleanArgument("windowsnetstop", null, "windowsNetStop", 10486598, new Object[0]);
            windowsNetStop.setHidden(true);
            argParser.addArgument(windowsNetStop);
            restart = new BooleanArgument("restart", Character.valueOf('R'), "restart", 10486172, new Object[0]);
            argParser.addArgument(restart);
            stopTimeStr = new StringArgument("stoptime", Character.valueOf('t'), "stopTime", false, false, true, "{stopTime}", null, null, 10486144, new Object[0]);
            argParser.addArgument(stopTimeStr);
            trustAll = new BooleanArgument("trustall", Character.valueOf('X'), "trustAll", 10486145, new Object[0]);
            argParser.addArgument(trustAll);
            keyStoreFile = new StringArgument("keystorefile", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10486146, new Object[0]);
            argParser.addArgument(keyStoreFile);
            keyStorePW = new StringArgument("keystorepw", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 10486147, new Object[0]);
            argParser.addArgument(keyStorePW);
            keyStorePWFile = new FileBasedArgument("keystorepwfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486148, new Object[0]);
            argParser.addArgument(keyStorePWFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
            argParser.addArgument(certNickname);
            trustStoreFile = new StringArgument("truststorefile", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10486149, new Object[0]);
            argParser.addArgument(trustStoreFile);
            trustStorePW = new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486150, new Object[0]);
            argParser.addArgument(trustStorePW);
            trustStorePWFile = new FileBasedArgument("truststorepwfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486151, new Object[0]);
            argParser.addArgument(trustStorePWFile);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", 10486152, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (checkStoppability.isPresent()) {
            System.exit(StopDS.checkStoppability(argParser));
        }
        if (bindPW.isPresent() && bindPWFile.isPresent()) {
            int msgID = 10748299;
            String message = MessageHandler.getMessage(msgID, bindPW.getLongIdentifier(), bindPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (keyStorePW.isPresent() && keyStorePWFile.isPresent()) {
            int msgID = 10748299;
            String message = MessageHandler.getMessage(msgID, keyStorePW.getLongIdentifier(), keyStorePWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (trustStorePW.isPresent() && trustStorePWFile.isPresent()) {
            int msgID = 10748299;
            String message = MessageHandler.getMessage(msgID, trustStorePW.getLongIdentifier(), trustStorePWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        Date stopTime = new Date();
        if (stopTimeStr.isPresent()) {
            SimpleDateFormat dateFormat;
            String timeStr = stopTimeStr.getValue();
            if (timeStr.endsWith("Z")) {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                dateFormat.setLenient(true);
                try {
                    stopTime = dateFormat.parse(timeStr);
                }
                catch (Exception e) {
                    int msgID = 10748300;
                    String message = MessageHandler.getMessage(msgID);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
            }
            dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.setLenient(true);
            try {
                stopTime = dateFormat.parse(timeStr);
            }
            catch (Exception e) {
                int msgID = 10748300;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        if (useSSL.isPresent()) {
            if (useStartTLS.isPresent()) {
                int msgID = 10748299;
                String message = MessageHandler.getMessage(msgID, useSSL.getLongIdentifier(), useStartTLS.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setUseSSL(true);
        } else if (useStartTLS.isPresent()) {
            connectionOptions.setStartTLS(true);
        }
        if (useSSL.isPresent() || useStartTLS.isPresent()) {
            try {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStoreFile.getValue(), keyStorePW.getValue(), clientAlias, trustStoreFile.getValue(), trustStorePW.getValue());
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (SSLConnectionException sce) {
                int msgID = 10748301;
                String message = MessageHandler.getMessage(msgID, sce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 82;
            }
        }
        if (saslOption.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    int msgID = 10748302;
                    String message = MessageHandler.getMessage(msgID, s);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                int msgID = 10748303;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        AtomicInteger nextMessageID = new AtomicInteger(1);
        try {
            connection = new LDAPConnection(host.getValue(), port.getIntValue(), connectionOptions, out, err);
            connection.connectToHost(bindDN.getValue(), bindPW.getValue(), nextMessageID);
        }
        catch (ArgumentException ae) {
            int msgID = 10748304;
            String message = MessageHandler.getMessage(msgID, port.getLongIdentifier(), ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        catch (LDAPConnectionException lce) {
            int msgID = 10748305;
            String message = MessageHandler.getMessage(msgID, lce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 91;
        }
        LDAPReader reader = connection.getLDAPReader();
        LDAPWriter writer = connection.getLDAPWriter();
        String taskID = UUID.randomUUID().toString();
        ASN1OctetString entryDN = new ASN1OctetString("ds-task-id=" + taskID + "," + "cn=Scheduled Tasks" + "," + "cn=Tasks");
        ArrayList<RawAttribute> attributes = new ArrayList<RawAttribute>();
        ArrayList<ASN1OctetString> ocValues = new ArrayList<ASN1OctetString>(3);
        ocValues.add(new ASN1OctetString("top"));
        ocValues.add(new ASN1OctetString("ds-task"));
        ocValues.add(new ASN1OctetString("ds-task-shutdown"));
        attributes.add(new LDAPAttribute("objectClass", ocValues));
        ArrayList<ASN1OctetString> taskIDValues = new ArrayList<ASN1OctetString>(1);
        taskIDValues.add(new ASN1OctetString(taskID));
        attributes.add(new LDAPAttribute("ds-task-id", taskIDValues));
        ArrayList<ASN1OctetString> classValues = new ArrayList<ASN1OctetString>(1);
        classValues.add(new ASN1OctetString(ShutdownTask.class.getName()));
        attributes.add(new LDAPAttribute("ds-task-class-name", classValues));
        if (restart.isPresent()) {
            ArrayList<ASN1OctetString> restartValues = new ArrayList<ASN1OctetString>(1);
            restartValues.add(new ASN1OctetString("true"));
            attributes.add(new LDAPAttribute("ds-task-restart-server", restartValues));
        }
        if (stopReason.isPresent()) {
            ArrayList<ASN1OctetString> stopReasonValues = new ArrayList<ASN1OctetString>(1);
            stopReasonValues.add(new ASN1OctetString(stopReason.getValue()));
            attributes.add(new LDAPAttribute("ds-task-shutdown-message", stopReasonValues));
        }
        if (stopTime != null) {
            ArrayList<ASN1OctetString> stopTimeValues = new ArrayList<ASN1OctetString>(1);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            stopTimeValues.add(new ASN1OctetString(dateFormat.format(stopTime)));
            attributes.add(new LDAPAttribute("ds-task-scheduled-start-time", stopTimeValues));
        }
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>();
        if (proxyAuthzID.isPresent()) {
            ProxiedAuthV2Control c = new ProxiedAuthV2Control(new ASN1OctetString(proxyAuthzID.getValue()));
            controls.add(new LDAPControl(c));
        }
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entryDN, attributes);
        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), addRequest, controls);
        try {
            writer.writeMessage(requestMessage);
            responseMessage = reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748306;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 81;
            }
        }
        catch (IOException ioe) {
            int msgID = 10748307;
            String message = MessageHandler.getMessage(msgID, String.valueOf(ioe));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 81;
        }
        catch (ASN1Exception ae) {
            int msgID = 10748308;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 84;
        }
        catch (LDAPException le) {
            int msgID = 10748308;
            String message = MessageHandler.getMessage(msgID, le.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 84;
        }
        if (responseMessage.getProtocolOpType() != 105) {
            ExtendedResponseProtocolOp extendedResponse;
            String responseOID;
            if (responseMessage.getProtocolOpType() == 120 && (responseOID = (extendedResponse = responseMessage.getExtendedResponseProtocolOp()).getOID()) != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                String message = extendedResponse.getErrorMessage();
                if (message != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                return extendedResponse.getResultCode();
            }
            int msgID = 10748309;
            String message = MessageHandler.getMessage(msgID, responseMessage.getProtocolOpName());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 82;
        }
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        String errorMessage = addResponse.getErrorMessage();
        if (errorMessage != null) {
            err.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
        }
        return addResponse.getResultCode();
    }

    private static int checkStoppability(ArgumentParser argParser) {
        int returnValue;
        BooleanArgument restart = (BooleanArgument)argParser.getArgumentForLongID("restart");
        boolean restartPresent = restart.isPresent();
        BooleanArgument windowsNetStop = (BooleanArgument)argParser.getArgumentForLongID("windowsnetstop");
        boolean windowsNetStopPresent = windowsNetStop.isPresent();
        LinkedList<Argument> list = argParser.getArgumentList();
        boolean stopThroughProtocol = false;
        for (Argument arg : list) {
            if ("restart".equals(arg.getName()) || "showusage".equals(arg.getName()) || "checkstoppability".equals(arg.getName()) || "windowsnetstop".equals(arg.getName())) continue;
            stopThroughProtocol |= arg.isPresent();
        }
        if (stopThroughProtocol) {
            returnValue = STOP_USING_PROTOCOL;
        } else {
            boolean isServerRunning;
            String message;
            int msgID;
            String lockFile = LockFileManager.getServerLockFileName();
            try {
                StringBuilder failureReason = new StringBuilder();
                if (LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                    msgID = 10486562;
                    message = MessageHandler.getMessage(msgID, null, null);
                    System.out.println(message);
                    LockFileManager.releaseLock(lockFile, failureReason);
                    isServerRunning = false;
                } else {
                    isServerRunning = true;
                }
            }
            catch (Exception e) {
                isServerRunning = true;
            }
            boolean configuredAsService = DirectoryServer.isRunningAsWindowsService();
            if (!isServerRunning) {
                returnValue = configuredAsService && !windowsNetStopPresent ? (restartPresent ? RESTART_AS_WINDOW_SERVICE : STOP_AS_WINDOW_SERVICE) : (restartPresent ? START_SERVER : SERVER_ALREADY_STOPPED);
            } else if (configuredAsService) {
                if (windowsNetStopPresent) {
                    returnValue = restartPresent ? RESTART_USING_SYSTEM_CALL : STOP_USING_SYSTEM_CALL;
                } else {
                    returnValue = restartPresent ? RESTART_AS_WINDOW_SERVICE : STOP_AS_WINDOW_SERVICE;
                    msgID = 10486563;
                    message = MessageHandler.getMessage(msgID, null, null);
                    System.out.println(message);
                }
            } else {
                msgID = 10486563;
                message = MessageHandler.getMessage(msgID, null, null);
                System.out.println(message);
                returnValue = restartPresent ? RESTART_USING_SYSTEM_CALL : STOP_USING_SYSTEM_CALL;
            }
        }
        return returnValue;
    }
}

