/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;

public class StartWindowsService {
    private static int SERVICE_START_SUCCESSFUL = 0;
    private static int SERVICE_NOT_FOUND = 1;
    private static int SERVICE_START_ERROR = 2;

    public static void main(String[] args) {
        int result = StartWindowsService.startWindowsService(System.out, System.err);
        System.exit(StaticUtils.filterExitCode(result));
    }

    public static int startWindowsService(OutputStream outStream, OutputStream errStream) {
        int returnValue;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String serviceName = ConfigureWindowsService.getServiceName();
        if (serviceName == null) {
            int msgID = 10748717;
            String message = MessageHandler.getMessage(msgID, null);
            err.println(message);
            returnValue = SERVICE_NOT_FOUND;
        } else {
            String[] cmd = SetupUtils.isVista() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), "run", ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), "run", "net", "start", serviceName} : new String[]{"net", "start", serviceName};
            try {
                returnValue = Runtime.getRuntime().exec(cmd).waitFor() == 0 ? SERVICE_START_SUCCESSFUL : SERVICE_START_ERROR;
            }
            catch (Throwable t) {
                int msgID = 10748718;
                String message = MessageHandler.getMessage(msgID, null);
                out.println(message);
                returnValue = SERVICE_START_ERROR;
            }
        }
        return returnValue;
    }
}

