/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class RestoreDB {
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = RestoreDB.mainRestoreDB(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainRestoreDB(String[] args) {
        return RestoreDB.mainRestoreDB(args, true, System.out, System.err);
    }

    public static int mainRestoreDB(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        String message;
        String lockFile;
        String message2;
        int msgID;
        String backupID;
        BackupDirectory backupDir;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument displayUsage = null;
        BooleanArgument listBackups = null;
        BooleanArgument verifyOnly = null;
        StringArgument backupIDString = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument backupDirectory = null;
        String toolDescription = MessageHandler.getMessage(10486458);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.RestoreDB", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            backupIDString = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, "{backupID}", null, null, 10486052, new Object[0]);
            argParser.addArgument(backupIDString);
            backupDirectory = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, "{backupDir}", null, null, 10486053, new Object[0]);
            argParser.addArgument(backupDirectory);
            listBackups = new BooleanArgument("listbackups", Character.valueOf('l'), "listBackups", 10486054, new Object[0]);
            argParser.addArgument(listBackups);
            verifyOnly = new BooleanArgument("verifyonly", Character.valueOf('n'), "dry-run", 10486055, new Object[0]);
            argParser.addArgument(verifyOnly);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            int msgID2 = 10747920;
            String message3 = MessageHandler.getMessage(msgID2, ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID3 = 10747921;
            String message4 = MessageHandler.getMessage(msgID3, ae.getMessage());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID4 = 10747924;
                String message5 = MessageHandler.getMessage(msgID4, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID5 = 10747925;
                String message6 = MessageHandler.getMessage(msgID5, ie.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID6 = 10747925;
                String message7 = MessageHandler.getMessage(msgID6, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID7 = 10747926;
                String message8 = MessageHandler.getMessage(msgID7, ce.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID8 = 10747926;
                String message9 = MessageHandler.getMessage(msgID8, ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID9 = 10747926;
                String message10 = MessageHandler.getMessage(msgID9, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                int msgID10 = 10747927;
                String message11 = MessageHandler.getMessage(msgID10, ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID11 = 10747927;
                String message12 = MessageHandler.getMessage(msgID11, ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID12 = 10747927;
                String message13 = MessageHandler.getMessage(msgID12, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                int msgID13 = 10748188;
                String message14 = MessageHandler.getMessage(msgID13, ce.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID14 = 10748188;
                String message15 = MessageHandler.getMessage(msgID14, ie.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID15 = 10748188;
                String message16 = MessageHandler.getMessage(msgID15, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        try {
            backupDir = BackupDirectory.readBackupDirectoryDescriptor(backupDirectory.getValue());
        }
        catch (Exception e) {
            int msgID16 = 10748208;
            String message17 = MessageHandler.getMessage(msgID16, backupDirectory.getValue(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message17, msgID16);
            return 1;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        if (listBackups.isPresent()) {
            for (BackupInfo backupInfo : backupDir.getBackups().values()) {
                int msgID17 = 10486065;
                String message18 = MessageHandler.getMessage(msgID17, backupInfo.getBackupID());
                out.println(message18);
                msgID17 = 10486066;
                message18 = MessageHandler.getMessage(msgID17, dateFormat.format(backupInfo.getBackupDate()));
                out.println(message18);
                msgID17 = 10486067;
                message18 = MessageHandler.getMessage(msgID17, String.valueOf(backupInfo.isIncremental()));
                out.println(message18);
                msgID17 = 10486068;
                message18 = MessageHandler.getMessage(msgID17, String.valueOf(backupInfo.isCompressed()));
                out.println(message18);
                msgID17 = 10486069;
                message18 = MessageHandler.getMessage(msgID17, String.valueOf(backupInfo.isEncrypted()));
                out.println(message18);
                byte[] hash = backupInfo.getUnsignedHash();
                msgID17 = 10486070;
                message18 = MessageHandler.getMessage(msgID17, String.valueOf(hash != null));
                out.println(message18);
                byte[] signature = backupInfo.getSignedHash();
                msgID17 = 10486071;
                message18 = MessageHandler.getMessage(msgID17, String.valueOf(signature != null));
                out.println(message18);
                StringBuilder dependencyList = new StringBuilder();
                HashSet<String> dependencyIDs = backupInfo.getDependencies();
                if (!dependencyIDs.isEmpty()) {
                    Iterator<String> iterator = dependencyIDs.iterator();
                    dependencyList.append(iterator.next());
                    while (iterator.hasNext()) {
                        dependencyList.append(", ");
                        dependencyList.append(iterator.next());
                    }
                } else {
                    dependencyList.append("none");
                }
                msgID17 = 10486072;
                message18 = MessageHandler.getMessage(msgID17, dependencyList.toString());
                out.println(message18);
                out.println();
            }
            return 1;
        }
        if (backupIDString.isPresent()) {
            backupID = backupIDString.getValue();
            BackupInfo backupInfo = backupDir.getBackupInfo(backupID);
            if (backupInfo == null) {
                int msgID18 = 10748217;
                String message19 = MessageHandler.getMessage(msgID18, backupID, backupDirectory.getValue());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message19, msgID18);
                return 1;
            }
        } else {
            BackupInfo latestBackup = backupDir.getLatestBackup();
            if (latestBackup == null) {
                int msgID19 = 10748218;
                String message20 = MessageHandler.getMessage(msgID19, backupDirectory.getValue());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message20, msgID19);
                return 1;
            }
            backupID = latestBackup.getBackupID();
        }
        DN configEntryDN = backupDir.getConfigEntryDN();
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        Backend backend = null;
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            BackendCfg e = entryList.get(i);
            if (!e.dn().equals(configEntryDN)) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            msgID = 10748219;
            message2 = MessageHandler.getMessage(msgID, backupDirectory.getValue(), configEntryDN.toString());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        if (!backend.supportsRestore()) {
            msgID = 10748220;
            message2 = MessageHandler.getMessage(msgID, backend.getBackendID());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        RestoreConfig restoreConfig = new RestoreConfig(backupDir, backupID, verifyOnly.isPresent());
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                int msgID20 = 10748234;
                String message21 = MessageHandler.getMessage(msgID20, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message21, msgID20);
                return 0;
            }
        }
        catch (Exception e) {
            int msgID21 = 10748234;
            String message22 = MessageHandler.getMessage(msgID21, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message22, msgID21);
            return 0;
        }
        try {
            backend.restoreBackup(restoreConfig);
        }
        catch (DirectoryException de) {
            int msgID22 = 10748221;
            message = MessageHandler.getMessage(msgID22, backupID, backupDir.getPath(), de.getErrorMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID22);
        }
        catch (Exception e) {
            int msgID23 = 10748221;
            message = MessageHandler.getMessage(msgID23, backupID, backupDir.getPath(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID23);
        }
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                int msgID24 = 10617163;
                String message23 = MessageHandler.getMessage(msgID24, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID24);
            }
        }
        catch (Exception e) {
            int msgID25 = 10617163;
            message = MessageHandler.getMessage(msgID25, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID25);
        }
        return 0;
    }
}

