/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class RebuildIndex {
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = RebuildIndex.mainRebuildIndex(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int mainRebuildIndex(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        int returnCode;
        block50: {
            String message;
            String message2;
            int msgID;
            DN rebuildBaseDN;
            PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
            PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
            StringArgument configClass = null;
            StringArgument configFile = null;
            StringArgument baseDNString = null;
            StringArgument indexList = null;
            BooleanArgument displayUsage = null;
            String toolDescription = MessageHandler.getMessage(10486609);
            ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.RebuildIndex", toolDescription, false);
            try {
                configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
                configClass.setHidden(true);
                argParser.addArgument(configClass);
                configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
                configFile.setHidden(true);
                argParser.addArgument(configFile);
                baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, false, true, "{baseDN}", null, null, 10486610, new Object[0]);
                argParser.addArgument(baseDNString);
                indexList = new StringArgument("index", Character.valueOf('i'), "index", false, true, true, "{index}", null, null, 10486611, new Object[0]);
                argParser.addArgument(indexList);
                displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
                argParser.addArgument(displayUsage);
                argParser.setUsageArgument(displayUsage);
            }
            catch (ArgumentException ae) {
                int msgID2 = 10747920;
                String message3 = MessageHandler.getMessage(msgID2, ae.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                int msgID3 = 10747921;
                String message4 = MessageHandler.getMessage(msgID3, ae.getMessage());
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            int numArgs = args.length;
            if (numArgs == 0) {
                out.println(argParser.getUsage());
                return 1;
            }
            if (indexList.getValues().size() <= 0) {
                int msgID4 = 10748758;
                String message5 = MessageHandler.getMessage(msgID4);
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                out.println(argParser.getUsage());
                return 1;
            }
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            if (initializeServer) {
                try {
                    DirectoryServer.bootstrapClient();
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    int msgID5 = 10747924;
                    String message6 = MessageHandler.getMessage(msgID5, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (InitializationException ie) {
                    int msgID6 = 10747925;
                    String message7 = MessageHandler.getMessage(msgID6, ie.getMessage());
                    err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    int msgID7 = 10747925;
                    String message8 = MessageHandler.getMessage(msgID7, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (ConfigException ce) {
                    int msgID8 = 10747926;
                    String message9 = MessageHandler.getMessage(msgID8, ce.getMessage());
                    err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (InitializationException ie) {
                    int msgID9 = 10747926;
                    String message10 = MessageHandler.getMessage(msgID9, ie.getMessage());
                    err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    int msgID10 = 10747926;
                    String message11 = MessageHandler.getMessage(msgID10, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                try {
                    CoreConfigManager coreConfigManager = new CoreConfigManager();
                    coreConfigManager.initializeCoreConfig();
                }
                catch (ConfigException ce) {
                    int msgID11 = 10747927;
                    String message12 = MessageHandler.getMessage(msgID11, ce.getMessage());
                    err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (InitializationException ie) {
                    int msgID12 = 10747927;
                    String message13 = MessageHandler.getMessage(msgID12, ie.getMessage());
                    err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    int msgID13 = 10747927;
                    String message14 = MessageHandler.getMessage(msgID13, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                try {
                    directoryServer.initializeCryptoManager();
                }
                catch (ConfigException ce) {
                    int msgID14 = 10748188;
                    String message15 = MessageHandler.getMessage(msgID14, ce.getMessage());
                    err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (InitializationException ie) {
                    int msgID15 = 10748188;
                    String message16 = MessageHandler.getMessage(msgID15, ie.getMessage());
                    err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    int msgID16 = 10748188;
                    String message17 = MessageHandler.getMessage(msgID16, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                try {
                    errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                    ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                }
                catch (Exception e) {
                    err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
                }
            }
            try {
                rebuildBaseDN = DN.decode(baseDNString.getValue());
            }
            catch (DirectoryException de) {
                int msgID17 = 10747958;
                String message18 = MessageHandler.getMessage(msgID17, baseDNString.getValue(), de.getErrorMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message18, msgID17);
                return 1;
            }
            catch (Exception e) {
                int msgID18 = 10747958;
                String message19 = MessageHandler.getMessage(msgID18, baseDNString.getValue(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message19, msgID18);
                return 1;
            }
            Backend backend = null;
            ArrayList<Backend> backendList = new ArrayList<Backend>();
            ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
            ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
            int code = BackendToolUtils.getBackends(backendList, entryList, dnList);
            int numBackends = backendList.size();
            block36: for (int i = 0; i < numBackends; ++i) {
                Backend b = backendList.get(i);
                List<DN> baseDNs = dnList.get(i);
                for (DN baseDN : baseDNs) {
                    if (!baseDN.equals(rebuildBaseDN)) continue;
                    if (backend == null) {
                        backend = b;
                        DN[] baseDNArray = new DN[baseDNs.size()];
                        baseDNs.toArray(baseDNArray);
                        continue block36;
                    }
                    int msgID19 = 10748134;
                    String message20 = MessageHandler.getMessage(msgID19, baseDNString.getValue());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message20, msgID19);
                    return 1;
                }
            }
            if (backend == null) {
                msgID = 10748135;
                message2 = MessageHandler.getMessage(msgID, baseDNString.getValue());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
                return 1;
            }
            if (!(backend instanceof BackendImpl)) {
                msgID = 10748116;
                message2 = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
                return 1;
            }
            RebuildConfig rebuildConfig = new RebuildConfig();
            rebuildConfig.setBaseDN(rebuildBaseDN);
            for (String s : indexList.getValues()) {
                rebuildConfig.addRebuildIndex(s);
            }
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                    int msgID20 = 10748759;
                    message = MessageHandler.getMessage(msgID20, backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID20);
                    return 1;
                }
            }
            catch (Exception e) {
                int msgID21 = 10748759;
                String message21 = MessageHandler.getMessage(msgID21, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message21, msgID21);
                return 1;
            }
            returnCode = 0;
            BackendImpl jebBackend = (BackendImpl)backend;
            jebBackend.rebuildBackend(rebuildConfig);
            Object var31_88 = null;
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    int msgID22 = 10617688;
                    String message22 = MessageHandler.getMessage(msgID22, backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message22, msgID22);
                }
                break block50;
            }
            catch (Exception e2) {
                int msgID23 = 10617688;
                String message23 = MessageHandler.getMessage(msgID23, backend.getBackendID(), StaticUtils.getExceptionMessage(e2));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID23);
            }
            break block50;
            {
                catch (Exception e) {
                    int msgID24 = 10748756;
                    message = MessageHandler.getMessage(msgID24, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID24);
                    returnCode = 1;
                    Object var31_89 = null;
                    try {
                        String lockFile = LockFileManager.getBackendLockFileName(backend);
                        StringBuilder failureReason = new StringBuilder();
                        if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                            int msgID22 = 10617688;
                            String message22 = MessageHandler.getMessage(msgID22, backend.getBackendID(), String.valueOf(failureReason));
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message22, msgID22);
                        }
                        break block50;
                    }
                    catch (Exception e2) {
                        int msgID23 = 10617688;
                        String message23 = MessageHandler.getMessage(msgID23, backend.getBackendID(), StaticUtils.getExceptionMessage(e2));
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID23);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var31_90 = null;
                try {
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder failureReason = new StringBuilder();
                    if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                        int msgID22 = 10617688;
                        String message22 = MessageHandler.getMessage(msgID22, backend.getBackendID(), String.valueOf(failureReason));
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message22, msgID22);
                    }
                }
                catch (Exception e2) {
                    int msgID23 = 10617688;
                    String message23 = MessageHandler.getMessage(msgID23, backend.getBackendID(), StaticUtils.getExceptionMessage(e2));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID23);
                }
                throw throwable;
            }
        }
        return returnCode;
    }
}

