/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.extensions.PasswordPolicyStateExtendedOperation;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.MultiChoiceArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageAccount {
    private static final String CLASS_NAME = "org.opends.server.tools.ManageAccount";
    private static final String SC_GET_ALL = "get-all";
    private static final String SC_GET_PASSWORD_POLICY_DN = "get-password-policy-dn";
    private static final String SC_GET_ACCOUNT_DISABLED_STATE = "get-account-is-disabled";
    private static final String SC_SET_ACCOUNT_DISABLED_STATE = "set-account-is-disabled";
    private static final String SC_CLEAR_ACCOUNT_DISABLED_STATE = "clear-account-is-disabled";
    private static final String SC_GET_ACCOUNT_EXPIRATION_TIME = "get-account-expiration-time";
    private static final String SC_SET_ACCOUNT_EXPIRATION_TIME = "set-account-expiration-time";
    private static final String SC_CLEAR_ACCOUNT_EXPIRATION_TIME = "clear-account-expiration-time";
    private static final String SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION = "get-seconds-until-account-expiration";
    private static final String SC_GET_PASSWORD_CHANGED_TIME = "get-password-changed-time";
    private static final String SC_SET_PASSWORD_CHANGED_TIME = "set-password-changed-time";
    private static final String SC_CLEAR_PASSWORD_CHANGED_TIME = "clear-password-changed-time";
    private static final String SC_GET_PASSWORD_EXP_WARNED_TIME = "get-password-expiration-warned-time";
    private static final String SC_SET_PASSWORD_EXP_WARNED_TIME = "set-password-expiration-warned-time";
    private static final String SC_CLEAR_PASSWORD_EXP_WARNED_TIME = "clear-password-expiration-warned-time";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION = "get-seconds-until-password-expiration";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING = "get-seconds-until-password-expiration-warning";
    private static final String SC_GET_AUTHENTICATION_FAILURE_TIMES = "get-authentication-failure-times";
    private static final String SC_ADD_AUTHENTICATION_FAILURE_TIME = "add-authentication-failure-time";
    private static final String SC_SET_AUTHENTICATION_FAILURE_TIMES = "set-authentication-failure-times";
    private static final String SC_CLEAR_AUTHENTICATION_FAILURE_TIMES = "clear-authentication-failure-times";
    private static final String SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK = "get-seconds-until-authentication-failure-unlock";
    private static final String SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT = "get-remaining-authentication-failure-count";
    private static final String SC_GET_LAST_LOGIN_TIME = "get-last-login-time";
    private static final String SC_SET_LAST_LOGIN_TIME = "set-last-login-time";
    private static final String SC_CLEAR_LAST_LOGIN_TIME = "clear-last-login-time";
    private static final String SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT = "get-seconds-until-idle-lockout";
    private static final String SC_GET_PASSWORD_RESET_STATE = "get-password-is-reset";
    private static final String SC_SET_PASSWORD_RESET_STATE = "set-password-is-reset";
    private static final String SC_CLEAR_PASSWORD_RESET_STATE = "clear-password-is-reset";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT = "get-seconds-until-password-reset-lockout";
    private static final String SC_GET_GRACE_LOGIN_USE_TIMES = "get-grace-login-use-times";
    private static final String SC_ADD_GRACE_LOGIN_USE_TIME = "add-grace-login-use-time";
    private static final String SC_SET_GRACE_LOGIN_USE_TIMES = "set-grace-login-use-times";
    private static final String SC_CLEAR_GRACE_LOGIN_USE_TIMES = "clear-grace-login-use-times";
    private static final String SC_GET_REMAINING_GRACE_LOGIN_COUNT = "get-remaining-grace-login-count";
    private static final String SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME = "get-password-changed-by-required-time";
    private static final String SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME = "set-password-changed-by-required-time";
    private static final String SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME = "clear-password-changed-by-required-time";
    private static final String SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME = "get-seconds-until-required-change-time";
    private static final String SC_GET_PASSWORD_HISTORY = "get-password-history";
    private static final String SC_CLEAR_PASSWORD_HISTORY = "clear-password-history";
    private static final String ARG_OP_VALUE = "opvalue";
    private static final String NO_VALUE = null;
    private static LDAPReader ldapReader;
    private static LDAPWriter ldapWriter;
    private static AtomicInteger nextMessageID;
    private static LDAPConnection connection;
    private static PrintStream err;
    private static PrintStream out;
    private static String targetDNString;
    private static SubCommandArgumentParser argParser;

    public static void main(String[] args) {
        int returnCode = ManageAccount.main(args, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(String[] args, OutputStream outStream, OutputStream errStream) {
        out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        int result = ManageAccount.parseArgsAndConnect(args);
        if (result < 0) {
            return 0;
        }
        if (result != 0) {
            return result;
        }
        try {
            ArrayList<ASN1Element> responseOpElements;
            ArrayList<ASN1Element> opElements = new ArrayList<ASN1Element>(1);
            result = ManageAccount.processSubcommand(opElements);
            if (result != 0) {
                int n = result;
                return n;
            }
            ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(2);
            valueElements.add(new ASN1OctetString(targetDNString));
            if (!opElements.isEmpty()) {
                valueElements.add(new ASN1Sequence(opElements));
            }
            ASN1OctetString requestValue = new ASN1OctetString(new ASN1Sequence(valueElements).encode());
            ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.26027.1.6.1", requestValue);
            LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest);
            try {
                ldapWriter.writeMessage(requestMessage);
            }
            catch (Exception e) {
                int msgID = 10749063;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = 81;
                if (connection != null) {
                    connection.close(nextMessageID);
                }
                return n;
            }
            LDAPMessage responseMessage = ldapReader.readMessage();
            if (responseMessage == null) {
                int msgID = 10749064;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = 81;
                return n;
            }
            ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
            int resultCode = extendedResponse.getResultCode();
            if (resultCode != 0) {
                int msgID = 10749065;
                String message = MessageHandler.getMessage(msgID, resultCode, LDAPResultCode.toString(resultCode), String.valueOf(extendedResponse.getErrorMessage()));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = resultCode;
                return n;
            }
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(extendedResponse.getValue().value());
                responseOpElements = valueSequence.elements().get(1).decodeAsSequence().elements();
            }
            catch (Exception e) {
                int msgID = 10749066;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int valueSequence = 81;
                return valueSequence;
            }
            block36: for (ASN1Element opElement : responseOpElements) {
                int msgID;
                ArrayList<String> opValues;
                int opType;
                block46: {
                    try {
                        ASN1Sequence opSequence = opElement.decodeAsSequence();
                        ArrayList<ASN1Element> elements = opSequence.elements();
                        opType = elements.get(0).decodeAsEnumerated().intValue();
                        opValues = new ArrayList<String>();
                        if (elements.size() != 2) break block46;
                        for (ASN1Element e : elements.get(1).decodeAsSequence().elements()) {
                            opValues.add(e.decodeAsOctetString().stringValue());
                        }
                    }
                    catch (Exception e) {
                        int msgID2 = 10749067;
                        String message = MessageHandler.getMessage(msgID2, StaticUtils.getExceptionMessage(e));
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                }
                switch (opType) {
                    case 0: {
                        msgID = 10486924;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 1: {
                        msgID = 10486925;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 4: {
                        msgID = 10486926;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 7: {
                        msgID = 10486927;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 8: {
                        msgID = 10486928;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 11: {
                        msgID = 10486929;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 14: {
                        msgID = 10486930;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 15: {
                        msgID = 10486931;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 16: {
                        msgID = 10486932;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 20: {
                        msgID = 10486933;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 21: {
                        msgID = 10486934;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 22: {
                        msgID = 10486935;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 25: {
                        msgID = 10486936;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 26: {
                        msgID = 10486937;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 29: {
                        msgID = 10486938;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 30: {
                        msgID = 10486939;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 34: {
                        msgID = 10486940;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 35: {
                        msgID = 10486941;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 38: {
                        msgID = 10486942;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                    case 39: {
                        msgID = 10486961;
                        ManageAccount.printLabelAndValues(msgID, opValues);
                        continue block36;
                    }
                }
                msgID = 10749087;
                String message = MessageHandler.getMessage(msgID, opType);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            int n = 0;
            return n;
        }
        finally {
            if (connection != null) {
                connection.close(nextMessageID);
            }
        }
    }

    private static int parseArgsAndConnect(String[] args) {
        String message;
        String message2;
        StringArgument trustStorePW;
        StringArgument trustStoreFile;
        StringArgument certNickname;
        StringArgument keyStorePW;
        StringArgument keyStoreFile;
        BooleanArgument trustAll;
        StringArgument saslOption;
        StringArgument targetDN;
        StringArgument bindPW;
        StringArgument bindDN;
        BooleanArgument useStartTLS;
        BooleanArgument useSSL;
        IntegerArgument port;
        StringArgument host;
        int msgID = 10486854;
        argParser = new SubCommandArgumentParser(CLASS_NAME, MessageHandler.getMessage(msgID), false);
        try {
            host = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "127.0.0.1", null, 10486855, new Object[0]);
            argParser.addGlobalArgument(host);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, true, 1, true, 65535, 10486856, new Object[0]);
            argParser.addGlobalArgument(port);
            useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", 10486857, new Object[0]);
            argParser.addGlobalArgument(useSSL);
            useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", 0xA0044A, new Object[0]);
            argParser.addGlobalArgument(useStartTLS);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 10486859, new Object[0]);
            argParser.addGlobalArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10486860, new Object[0]);
            argParser.addGlobalArgument(bindPW);
            FileBasedArgument bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10486861, new Object[0]);
            argParser.addGlobalArgument(bindPWFile);
            targetDN = new StringArgument("targetdn", Character.valueOf('b'), "targetDN", true, false, true, "{targetDN}", null, null, 10486862, new Object[0]);
            argParser.addGlobalArgument(targetDN);
            saslOption = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, 10486863, new Object[0]);
            argParser.addGlobalArgument(saslOption);
            trustAll = new BooleanArgument("trustall", Character.valueOf('X'), "trustAll", 10486864, new Object[0]);
            argParser.addGlobalArgument(trustAll);
            keyStoreFile = new StringArgument("keystorefile", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10486865, new Object[0]);
            argParser.addGlobalArgument(keyStoreFile);
            keyStorePW = new StringArgument("keystorepw", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 10486866, new Object[0]);
            argParser.addGlobalArgument(keyStorePW);
            FileBasedArgument keyStorePWFile = new FileBasedArgument("keystorepwfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486867, new Object[0]);
            argParser.addGlobalArgument(keyStorePWFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
            argParser.addGlobalArgument(certNickname);
            trustStoreFile = new StringArgument("truststorefile", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10486868, new Object[0]);
            argParser.addGlobalArgument(trustStoreFile);
            trustStorePW = new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486869, new Object[0]);
            argParser.addGlobalArgument(trustStorePW);
            FileBasedArgument trustStorePWFile = new FileBasedArgument("truststorepwfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486870, new Object[0]);
            argParser.addGlobalArgument(trustStorePWFile);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", 10486871, new Object[0]);
            argParser.addGlobalArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
            HashSet<String> booleanValues = new HashSet<String>(2);
            booleanValues.add("true");
            booleanValues.add("false");
            msgID = 10486872;
            new SubCommand(argParser, SC_GET_ALL, msgID, new Object[0]);
            msgID = 10486873;
            new SubCommand(argParser, SC_GET_PASSWORD_POLICY_DN, msgID, new Object[0]);
            msgID = 10486874;
            new SubCommand(argParser, SC_GET_ACCOUNT_DISABLED_STATE, msgID, new Object[0]);
            msgID = 10486875;
            SubCommand sc = new SubCommand(argParser, SC_SET_ACCOUNT_DISABLED_STATE, msgID, new Object[0]);
            sc.addArgument(new MultiChoiceArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", true, false, true, "{true|false}", null, null, booleanValues, false, 10486876, new Object[0]));
            msgID = 10486877;
            new SubCommand(argParser, SC_CLEAR_ACCOUNT_DISABLED_STATE, msgID, new Object[0]);
            msgID = 10486878;
            new SubCommand(argParser, SC_GET_ACCOUNT_EXPIRATION_TIME, msgID, new Object[0]);
            msgID = 10486879;
            sc = new SubCommand(argParser, SC_SET_ACCOUNT_EXPIRATION_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486881;
            sc = new SubCommand(argParser, SC_CLEAR_ACCOUNT_EXPIRATION_TIME, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486882;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION, msgID, new Object[0]);
            msgID = 10486883;
            new SubCommand(argParser, SC_GET_PASSWORD_CHANGED_TIME, msgID, new Object[0]);
            msgID = 10486884;
            sc = new SubCommand(argParser, SC_SET_PASSWORD_CHANGED_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486885;
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_CHANGED_TIME, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486886;
            new SubCommand(argParser, SC_GET_PASSWORD_EXP_WARNED_TIME, msgID, new Object[0]);
            msgID = 10486887;
            sc = new SubCommand(argParser, SC_SET_PASSWORD_EXP_WARNED_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486888;
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_EXP_WARNED_TIME, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486889;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION, msgID, new Object[0]);
            msgID = 10486890;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING, msgID, new Object[0]);
            msgID = 10486891;
            new SubCommand(argParser, SC_GET_AUTHENTICATION_FAILURE_TIMES, msgID, new Object[0]);
            msgID = 10486892;
            sc = new SubCommand(argParser, SC_ADD_AUTHENTICATION_FAILURE_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486893;
            sc = new SubCommand(argParser, SC_SET_AUTHENTICATION_FAILURE_TIMES, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, 10486894, new Object[0]));
            sc.setHidden(true);
            msgID = 10486895;
            sc = new SubCommand(argParser, SC_CLEAR_AUTHENTICATION_FAILURE_TIMES, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486896;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK, msgID, new Object[0]);
            msgID = 10486897;
            new SubCommand(argParser, SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT, msgID, new Object[0]);
            msgID = 10486898;
            new SubCommand(argParser, SC_GET_LAST_LOGIN_TIME, msgID, new Object[0]);
            msgID = 10486899;
            sc = new SubCommand(argParser, SC_SET_LAST_LOGIN_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486900;
            sc = new SubCommand(argParser, SC_CLEAR_LAST_LOGIN_TIME, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486901;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT, msgID, new Object[0]);
            msgID = 10486902;
            new SubCommand(argParser, SC_GET_PASSWORD_RESET_STATE, msgID, new Object[0]);
            msgID = 10486903;
            sc = new SubCommand(argParser, SC_SET_PASSWORD_RESET_STATE, msgID, new Object[0]);
            sc.addArgument(new MultiChoiceArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", true, false, true, "{true|false}", null, null, booleanValues, false, 10486876, new Object[0]));
            sc.setHidden(true);
            msgID = 10486904;
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_RESET_STATE, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486905;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT, msgID, new Object[0]);
            msgID = 10486906;
            new SubCommand(argParser, SC_GET_GRACE_LOGIN_USE_TIMES, msgID, new Object[0]);
            msgID = 10486907;
            sc = new SubCommand(argParser, SC_ADD_GRACE_LOGIN_USE_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486908;
            sc = new SubCommand(argParser, SC_SET_GRACE_LOGIN_USE_TIMES, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, 10486894, new Object[0]));
            sc.setHidden(true);
            msgID = 10486909;
            sc = new SubCommand(argParser, SC_CLEAR_GRACE_LOGIN_USE_TIMES, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486910;
            new SubCommand(argParser, SC_GET_REMAINING_GRACE_LOGIN_COUNT, msgID, new Object[0]);
            msgID = 10486911;
            new SubCommand(argParser, SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME, msgID, new Object[0]);
            msgID = 10486912;
            sc = new SubCommand(argParser, SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME, msgID, new Object[0]);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, 10486880, new Object[0]));
            sc.setHidden(true);
            msgID = 10486913;
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME, msgID, new Object[0]);
            sc.setHidden(true);
            msgID = 10486914;
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME, msgID, new Object[0]);
            msgID = 10486962;
            new SubCommand(argParser, SC_GET_PASSWORD_HISTORY, msgID, new Object[0]);
            msgID = 10486963;
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_HISTORY, msgID, new Object[0]);
            sc.setHidden(true);
        }
        catch (ArgumentException ae) {
            msgID = 10747920;
            String message3 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            return 82;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            msgID = 10747921;
            message2 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return -1;
        }
        targetDNString = targetDN.getValue();
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        if (useSSL.isPresent()) {
            if (useStartTLS.isPresent()) {
                msgID = 0xA404A0;
                message2 = MessageHandler.getMessage(msgID, useSSL.getLongIdentifier(), useStartTLS.getLongIdentifier());
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setUseSSL(true);
        } else if (useStartTLS.isPresent()) {
            connectionOptions.setStartTLS(true);
        }
        if (useSSL.isPresent() || useStartTLS.isPresent()) {
            try {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStoreFile.getValue(), keyStorePW.getValue(), clientAlias, trustStoreFile.getValue(), trustStorePW.getValue());
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (SSLConnectionException sce) {
                msgID = 10749089;
                String message4 = MessageHandler.getMessage(msgID, sce.getMessage());
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 82;
            }
        }
        if (saslOption.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    msgID = 10749090;
                    String message5 = MessageHandler.getMessage(msgID, s);
                    err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                msgID = 10749091;
                String message6 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        nextMessageID = new AtomicInteger(1);
        try {
            connection = new LDAPConnection(host.getValue(), port.getIntValue(), connectionOptions, out, err);
            connection.connectToHost(bindDN.getValue(), bindPW.getValue(), nextMessageID);
        }
        catch (ArgumentException ae) {
            msgID = 0xA404A4;
            message = MessageHandler.getMessage(msgID, port.getLongIdentifier(), ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        catch (LDAPConnectionException lce) {
            msgID = 10749093;
            message = MessageHandler.getMessage(msgID, lce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 91;
        }
        ldapReader = connection.getLDAPReader();
        ldapWriter = connection.getLDAPWriter();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int processSubcommand(ArrayList<ASN1Element> opElements) {
        SubCommand subCommand = argParser.getSubCommand();
        if (subCommand == null) {
            int msgID = 10749059;
            String message = MessageHandler.getMessage(msgID);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        String subCommandName = subCommand.getName();
        if (subCommandName.equals(SC_GET_ALL)) {
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_POLICY_DN)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(0, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_ACCOUNT_DISABLED_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(1, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_ACCOUNT_DISABLED_STATE)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                String valueStr = a.getValue();
                if (valueStr.equalsIgnoreCase("true")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(2, "true"));
                    return 0;
                }
                if (valueStr.equalsIgnoreCase("false")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(2, "false"));
                    return 0;
                }
                int msgID = 10749060;
                String message = MessageHandler.getMessage(msgID, valueStr);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            int msgID = 10749061;
            String message = MessageHandler.getMessage(msgID);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (subCommandName.equals(SC_CLEAR_ACCOUNT_DISABLED_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(3, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_ACCOUNT_EXPIRATION_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(4, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_ACCOUNT_EXPIRATION_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(5, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(5, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_ACCOUNT_EXPIRATION_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(6, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(7, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_CHANGED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(8, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_CHANGED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(9, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(9, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_CHANGED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(10, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_EXP_WARNED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(11, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_EXP_WARNED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(12, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(12, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_EXP_WARNED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(13, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(14, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(15, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_AUTHENTICATION_FAILURE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(16, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_ADD_AUTHENTICATION_FAILURE_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(17, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(17, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_AUTHENTICATION_FAILURE_TIMES)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                ArrayList<String> valueList = new ArrayList<String>(a.getValues());
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                opElements.add(PasswordPolicyStateExtendedOperation.encode(18, values));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(18, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_AUTHENTICATION_FAILURE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(19, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(20, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(21, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_LAST_LOGIN_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(22, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_LAST_LOGIN_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(23, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(23, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_LAST_LOGIN_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(24, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(25, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_RESET_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(26, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_RESET_STATE)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                String valueStr = a.getValue();
                if (valueStr.equalsIgnoreCase("true")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(27, "true"));
                    return 0;
                }
                if (valueStr.equalsIgnoreCase("false")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(27, "false"));
                    return 0;
                }
                int msgID = 10749060;
                String message = MessageHandler.getMessage(msgID, valueStr);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            int msgID = 10749061;
            String message = MessageHandler.getMessage(msgID);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_RESET_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(26, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(29, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_GRACE_LOGIN_USE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(30, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_ADD_GRACE_LOGIN_USE_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(31, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(31, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_GRACE_LOGIN_USE_TIMES)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                ArrayList<String> valueList = new ArrayList<String>(a.getValues());
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                opElements.add(PasswordPolicyStateExtendedOperation.encode(32, values));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(32, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_GRACE_LOGIN_USE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(33, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_REMAINING_GRACE_LOGIN_COUNT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(34, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(35, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(36, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(36, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(37, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(38, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_HISTORY)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(39, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_HISTORY)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(40, NO_VALUE));
            return 0;
        }
        int msgID = 10749062;
        String message = MessageHandler.getMessage(msgID, subCommandName);
        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        err.println(argParser.getUsage());
        return 89;
    }

    private static void printLabelAndValues(int msgID, ArrayList<String> values) {
        String label = MessageHandler.getMessage(msgID);
        if (values == null || values.isEmpty()) {
            out.print(label);
            out.println(":");
        } else {
            for (String value : values) {
                out.print(label);
                out.print(":  ");
                out.println(value);
            }
        }
    }
}

