/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RawModification;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFModify {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFModify";

    public static boolean modifyLDIF(LDIFReader sourceReader, LDIFReader changeReader, LDIFWriter targetWriter, List<String> errorList) throws IOException, LDIFException {
        TreeMap<DN, AddChangeRecordEntry> adds = new TreeMap<DN, AddChangeRecordEntry>();
        TreeMap<DN, Entry> ldifEntries = new TreeMap<DN, Entry>();
        HashMap<DN, DeleteChangeRecordEntry> deletes = new HashMap<DN, DeleteChangeRecordEntry>();
        HashMap modifications = new HashMap();
        block14: while (true) {
            ChangeRecordEntry changeRecord;
            try {
                changeRecord = changeReader.readChangeRecord(false);
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    errorList.add(le.getMessage());
                    continue;
                }
                throw le;
            }
            if (changeRecord == null) break;
            DN changeDN = changeRecord.getDN();
            switch (changeRecord.getChangeOperationType()) {
                case ADD: {
                    if (adds.containsKey(changeDN)) {
                        int msgID = 10682978;
                        errorList.add(MessageHandler.getMessage(msgID, String.valueOf(changeDN)));
                        continue block14;
                    }
                    adds.put(changeDN, (AddChangeRecordEntry)changeRecord);
                    break;
                }
                case DELETE: {
                    if (adds.containsKey(changeDN)) {
                        int msgID = 10682979;
                        errorList.add(MessageHandler.getMessage(msgID, String.valueOf(changeDN)));
                        continue block14;
                    }
                    modifications.remove(changeDN);
                    deletes.put(changeDN, (DeleteChangeRecordEntry)changeRecord);
                    break;
                }
                case MODIFY: {
                    if (adds.containsKey(changeDN) || deletes.containsKey(changeDN)) {
                        int msgID = 10682980;
                        errorList.add(MessageHandler.getMessage(msgID, String.valueOf(changeDN)));
                        continue block14;
                    }
                    LinkedList<Modification> mods = (LinkedList<Modification>)modifications.get(changeDN);
                    if (mods == null) {
                        mods = new LinkedList<Modification>();
                        modifications.put(changeDN, mods);
                    }
                    Iterator<RawModification> i$ = ((ModifyChangeRecordEntry)changeRecord).getModifications().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block14;
                        RawModification mod = i$.next();
                        try {
                            mods.add(mod.toModification());
                        }
                        catch (LDAPException le) {
                            errorList.add(le.getMessage());
                        }
                    }
                }
                case MODIFY_DN: {
                    int msgID = 10682981;
                    errorList.add(MessageHandler.getMessage(msgID, String.valueOf(changeDN)));
                    continue block14;
                }
                default: {
                    int msgID = 10682982;
                    errorList.add(MessageHandler.getMessage(msgID, String.valueOf(changeDN), String.valueOf((Object)changeRecord.getChangeOperationType())));
                    continue block14;
                }
            }
        }
        while (true) {
            Entry entry;
            try {
                entry = sourceReader.readEntry();
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    errorList.add(le.getMessage());
                    continue;
                }
                throw le;
            }
            if (entry == null) break;
            DN entryDN = entry.getDN();
            if (deletes.remove(entryDN) != null) continue;
            if (adds.remove(entryDN) != null) {
                int msgID = 10682983;
                errorList.add(MessageHandler.getMessage(msgID, String.valueOf(entryDN)));
                continue;
            }
            LinkedList mods = (LinkedList)modifications.remove(entryDN);
            if (mods != null && !mods.isEmpty()) {
                try {
                    entry.applyModifications(mods);
                }
                catch (DirectoryException de) {
                    errorList.add(de.getErrorMessage());
                    continue;
                }
            }
            ldifEntries.put(entry.getDN(), entry);
        }
        for (AddChangeRecordEntry add : adds.values()) {
            LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
            LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            for (Attribute a : add.getAttributes()) {
                List<Attribute> attrList;
                AttributeType t = a.getAttributeType();
                if (t.isObjectClassType()) {
                    for (AttributeValue v : a.getValues()) {
                        String stringValue = v.getStringValue();
                        String lowerValue = StaticUtils.toLowerCase(stringValue);
                        ObjectClass oc = DirectoryServer.getObjectClass(lowerValue, true);
                        objectClasses.put(oc, stringValue);
                    }
                    continue;
                }
                if (t.isOperational()) {
                    attrList = (LinkedList<Attribute>)operationalAttributes.get(t);
                    if (attrList == null) {
                        attrList = new LinkedList<Attribute>();
                        operationalAttributes.put(t, attrList);
                    }
                    attrList.add(a);
                    continue;
                }
                attrList = (List)userAttributes.get(t);
                if (attrList == null) {
                    attrList = new LinkedList();
                    userAttributes.put(t, attrList);
                }
                attrList.add(a);
            }
            Entry e = new Entry(add.getDN(), objectClasses, userAttributes, operationalAttributes);
            ldifEntries.put(e.getDN(), e);
        }
        if (!deletes.isEmpty()) {
            for (DN dn : deletes.keySet()) {
                int msgID = 10682984;
                errorList.add(MessageHandler.getMessage(msgID, String.valueOf(dn)));
            }
        }
        if (!modifications.isEmpty()) {
            for (DN dn : modifications.keySet()) {
                int msgID = 10682985;
                errorList.add(MessageHandler.getMessage(msgID, String.valueOf(dn)));
            }
        }
        return targetWriter.writeEntries(ldifEntries.values()) && errorList.isEmpty();
    }

    public static void main(String[] args) {
        int returnCode = LDIFModify.ldifModifyMain(args, false, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int ldifModifyMain(String[] args, boolean serverInitialized, OutputStream outStream, OutputStream errStream) {
        boolean successful;
        LDIFWriter targetWriter;
        LDIFReader changeReader;
        LDIFReader sourceReader;
        File source;
        StringArgument targetFile;
        StringArgument changesFile;
        StringArgument sourceFile;
        StringArgument configClass;
        StringArgument configFile;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String toolDescription = MessageHandler.getMessage(10486455);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            sourceFile = new StringArgument("sourceldif", Character.valueOf('s'), "sourceLDIF", true, false, true, "{file}", null, null, 10486380, new Object[0]);
            argParser.addArgument(sourceFile);
            changesFile = new StringArgument("changesldif", Character.valueOf('m'), "changesLDIF", true, false, true, "{file}", null, null, 10486381, new Object[0]);
            argParser.addArgument(changesFile);
            targetFile = new StringArgument("targetldif", Character.valueOf('t'), "targetLDIF", true, false, true, "{file}", null, null, 10486382, new Object[0]);
            argParser.addArgument(targetFile);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 10486383, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(message);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(message);
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (!serverInitialized) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            directoryServer.bootstrapClient();
            boolean checkSchema = configFile.isPresent();
            if (checkSchema) {
                try {
                    directoryServer.initializeJMX();
                }
                catch (Exception e) {
                    int msgID = 10748530;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (Exception e) {
                    int msgID = 10748531;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (Exception e) {
                    int msgID = 10748532;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        }
        if (!(source = new File(sourceFile.getValue())).exists()) {
            int msgID = 10748533;
            String message = MessageHandler.getMessage(msgID, sourceFile.getValue());
            err.println(message);
            return 89;
        }
        LDIFImportConfig importConfig = new LDIFImportConfig(sourceFile.getValue());
        try {
            sourceReader = new LDIFReader(importConfig);
        }
        catch (IOException ioe) {
            int msgID = 10748534;
            String message = MessageHandler.getMessage(msgID, sourceFile.getValue(), String.valueOf(ioe));
            err.println(message);
            return 82;
        }
        File changes = new File(changesFile.getValue());
        if (!changes.exists()) {
            int msgID = 10748535;
            String message = MessageHandler.getMessage(msgID, changesFile.getValue());
            err.println(message);
            return 89;
        }
        importConfig = new LDIFImportConfig(changesFile.getValue());
        try {
            changeReader = new LDIFReader(importConfig);
        }
        catch (IOException ioe) {
            int msgID = 10748536;
            String message = MessageHandler.getMessage(msgID, sourceFile.getValue());
            err.println(message);
            return 82;
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(targetFile.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            targetWriter = new LDIFWriter(exportConfig);
        }
        catch (IOException ioe) {
            int msgID = 10748537;
            String message = MessageHandler.getMessage(msgID, sourceFile.getValue());
            err.println(message);
            return 82;
        }
        LinkedList<String> errorList = new LinkedList<String>();
        try {
            successful = LDIFModify.modifyLDIF(sourceReader, changeReader, targetWriter, errorList);
        }
        catch (Exception e) {
            int msgID = 10748538;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(message);
            successful = false;
        }
        try {
            sourceReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            changeReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            targetWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (String s : errorList) {
            err.println(s);
        }
        return successful ? 0 : 1;
    }
}

