/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.ServerSideSortResponseControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPSearchOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSearch {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPSearch";
    private ArrayList<LDAPControl> responseControls;
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPSearch(AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
        this.responseControls = new ArrayList();
    }

    public int executeSearch(LDAPConnection connection, String baseDN, ArrayList<LDAPFilter> filters, LinkedHashSet<String> attributes, LDAPSearchOptions searchOptions, int wrapColumn) throws IOException, LDAPException {
        int matchingEntries = 0;
        for (LDAPFilter filter : filters) {
            ASN1OctetString asn1OctetStr = new ASN1OctetString(baseDN);
            SearchRequestProtocolOp protocolOp = new SearchRequestProtocolOp(asn1OctetStr, searchOptions.getSearchScope(), searchOptions.getDereferencePolicy(), searchOptions.getSizeLimit(), searchOptions.getTimeLimit(), false, filter, attributes);
            if (searchOptions.showOperations()) continue;
            try {
                byte opType;
                boolean typesOnly = searchOptions.getTypesOnly();
                LDAPMessage message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp, searchOptions.getControls());
                connection.getLDAPWriter().writeMessage(message);
                do {
                    int resultCode = 0;
                    String errorMessage = null;
                    DN matchedDN = null;
                    LDAPMessage responseMessage = connection.getLDAPReader().readMessage();
                    this.responseControls = responseMessage.getControls();
                    opType = responseMessage.getProtocolOpType();
                    switch (opType) {
                        case 100: {
                            for (LDAPControl c : this.responseControls) {
                                int msgID;
                                if (c.getOID().equals("2.16.840.1.113730.3.4.7")) {
                                    try {
                                        EntryChangeNotificationControl ecn = EntryChangeNotificationControl.decodeControl(c.getControl());
                                        msgID = 10486468;
                                        this.out.println(MessageHandler.getMessage(msgID, ecn.getChangeType().toString()));
                                        DN previousDN = ecn.getPreviousDN();
                                        if (previousDN == null) continue;
                                        msgID = 10486469;
                                        this.out.println(MessageHandler.getMessage(msgID, previousDN.toString()));
                                    }
                                    catch (Exception e) {}
                                    continue;
                                }
                                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.8")) continue;
                                try {
                                    AccountUsableResponseControl acrc = AccountUsableResponseControl.decodeControl(c.getControl());
                                    msgID = 10486470;
                                    this.out.println(MessageHandler.getMessage(msgID));
                                    if (acrc.isUsable()) {
                                        msgID = 10486471;
                                        this.out.println(MessageHandler.getMessage(msgID));
                                        if (acrc.getSecondsBeforeExpiration() <= 0) continue;
                                        int timeToExp = acrc.getSecondsBeforeExpiration();
                                        String timeToExpStr = StaticUtils.secondsToTimeString(timeToExp);
                                        msgID = 10486472;
                                        this.out.println(MessageHandler.getMessage(msgID, timeToExpStr));
                                        continue;
                                    }
                                    msgID = 10486473;
                                    this.out.println(MessageHandler.getMessage(msgID));
                                    if (acrc.isInactive()) {
                                        msgID = 10486474;
                                        this.out.println(MessageHandler.getMessage(msgID));
                                    }
                                    if (acrc.isReset()) {
                                        msgID = 10486475;
                                        this.out.println(MessageHandler.getMessage(msgID));
                                    }
                                    if (acrc.isExpired()) {
                                        msgID = 10486476;
                                        this.out.println(MessageHandler.getMessage(msgID));
                                        if (acrc.getRemainingGraceLogins() > 0) {
                                            msgID = 10486477;
                                            this.out.println(MessageHandler.getMessage(msgID, acrc.getRemainingGraceLogins()));
                                        }
                                    }
                                    if (!acrc.isLocked()) continue;
                                    msgID = 10486478;
                                    this.out.println(MessageHandler.getMessage(msgID));
                                    if (acrc.getSecondsBeforeUnlock() <= 0) continue;
                                    int timeToUnlock = acrc.getSecondsBeforeUnlock();
                                    String timeToUnlockStr = StaticUtils.secondsToTimeString(timeToUnlock);
                                    msgID = 10486479;
                                    this.out.println(MessageHandler.getMessage(msgID, timeToUnlockStr));
                                }
                                catch (Exception e) {}
                            }
                            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
                            StringBuilder sb = new StringBuilder();
                            this.toLDIF(searchEntryOp, sb, wrapColumn, typesOnly);
                            this.out.print(sb.toString());
                            ++matchingEntries;
                            break;
                        }
                        case 115: {
                            SearchResultReferenceProtocolOp searchRefOp = responseMessage.getSearchResultReferenceProtocolOp();
                            this.out.println(searchRefOp.toString());
                            break;
                        }
                        case 101: {
                            SearchResultDoneProtocolOp searchOp = responseMessage.getSearchResultDoneProtocolOp();
                            resultCode = searchOp.getResultCode();
                            errorMessage = searchOp.getErrorMessage();
                            matchedDN = searchOp.getMatchedDN();
                            for (LDAPControl c : responseMessage.getControls()) {
                                int msgID;
                                String msg;
                                int rc;
                                if (c.getOID().equals("1.2.840.113556.1.4.474")) {
                                    try {
                                        ServerSideSortResponseControl sortResponse = ServerSideSortResponseControl.decodeControl(c.getControl());
                                        rc = sortResponse.getResultCode();
                                        if (rc == 0) continue;
                                        int msgID2 = 10617713;
                                        msg = MessageHandler.getMessage(msgID2, LDAPResultCode.toString(rc));
                                        this.err.println(msg);
                                    }
                                    catch (Exception e) {
                                        msgID = 10617714;
                                        String msg2 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                                        this.err.println(msg2);
                                    }
                                    continue;
                                }
                                if (!c.getOID().equals("2.16.840.1.113730.3.4.10")) continue;
                                try {
                                    int msgID3;
                                    VLVResponseControl vlvResponse = VLVResponseControl.decodeControl(c.getControl());
                                    rc = vlvResponse.getVLVResultCode();
                                    if (rc == 0) {
                                        msgID3 = 10486643;
                                        msg = MessageHandler.getMessage(msgID3, vlvResponse.getTargetPosition());
                                        this.out.println(msg);
                                        msgID3 = 10486644;
                                        msg = MessageHandler.getMessage(msgID3, vlvResponse.getContentCount());
                                        this.out.println(msg);
                                        continue;
                                    }
                                    msgID3 = 10617717;
                                    msg = MessageHandler.getMessage(msgID3, LDAPResultCode.toString(rc));
                                    this.err.println(msg);
                                }
                                catch (Exception e) {
                                    msgID = 10617718;
                                    String msg3 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                                    this.err.println(msg3);
                                }
                            }
                            break;
                        }
                        default: {
                            int msgID = 10485870;
                            String msg = MessageHandler.getMessage(msgID, opType);
                            this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                        }
                    }
                    if (resultCode != 0 && resultCode != 10) {
                        int msgID = 10485865;
                        String msg = MessageHandler.getMessage(msgID, "SEARCH");
                        throw new LDAPException(resultCode, errorMessage, msgID, msg, matchedDN, null);
                    }
                    if (errorMessage == null) continue;
                    this.out.println();
                    this.out.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
                } while (opType != 101);
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                throw new IOException(ae.getMessage());
            }
        }
        if (searchOptions.countMatchingEntries()) {
            int msgID = 10486511;
            String message = MessageHandler.getMessage(msgID, matchingEntries);
            this.out.println(message);
            this.out.println();
        }
        return matchingEntries;
    }

    public void toLDIF(SearchResultEntryProtocolOp entry, StringBuilder buffer, int wrapColumn, boolean typesOnly) {
        int colsRemaining;
        String dnString = entry.getDN().toString();
        if (StaticUtils.needsBase64Encoding(dnString)) {
            dnString = Base64.encode(StaticUtils.getBytes(dnString));
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        LinkedList<LDAPAttribute> attributes = entry.getAttributes();
        for (LDAPAttribute a : attributes) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            if (typesOnly) {
                buffer.append(name);
                buffer.append(ServerConstants.EOL);
                continue;
            }
            for (ASN1OctetString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v.value())) {
                    valueString = Base64.encode(v.value());
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.stringValue();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }

    public ArrayList<LDAPControl> getResponseControls() {
        return this.responseControls;
    }

    public static void main(String[] args) {
        int retCode = LDAPSearch.mainSearch(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainSearch(String[] args) {
        return LDAPSearch.mainSearch(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainSearch(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        String message;
        String message2;
        String message3;
        String message4;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPSearchOptions searchOptions = new LDAPSearchOptions();
        LDAPConnection connection = null;
        ArrayList<LDAPFilter> filters = new ArrayList<LDAPFilter>();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        BooleanArgument continueOnError = null;
        BooleanArgument countEntries = null;
        BooleanArgument dontWrap = null;
        BooleanArgument noop = null;
        BooleanArgument reportAuthzID = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument trustAll = null;
        BooleanArgument usePasswordPolicyControl = null;
        BooleanArgument useSSL = null;
        BooleanArgument startTLS = null;
        BooleanArgument typesOnly = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument simplePageSize = null;
        IntegerArgument sizeLimit = null;
        IntegerArgument timeLimit = null;
        IntegerArgument version = null;
        StringArgument assertionFilter = null;
        StringArgument baseDN = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument dereferencePolicy = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument matchedValuesFilter = null;
        StringArgument proxyAuthzID = null;
        StringArgument pSearchInfo = null;
        StringArgument saslOptions = null;
        StringArgument searchScope = null;
        StringArgument sortOrder = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        StringArgument vlvDescriptor = null;
        StringArgument effectiveRightsUser = null;
        StringArgument effectiveRightsAttrs = null;
        String toolDescription = MessageHandler.getMessage(10486453);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", 10485886, new Object[0]);
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10485874, new Object[0]);
            argParser.addArgument(bindPasswordFile);
            baseDN = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, "{baseDN}", null, null, 10485891, new Object[0]);
            argParser.addArgument(baseDN);
            searchScope = new StringArgument("searchScope", Character.valueOf('s'), "searchScope", false, false, true, "{searchScope}", null, null, 10485894, new Object[0]);
            argParser.addArgument(searchScope);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486123, new Object[0]);
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argParser.addArgument(trustStorePasswordFile);
            proxyAuthzID = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, "{authzID}", null, null, 10486114, new Object[0]);
            argParser.addArgument(proxyAuthzID);
            reportAuthzID = new BooleanArgument("reportauthzid", Character.valueOf('E'), "reportAuthzID", 10486121, new Object[0]);
            argParser.addArgument(reportAuthzID);
            usePasswordPolicyControl = new BooleanArgument("usepwpolicycontrol", null, "usePasswordPolicyControl", 10486171, new Object[0]);
            argParser.addArgument(usePasswordPolicyControl);
            pSearchInfo = new StringArgument("psearchinfo", Character.valueOf('C'), "persistentSearch", false, false, true, "ps[:changetype[:changesonly[:entrychgcontrols]]]", null, null, 10486115, new Object[0]);
            argParser.addArgument(pSearchInfo);
            simplePageSize = new IntegerArgument("simplepagesize", null, "simplePageSize", false, false, true, "{numEntries}", 1000, null, true, 1, false, 0, 10486550, new Object[0]);
            argParser.addArgument(simplePageSize);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486102, new Object[0]);
            argParser.addArgument(assertionFilter);
            matchedValuesFilter = new StringArgument("matchedvalues", null, "matchedValuesFilter", false, true, true, "{filter}", null, null, 10486124, new Object[0]);
            argParser.addArgument(matchedValuesFilter);
            sortOrder = new StringArgument("sortorder", Character.valueOf('S'), "sortOrder", false, false, true, "{sortOrder}", null, null, 10486636, new Object[0]);
            argParser.addArgument(sortOrder);
            vlvDescriptor = new StringArgument("vlvdescriptor", Character.valueOf('G'), "virtualListView", false, false, true, "{before:after:index:count | before:after:value}", null, null, 10486638, new Object[0]);
            argParser.addArgument(vlvDescriptor);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argParser.addArgument(controlStr);
            effectiveRightsUser = new StringArgument("effectiveRightsUser", Character.valueOf('g'), "getEffectiveRightsAuthzid", false, false, true, "{authzid}", null, null, 10486648, new Object[0]);
            argParser.addArgument(effectiveRightsUser);
            effectiveRightsAttrs = new StringArgument("effectiveRightsAttrs", Character.valueOf('e'), "getEffectiveRightsAttribute", false, true, true, "{attribute}", null, null, 10486649, new Object[0]);
            argParser.addArgument(effectiveRightsAttrs);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argParser.addArgument(encodingStr);
            dereferencePolicy = new StringArgument("derefpolicy", Character.valueOf('a'), "dereferencePolicy", false, false, true, "{dereferencePolicy}", null, null, 10485895, new Object[0]);
            argParser.addArgument(dereferencePolicy);
            typesOnly = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", 10486098, new Object[0]);
            argParser.addArgument(typesOnly);
            sizeLimit = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, "{sizeLimit}", 0, null, 10485892, new Object[0]);
            argParser.addArgument(sizeLimit);
            timeLimit = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, "{timeLimit}", 0, null, 10485893, new Object[0]);
            argParser.addArgument(timeLimit);
            dontWrap = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", 10485975, new Object[0]);
            argParser.addArgument(dontWrap);
            countEntries = new BooleanArgument("countentries", null, "countEntries", 10486510, new Object[0]);
            argParser.addArgument(countEntries);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("noop", Character.valueOf('n'), "dry-run", 10486087, new Object[0]);
            argParser.addArgument(noop);
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message5 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message6 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        ArrayList<String> filterAndAttributeStrings = argParser.getTrailingArguments();
        if (filterAndAttributeStrings.size() > 0) {
            String filterString = filterAndAttributeStrings.remove(0);
            try {
                filters.add(LDAPFilter.decode(filterString));
            }
            catch (LDAPException le) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                err.println(StaticUtils.wrapText(le.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            for (String s : filterAndAttributeStrings) {
                attributes.add(s);
            }
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            int msgID = 10748606;
            message4 = MessageHandler.getMessage(msgID, bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (useSSL.isPresent() && startTLS.isPresent()) {
            int msgID = 10748606;
            message4 = MessageHandler.getMessage(msgID, useSSL.getLongIdentifier(), startTLS.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (keyStorePassword.isPresent() && keyStorePasswordFile.isPresent()) {
            int msgID = 10748606;
            message4 = MessageHandler.getMessage(msgID, keyStorePassword.getLongIdentifier(), keyStorePasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (trustStorePassword.isPresent() && trustStorePasswordFile.isPresent()) {
            int msgID = 10748606;
            message4 = MessageHandler.getMessage(msgID, trustStorePassword.getLongIdentifier(), trustStorePasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                int msgID = 10682569;
                err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID, versionNumber), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        connectionOptions.setReportAuthzID(reportAuthzID.isPresent());
        connectionOptions.setUsePasswordPolicyControl(usePasswordPolicyControl.isPresent());
        String baseDNValue = baseDN.getValue();
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
            try {
                out.print(MessageHandler.getMessage(10485959, bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        searchOptions.setTypesOnly(typesOnly.isPresent());
        searchOptions.setShowOperations(noop.isPresent());
        searchOptions.setVerbose(verbose.isPresent());
        searchOptions.setContinueOnError(continueOnError.isPresent());
        searchOptions.setEncoding(encodingStr.getValue());
        searchOptions.setCountMatchingEntries(countEntries.isPresent());
        try {
            searchOptions.setTimeLimit(timeLimit.getIntValue());
            searchOptions.setSizeLimit(sizeLimit.getIntValue());
        }
        catch (ArgumentException ex1) {
            err.println(StaticUtils.wrapText(ex1.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        boolean val = searchOptions.setSearchScope(searchScope.getValue(), err);
        if (!val) {
            return 1;
        }
        val = searchOptions.setDereferencePolicy(dereferencePolicy.getValue(), err);
        if (!val) {
            return 1;
        }
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    int msgID = 10748609;
                    String message7 = MessageHandler.getMessage(msgID, ctrlString);
                    err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                searchOptions.getControls().add(ctrl);
            }
        }
        if (effectiveRightsUser.isPresent()) {
            String authzID = effectiveRightsUser.getValue();
            if (!authzID.startsWith("dn:")) {
                int msgID = 10683258;
                String message8 = MessageHandler.getMessage(msgID, authzID);
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            Object v = null;
            ASN1OctetString effectiveRightsUserVal = new ASN1OctetString(authzID);
            ASN1Sequence sequence = null;
            ArrayList<ASN1Element> attrElements = new ArrayList<ASN1Element>();
            for (String a : effectiveRightsAttrs.getValues()) {
                attrElements.add(new ASN1OctetString(a));
            }
            ASN1Sequence attrSeq = new ASN1Sequence(attrElements);
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
            elements.add(effectiveRightsUserVal);
            elements.add(attrSeq);
            sequence = new ASN1Sequence(elements);
            LDAPControl effectiveRightsControl = new LDAPControl("1.3.6.1.4.1.42.2.27.9.5.2", false, new ASN1OctetString(sequence.encode()));
            searchOptions.getControls().add(effectiveRightsControl);
        }
        if (proxyAuthzID.isPresent()) {
            ASN1OctetString proxyValue = new ASN1OctetString(proxyAuthzID.getValue());
            LDAPControl proxyControl = new LDAPControl("2.16.840.1.113730.3.4.18", true, proxyValue);
            searchOptions.getControls().add(proxyControl);
        }
        if (pSearchInfo.isPresent()) {
            String message9;
            String infoString = StaticUtils.toLowerCase(pSearchInfo.getValue().trim());
            HashSet<PersistentSearchChangeType> changeTypes = new HashSet<PersistentSearchChangeType>();
            boolean changesOnly = true;
            boolean returnECs = true;
            StringTokenizer tokenizer = new StringTokenizer(infoString, ":");
            if (!tokenizer.hasMoreTokens()) {
                int msgID = 10682724;
                message3 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            String token = tokenizer.nextToken();
            if (!token.equals("ps")) {
                int msgID = 10682725;
                message9 = MessageHandler.getMessage(msgID, String.valueOf(infoString));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ", ");
                while (st.hasMoreTokens()) {
                    String token2 = st.nextToken();
                    if (token2.equals("add")) {
                        changeTypes.add(PersistentSearchChangeType.ADD);
                        continue;
                    }
                    if (token2.equals("delete") || token2.equals("del")) {
                        changeTypes.add(PersistentSearchChangeType.DELETE);
                        continue;
                    }
                    if (token2.equals("modify") || token2.equals("mod")) {
                        changeTypes.add(PersistentSearchChangeType.MODIFY);
                        continue;
                    }
                    if (token2.equals("modifydn") || token2.equals("moddn") || token2.equals("modrdn")) {
                        changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    if (token2.equals("any") || token2.equals("all")) {
                        changeTypes.add(PersistentSearchChangeType.ADD);
                        changeTypes.add(PersistentSearchChangeType.DELETE);
                        changeTypes.add(PersistentSearchChangeType.MODIFY);
                        changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    int msgID = 10682726;
                    String message10 = MessageHandler.getMessage(msgID, String.valueOf(token2));
                    err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (changeTypes.isEmpty()) {
                changeTypes.add(PersistentSearchChangeType.ADD);
                changeTypes.add(PersistentSearchChangeType.DELETE);
                changeTypes.add(PersistentSearchChangeType.MODIFY);
                changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("1") || token.equals("true") || token.equals("yes")) {
                    changesOnly = true;
                } else if (token.equals("0") || token.equals("false") || token.equals("no")) {
                    changesOnly = false;
                } else {
                    int msgID = 10682727;
                    message9 = MessageHandler.getMessage(msgID, String.valueOf(token));
                    err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("1") || token.equals("true") || token.equals("yes")) {
                    returnECs = true;
                } else if (token.equals("0") || token.equals("false") || token.equals("no")) {
                    returnECs = false;
                } else {
                    int msgID = 10682728;
                    message9 = MessageHandler.getMessage(msgID, String.valueOf(token));
                    err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            PersistentSearchControl psearchControl = new PersistentSearchControl(changeTypes, changesOnly, returnECs);
            searchOptions.getControls().add(new LDAPControl(psearchControl));
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                LDAPFilter filter = LDAPFilter.decode(filterString);
                LDAPControl assertionControl = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(filter.encode().encode()));
                searchOptions.getControls().add(assertionControl);
            }
            catch (LDAPException le) {
                int msgID = 10682711;
                message2 = MessageHandler.getMessage(msgID, le.getMessage());
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (matchedValuesFilter.isPresent()) {
            LinkedList<String> mvFilterStrings = matchedValuesFilter.getValues();
            ArrayList<MatchedValuesFilter> mvFilters = new ArrayList<MatchedValuesFilter>();
            for (String s : mvFilterStrings) {
                try {
                    LDAPFilter f = LDAPFilter.decode(s);
                    mvFilters.add(MatchedValuesFilter.createFromLDAPFilter(f));
                }
                catch (LDAPException le) {
                    int msgID = 10682733;
                    message3 = MessageHandler.getMessage(msgID, le.getMessage());
                    err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            MatchedValuesControl mvc = new MatchedValuesControl(true, mvFilters);
            searchOptions.getControls().add(new LDAPControl(mvc));
        }
        if (sortOrder.isPresent()) {
            try {
                searchOptions.getControls().add(new LDAPControl(new ServerSideSortRequestControl(sortOrder.getValue())));
            }
            catch (LDAPException le) {
                int msgID = 10683245;
                String message11 = MessageHandler.getMessage(msgID, le.getErrorMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (vlvDescriptor.isPresent()) {
            if (!sortOrder.isPresent()) {
                int msgID = 10683247;
                message = MessageHandler.getMessage(msgID, vlvDescriptor.getLongIdentifier(), sortOrder.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            StringTokenizer tokenizer = new StringTokenizer(vlvDescriptor.getValue(), ":");
            int numTokens = tokenizer.countTokens();
            if (numTokens == 3) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    ASN1OctetString assertionValue = new ASN1OctetString(tokenizer.nextToken());
                    searchOptions.getControls().add(new LDAPControl(new VLVRequestControl(beforeCount, afterCount, (ByteString)assertionValue)));
                }
                catch (Exception e) {
                    int msgID = 10683248;
                    message2 = MessageHandler.getMessage(msgID);
                    err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else if (numTokens == 4) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    int offset = Integer.parseInt(tokenizer.nextToken());
                    int contentCount = Integer.parseInt(tokenizer.nextToken());
                    searchOptions.getControls().add(new LDAPControl(new VLVRequestControl(beforeCount, afterCount, offset, contentCount)));
                }
                catch (Exception e) {
                    int msgID = 10683248;
                    message2 = MessageHandler.getMessage(msgID);
                    err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                int msgID = 10683248;
                String message12 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean propValue;
                boolean mechValue;
                if (!(saslOption.startsWith("mech=") ? !(mechValue = connectionOptions.setSASLMechanism(saslOption)) : !(propValue = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 1;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        if (connectionOptions.useSASLExternal()) {
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                int msgID = 10748610;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (keyStorePathValue == null) {
                int msgID = 10748611;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setVerbose(verbose.isPresent());
        if (fileNameValue != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(fileNameValue));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    LDAPFilter ldapFilter = LDAPFilter.decode(line);
                    filters.add(ldapFilter);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                int ldapFilter = 1;
                return ldapFilter;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (filters.isEmpty()) {
            int msgid = 10748110;
            err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgid), ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        int wrapColumn = 80;
        if (dontWrap.isPresent()) {
            wrapColumn = 0;
        }
        LDAPSearch ldapSearch = null;
        try {
            if (initializeServer) {
                DirectoryServer.bootstrapClient();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            if (noop.isPresent()) {
                int clientAlias = 0;
                return clientAlias;
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            int matchingEntries = 0;
            if (simplePageSize.isPresent()) {
                if (filters.size() > 1) {
                    int msgID = 10748695;
                    message3 = MessageHandler.getMessage(msgID);
                    throw new LDAPException(89, msgID, message3);
                }
                int pageSize = simplePageSize.getIntValue();
                ASN1OctetString cookieValue = new ASN1OctetString();
                ArrayList<LDAPControl> origControls = searchOptions.getControls();
                do {
                    ArrayList<LDAPControl> newControls = new ArrayList<LDAPControl>(origControls.size() + 1);
                    newControls.addAll(origControls);
                    newControls.add(new LDAPControl(new PagedResultsControl(true, pageSize, cookieValue)));
                    searchOptions.setControls(newControls);
                    ldapSearch = new LDAPSearch(nextMessageID, out, err);
                    matchingEntries += ldapSearch.executeSearch(connection, baseDNValue, filters, attributes, searchOptions, wrapColumn);
                    ArrayList<LDAPControl> responseControls = ldapSearch.getResponseControls();
                    boolean responseFound = false;
                    for (LDAPControl c : responseControls) {
                        if (!c.getOID().equals("1.2.840.113556.1.4.319")) continue;
                        try {
                            PagedResultsControl control = new PagedResultsControl(c.isCritical(), c.getValue());
                            responseFound = true;
                            cookieValue = control.getCookie();
                            break;
                        }
                        catch (LDAPException le) {
                            int msgID = 10748696;
                            String message13 = MessageHandler.getMessage(msgID, le.getMessage());
                            throw new LDAPException(84, msgID, message13, le);
                        }
                    }
                    if (responseFound) continue;
                    int msgID = 10748697;
                    String message14 = MessageHandler.getMessage(msgID);
                    throw new LDAPException(93, msgID, message14);
                } while (cookieValue.value().length != 0);
            } else {
                ldapSearch = new LDAPSearch(nextMessageID, out, err);
                matchingEntries = ldapSearch.executeSearch(connection, baseDNValue, filters, attributes, searchOptions, wrapColumn);
            }
            if (countEntries.isPresent()) {
                int n = matchingEntries;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessage(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN());
            int n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessage(), lce.getResultCode(), lce.getErrorMessage(), lce.getMatchedDN());
            int n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n = 1;
            return n;
        }
        finally {
            if (connection != null) {
                if (ldapSearch == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapSearch.nextMessageID);
                }
            }
        }
    }
}

