/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.net.Socket;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.VerboseTracer;
import org.opends.server.types.LDAPException;

public class LDAPReader {
    private ASN1Reader asn1Reader;
    private VerboseTracer tracer;

    public LDAPReader(Socket socket) throws IOException {
        this(socket, null);
    }

    public LDAPReader(Socket socket, VerboseTracer tracer) throws IOException {
        this.asn1Reader = new ASN1Reader(socket);
        this.tracer = tracer;
    }

    public LDAPMessage readMessage() throws IOException, ASN1Exception, LDAPException {
        ASN1Element element = this.asn1Reader.readElement();
        if (element == null) {
            return null;
        }
        ASN1Sequence sequence = ASN1Sequence.decodeAsSequence(element);
        LDAPMessage message = LDAPMessage.decode(sequence);
        if (this.tracer != null) {
            this.tracer.traceIncomingMessage(message, sequence);
        }
        return message;
    }

    public void close() {
        this.asn1Reader.close();
    }

    public ASN1Reader getASN1Reader() {
        return this.asn1Reader;
    }
}

