/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.DN;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class LDAPPasswordModify {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPPasswordModify";

    public static void main(String[] args) {
        int returnCode = LDAPPasswordModify.mainPasswordModify(args, true, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int mainPasswordModify(String[] args) {
        return LDAPPasswordModify.mainPasswordModify(args, true, System.out, System.err);
    }

    public static int mainPasswordModify(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        ASN1OctetString responseValue;
        String message;
        ArrayList<LDAPControl> responseControls;
        String pw;
        String dn;
        int port;
        StringArgument controlStr;
        FileBasedArgument sslTrustStorePINFile;
        StringArgument sslTrustStorePIN;
        StringArgument sslTrustStore;
        FileBasedArgument sslKeyStorePINFile;
        StringArgument sslKeyStorePIN;
        StringArgument sslKeyStore;
        BooleanArgument sslBlindTrust;
        FileBasedArgument currentPWFile;
        StringArgument currentPW;
        FileBasedArgument newPWFile;
        StringArgument newPW;
        BooleanArgument provideDNForAuthzID;
        StringArgument authzID;
        FileBasedArgument bindPWFile;
        StringArgument bindPW;
        StringArgument bindDN;
        BooleanArgument useStartTLS;
        BooleanArgument useSSL;
        IntegerArgument ldapPort;
        StringArgument ldapHost;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String toolDescription = MessageHandler.getMessage(10486452);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            ldapHost = new StringArgument("ldaphost", Character.valueOf('h'), "hostname", false, false, true, "{host}", "127.0.0.1", null, 10486395, new Object[0]);
            argParser.addArgument(ldapHost);
            ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, true, 1, true, 65535, 10486396, new Object[0]);
            argParser.addArgument(ldapPort);
            useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", 10486406, new Object[0]);
            argParser.addArgument(useSSL);
            useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", 10486407, new Object[0]);
            argParser.addArgument(useStartTLS);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 10486397, new Object[0]);
            argParser.addArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10486398, new Object[0]);
            argParser.addArgument(bindPW);
            bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10486399, new Object[0]);
            argParser.addArgument(bindPWFile);
            authzID = new StringArgument("authzid", Character.valueOf('a'), "authzID", false, false, true, "{authzID}", null, null, 10486400, new Object[0]);
            argParser.addArgument(authzID);
            provideDNForAuthzID = new BooleanArgument("providednforauthzid", Character.valueOf('A'), "provideDNForAuthzID", 10486401, new Object[0]);
            argParser.addArgument(provideDNForAuthzID);
            newPW = new StringArgument("newpw", Character.valueOf('n'), "newPassword", false, false, true, "{newPassword}", null, null, 10486402, new Object[0]);
            argParser.addArgument(newPW);
            newPWFile = new FileBasedArgument("newpwfile", Character.valueOf('N'), "newPasswordFile", false, false, "{file}", null, null, 10486403, new Object[0]);
            argParser.addArgument(newPWFile);
            currentPW = new StringArgument("currentpw", Character.valueOf('c'), "currentPassword", false, false, true, "{currentPassword}", null, null, 10486404, new Object[0]);
            argParser.addArgument(currentPW);
            currentPWFile = new FileBasedArgument("currentpwfile", Character.valueOf('C'), "currentPasswordFile", false, false, "{file}", null, null, 10486405, new Object[0]);
            argParser.addArgument(currentPWFile);
            sslBlindTrust = new BooleanArgument("blindtrust", Character.valueOf('X'), "trustAll", 10486408, new Object[0]);
            argParser.addArgument(sslBlindTrust);
            sslKeyStore = new StringArgument("keystorepath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10486409, new Object[0]);
            argParser.addArgument(sslKeyStore);
            sslKeyStorePIN = new StringArgument("keystorepassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 10486543, new Object[0]);
            argParser.addArgument(sslKeyStorePIN);
            sslKeyStorePINFile = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486410, new Object[0]);
            argParser.addArgument(sslKeyStorePINFile);
            sslTrustStore = new StringArgument("truststorepath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10486411, new Object[0]);
            argParser.addArgument(sslTrustStore);
            sslTrustStorePIN = new StringArgument("truststorepassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486544, new Object[0]);
            argParser.addArgument(sslTrustStorePIN);
            sslTrustStorePINFile = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486412, new Object[0]);
            argParser.addArgument(sslTrustStorePINFile);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argParser.addArgument(controlStr);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message2 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message3 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPW.isPresent() && bindPWFile.isPresent()) {
            int msgID = 10748560;
            String message4 = MessageHandler.getMessage(msgID, bindPW.getLongIdentifier(), bindPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (newPW.isPresent() && newPWFile.isPresent()) {
            int msgID = 10748560;
            String message5 = MessageHandler.getMessage(msgID, newPW.getLongIdentifier(), newPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (currentPW.isPresent() && currentPWFile.isPresent()) {
            int msgID = 10748560;
            String message6 = MessageHandler.getMessage(msgID, currentPW.getLongIdentifier(), currentPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (useSSL.isPresent() && useStartTLS.isPresent()) {
            int msgID = 10748560;
            String message7 = MessageHandler.getMessage(msgID, useSSL.getLongIdentifier(), useStartTLS.getLongIdentifier());
            err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (sslKeyStorePIN.isPresent() && sslKeyStorePINFile.isPresent()) {
            int msgID = 10748606;
            String message8 = MessageHandler.getMessage(msgID, sslKeyStorePIN.getLongIdentifier(), sslKeyStorePINFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (sslTrustStorePIN.isPresent() && sslTrustStorePINFile.isPresent()) {
            int msgID = 10748606;
            String message9 = MessageHandler.getMessage(msgID, sslTrustStorePIN.getLongIdentifier(), sslTrustStorePINFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (bindDN.isPresent()) {
            if (!bindPW.isPresent() && !bindPWFile.isPresent()) {
                int msgID = 10748561;
                String message10 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        } else {
            if (bindPW.isPresent() || bindPWFile.isPresent()) {
                int msgID = 10748561;
                String message11 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            if (provideDNForAuthzID.isPresent()) {
                int msgID = 10748563;
                String message12 = MessageHandler.getMessage(msgID, provideDNForAuthzID.getLongIdentifier(), bindDN.getLongIdentifier());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            if (!authzID.isPresent() || !currentPW.isPresent() && !currentPWFile.isPresent()) {
                int msgID = 10748562;
                String message13 = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        }
        String host = ldapHost.getValue();
        try {
            port = ldapPort.getIntValue();
        }
        catch (Exception e) {
            err.println(e);
            return 1;
        }
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>();
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    int msgID = 10748609;
                    String message14 = MessageHandler.getMessage(msgID, ctrlString);
                    err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                controls.add(ctrl);
            }
        }
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
        }
        AtomicInteger nextMessageID = new AtomicInteger(1);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(useStartTLS.isPresent());
        connectionOptions.setVersionNumber(3);
        if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
            String keyPIN = null;
            if (sslKeyStorePIN.isPresent()) {
                keyPIN = sslKeyStorePIN.getValue();
            } else if (sslKeyStorePINFile.isPresent()) {
                keyPIN = sslKeyStorePINFile.getValue();
            }
            String trustPIN = null;
            if (sslTrustStorePIN.isPresent()) {
                trustPIN = sslTrustStorePIN.getValue();
            } else if (sslTrustStorePINFile.isPresent()) {
                trustPIN = sslTrustStorePINFile.getValue();
            }
            try {
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(sslBlindTrust.isPresent(), sslKeyStore.getValue(), keyPIN, null, sslTrustStore.getValue(), trustPIN);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (Exception e) {
                int msgID = 10748564;
                String message15 = MessageHandler.getMessage(msgID, String.valueOf(e));
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        LDAPConnection connection = new LDAPConnection(host, port, connectionOptions, out, err);
        if (bindPW.isPresent()) {
            dn = bindDN.getValue();
            pw = bindPW.getValue();
        } else if (bindPWFile.isPresent()) {
            dn = bindDN.getValue();
            pw = bindPWFile.getValue();
        } else {
            dn = null;
            pw = null;
        }
        try {
            connection.connectToHost(dn, pw, nextMessageID);
        }
        catch (LDAPConnectionException lce) {
            int msgID = 10748565;
            String message16 = MessageHandler.getMessage(msgID, lce.getMessage());
            err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
            return lce.getResultCode();
        }
        LDAPReader reader = connection.getLDAPReader();
        LDAPWriter writer = connection.getLDAPWriter();
        ArrayList<ASN1Element> requestElements = new ArrayList<ASN1Element>(3);
        if (authzID.isPresent()) {
            requestElements.add(new ASN1OctetString(-128, authzID.getValue()));
        } else if (provideDNForAuthzID.isPresent()) {
            requestElements.add(new ASN1OctetString(-128, "dn:" + dn));
        }
        if (currentPW.isPresent()) {
            requestElements.add(new ASN1OctetString(-127, currentPW.getValue()));
        } else if (currentPWFile.isPresent()) {
            requestElements.add(new ASN1OctetString(-127, currentPWFile.getValue()));
        } else if (provideDNForAuthzID.isPresent()) {
            requestElements.add(new ASN1OctetString(-127, pw));
        }
        if (newPW.isPresent()) {
            requestElements.add(new ASN1OctetString(-126, newPW.getValue()));
        } else if (newPWFile.isPresent()) {
            requestElements.add(new ASN1OctetString(-126, newPWFile.getValue()));
        }
        ASN1OctetString requestValue = new ASN1OctetString(new ASN1Sequence(requestElements).encode());
        ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.4203.1.11.1", requestValue);
        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest, controls);
        try {
            writer.writeMessage(requestMessage);
        }
        catch (Exception e) {
            int msgID = 10748566;
            String message17 = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return 1;
        }
        LDAPMessage responseMessage = null;
        try {
            responseMessage = reader.readMessage();
        }
        catch (Exception e) {
            int msgID = 10748567;
            String message18 = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return 1;
        }
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        int resultCode = extendedResponse.getResultCode();
        if (resultCode != 0) {
            DN matchedDN;
            int msgID = 10748568;
            String message19 = MessageHandler.getMessage(msgID, resultCode);
            err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
            String errorMessage = extendedResponse.getErrorMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                msgID = 10748569;
                message19 = MessageHandler.getMessage(msgID, errorMessage);
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
            }
            if ((matchedDN = extendedResponse.getMatchedDN()) != null) {
                msgID = 10748570;
                message19 = MessageHandler.getMessage(msgID, matchedDN.toString());
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
            }
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return resultCode;
        }
        int msgID = 10486427;
        String message20 = MessageHandler.getMessage(msgID);
        out.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
        String additionalInfo = extendedResponse.getErrorMessage();
        if (additionalInfo != null && additionalInfo.length() > 0) {
            msgID = 10486428;
            message20 = MessageHandler.getMessage(msgID, additionalInfo);
            out.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
        }
        if ((responseControls = responseMessage.getControls()) != null) {
            for (LDAPControl c : responseControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                try {
                    PasswordPolicyErrorType pwPolicyErrorType;
                    PasswordPolicyResponseControl pwPolicyControl = PasswordPolicyResponseControl.decodeControl(c.getControl());
                    PasswordPolicyWarningType pwPolicyWarningType = pwPolicyControl.getWarningType();
                    if (pwPolicyWarningType != null) {
                        int msgID2 = 10486546;
                        message = MessageHandler.getMessage(msgID2, pwPolicyWarningType.toString(), pwPolicyControl.getWarningValue());
                        out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    }
                    if ((pwPolicyErrorType = pwPolicyControl.getErrorType()) == null) continue;
                    int msgID3 = 10486547;
                    String message21 = MessageHandler.getMessage(msgID3, pwPolicyErrorType.toString());
                    out.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
                }
                catch (Exception e) {
                    int msgID4 = 10683156;
                    String message22 = MessageHandler.getMessage(msgID4, String.valueOf(e));
                    err.println(StaticUtils.wrapText(message22, ServerConstants.MAX_LINE_WIDTH));
                }
            }
        }
        if ((responseValue = extendedResponse.getValue()) != null) {
            try {
                ASN1Sequence responseSequence = ASN1Sequence.decodeAsSequence(responseValue.value());
                for (ASN1Element e : responseSequence.elements()) {
                    int msgID5;
                    if (e.getType() == -128) {
                        msgID5 = 10486429;
                        message = MessageHandler.getMessage(msgID5, e.decodeAsOctetString().stringValue());
                        out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    msgID5 = 10748574;
                    message = MessageHandler.getMessage(msgID5, StaticUtils.byteToHex(e.getType()));
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
            }
            catch (Exception e) {
                int msgID6 = 10748575;
                String message23 = MessageHandler.getMessage(msgID6, String.valueOf(e));
                err.println(StaticUtils.wrapText(message23, ServerConstants.MAX_LINE_WIDTH));
                try {
                    requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                    writer.writeMessage(requestMessage);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    reader.close();
                    writer.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return 1;
            }
        }
        try {
            requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
            writer.writeMessage(requestMessage);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }
}

