/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPDeleteOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPDelete {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPDelete";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPDelete(AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
    }

    public void readAndExecute(LDAPConnection connection, ArrayList<String> lines, LDAPDeleteOptions deleteOptions) throws IOException, LDAPException {
        for (String line : lines) {
            this.executeDelete(connection, line, deleteOptions);
        }
    }

    public void readAndExecute(LDAPConnection connection, Reader reader, LDAPDeleteOptions deleteOptions) throws IOException, LDAPException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        while ((line = in.readLine()) != null) {
            this.executeDelete(connection, line, deleteOptions);
        }
        in.close();
    }

    private void executeDelete(LDAPConnection connection, String line, LDAPDeleteOptions deleteOptions) throws IOException, LDAPException {
        ArrayList<LDAPControl> controls = deleteOptions.getControls();
        DeleteRequestProtocolOp protocolOp = null;
        ASN1OctetString asn1OctetStr = new ASN1OctetString(line);
        protocolOp = new DeleteRequestProtocolOp(asn1OctetStr);
        int msgID = 10485864;
        this.out.println(MessageHandler.getMessage(msgID, "DELETE", asn1OctetStr));
        if (!deleteOptions.showOperations()) {
            LDAPMessage message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp, controls);
            LDAPMessage responseMessage = null;
            try {
                connection.getLDAPWriter().writeMessage(message);
                responseMessage = connection.getLDAPReader().readMessage();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                if (!deleteOptions.continueOnError()) {
                    throw new IOException(ae.getMessage());
                }
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "DELETE");
                this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                this.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return;
            }
            DeleteResponseProtocolOp op = responseMessage.getDeleteResponseProtocolOp();
            int resultCode = op.getResultCode();
            String errorMessage = op.getErrorMessage();
            if (resultCode != 0 && resultCode != 10 && !deleteOptions.continueOnError()) {
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "DELETE");
                throw new LDAPException(resultCode, errorMessage, msgID, msg, op.getMatchedDN(), null);
            }
            if (resultCode != 0 && resultCode != 10) {
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "DELETE");
                LDAPToolUtils.printErrorMessage(this.err, msg, resultCode, errorMessage, op.getMatchedDN());
            } else {
                msgID = 0xA0006A;
                String msg = MessageHandler.getMessage(msgID, "DELETE", line);
                this.out.println(msg);
            }
        }
    }

    public static void main(String[] args) {
        int retCode = LDAPDelete.mainDelete(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainDelete(String[] args) {
        return LDAPDelete.mainDelete(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainDelete(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        int n;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPDeleteOptions deleteOptions = new LDAPDeleteOptions();
        LDAPConnection connection = null;
        BooleanArgument continueOnError = null;
        BooleanArgument deleteSubtree = null;
        BooleanArgument noop = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument startTLS = null;
        BooleanArgument trustAll = null;
        BooleanArgument useSSL = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument version = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument saslOptions = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        InputStreamReader rdr = null;
        ArrayList<String> dnStrings = new ArrayList<String>();
        String toolDescription = MessageHandler.getMessage(10486450);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 0, 1, "\"DN\"");
        try {
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", 10485886, new Object[0]);
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10485874, new Object[0]);
            argParser.addArgument(bindPasswordFile);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 0xA00080, new Object[0]);
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keyStorePasswordFile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("trustStorePasswordFile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argParser.addArgument(trustStorePasswordFile);
            deleteSubtree = new BooleanArgument("deleteSubtree", Character.valueOf('x'), "deleteSubtree", 10485889, new Object[0]);
            argParser.addArgument(deleteSubtree);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argParser.addArgument(controlStr);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argParser.addArgument(encodingStr);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("no-op", Character.valueOf('n'), "dry-run", 10486087, new Object[0]);
            argParser.addArgument(noop);
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                int msgID = 10682569;
                err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID, versionNumber), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
            try {
                out.print(MessageHandler.getMessage(10485959, bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        deleteOptions.setShowOperations(noop.isPresent());
        deleteOptions.setVerbose(verbose.isPresent());
        deleteOptions.setContinueOnError(continueOnError.isPresent());
        deleteOptions.setEncoding(encodingStr.getValue());
        deleteOptions.setDeleteSubtree(deleteSubtree.isPresent());
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    int msgID = 10748609;
                    String message = MessageHandler.getMessage(msgID, ctrlString);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                deleteOptions.getControls().add(ctrl);
            }
        }
        if (deleteOptions.getDeleteSubtree()) {
            LDAPControl control = new LDAPControl("1.2.840.113556.1.4.805");
            deleteOptions.getControls().add(control);
        }
        ArrayList<String> trailingArgs = argParser.getTrailingArguments();
        for (String s : trailingArgs) {
            dnStrings.add(s);
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean val;
                if (!(saslOption.startsWith("mech=") ? !(val = connectionOptions.setSASLMechanism(saslOption)) : !(val = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 1;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        if (connectionOptions.useSASLExternal()) {
            String message;
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                int msgID = 10748610;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (keyStorePathValue == null) {
                int msgID = 10748611;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        LDAPDelete ldapDelete = null;
        try {
            if (initializeServer) {
                DirectoryServer.bootstrapClient();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            ldapDelete = new LDAPDelete(nextMessageID, out, err);
            if (fileNameValue == null && dnStrings.isEmpty()) {
                rdr = new InputStreamReader(System.in);
            } else if (fileNameValue != null) {
                rdr = new FileReader(fileNameValue);
            }
            if (rdr != null) {
                ldapDelete.readAndExecute(connection, rdr, deleteOptions);
            } else {
                ldapDelete.readAndExecute(connection, dnStrings, deleteOptions);
            }
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessage(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN());
            n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessage(), lce.getResultCode(), lce.getErrorMessage(), lce.getMatchedDN());
            n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n2 = 1;
            return n2;
        }
        finally {
            if (connection != null) {
                if (ldapDelete == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapDelete.nextMessageID);
                }
            }
        }
        return 0;
    }
}

