/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ExportLDIF {
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = ExportLDIF.mainExportLDIF(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainExportLDIF(String[] args) {
        return ExportLDIF.mainExportLDIF(args, true, System.out, System.err);
    }

    public static int mainExportLDIF(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        String message;
        String lockFile;
        ArrayList<DN> includeBranches;
        String message2;
        int msgID;
        ArrayList<SearchFilter> includeFilters;
        ArrayList<SearchFilter> excludeFilters;
        HashSet<AttributeType> includeAttributes;
        HashSet<AttributeType> excludeAttributes;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument appendToLDIF = null;
        BooleanArgument compressLDIF = null;
        BooleanArgument displayUsage = null;
        BooleanArgument encryptLDIF = null;
        BooleanArgument excludeOperationalAttrs = null;
        BooleanArgument signHash = null;
        IntegerArgument wrapColumn = null;
        StringArgument backendID = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument excludeAttributeStrings = null;
        StringArgument excludeBranchStrings = null;
        StringArgument excludeFilterStrings = null;
        StringArgument includeAttributeStrings = null;
        StringArgument includeBranchStrings = null;
        StringArgument includeFilterStrings = null;
        StringArgument ldifFile = null;
        String toolDescription = MessageHandler.getMessage(10486446);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.ExportLDIF", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            ldifFile = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", true, false, true, "{ldifFile}", null, null, 10485793, new Object[0]);
            argParser.addArgument(ldifFile);
            appendToLDIF = new BooleanArgument("appendldif", Character.valueOf('a'), "appendToLDIF", 0xA00022, new Object[0]);
            argParser.addArgument(appendToLDIF);
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, "{backendID}", null, null, 10485795, new Object[0]);
            argParser.addArgument(backendID);
            includeBranchStrings = new StringArgument("includebranch", Character.valueOf('b'), "includeBranch", false, true, true, "{branchDN}", null, null, 0xA000F0, new Object[0]);
            argParser.addArgument(includeBranchStrings);
            excludeBranchStrings = new StringArgument("excludebranch", Character.valueOf('B'), "excludeBranch", false, true, true, "{branchDN}", null, null, 10485796, new Object[0]);
            argParser.addArgument(excludeBranchStrings);
            includeAttributeStrings = new StringArgument("includeattribute", Character.valueOf('i'), "includeAttribute", false, true, true, "{attribute}", null, null, 10485797, new Object[0]);
            argParser.addArgument(includeAttributeStrings);
            excludeAttributeStrings = new StringArgument("excludeattribute", Character.valueOf('e'), "excludeAttribute", false, true, true, "{attribute}", null, null, 10485798, new Object[0]);
            argParser.addArgument(excludeAttributeStrings);
            includeFilterStrings = new StringArgument("includefilter", Character.valueOf('I'), "includeFilter", false, true, true, "{filter}", null, null, 10485799, new Object[0]);
            argParser.addArgument(includeFilterStrings);
            excludeFilterStrings = new StringArgument("excludefilter", Character.valueOf('E'), "excludeFilter", false, true, true, "{filter}", null, null, 10485800, new Object[0]);
            argParser.addArgument(excludeFilterStrings);
            excludeOperationalAttrs = new BooleanArgument("excludeoperational", Character.valueOf('O'), "excludeOperational", 10486545, new Object[0]);
            argParser.addArgument(excludeOperationalAttrs);
            wrapColumn = new IntegerArgument("wrapcolumn", Character.valueOf('w'), "wrapColumn", false, false, true, "{wrapColumn}", 0, null, true, 0, false, 0, 10485801, new Object[0]);
            argParser.addArgument(wrapColumn);
            compressLDIF = new BooleanArgument("compressldif", Character.valueOf('c'), "compress", 0xA0002A, new Object[0]);
            argParser.addArgument(compressLDIF);
            encryptLDIF = new BooleanArgument("encryptldif", Character.valueOf('y'), "encryptLDIF", 10485803, new Object[0]);
            argParser.addArgument(encryptLDIF);
            signHash = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", 10485804, new Object[0]);
            argParser.addArgument(signHash);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            int msgID2 = 10747920;
            String message3 = MessageHandler.getMessage(msgID2, ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID3 = 10747921;
            String message4 = MessageHandler.getMessage(msgID3, ae.getMessage());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID4 = 10747924;
                String message5 = MessageHandler.getMessage(msgID4, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID5 = 10747925;
                String message6 = MessageHandler.getMessage(msgID5, ie.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID6 = 10747925;
                String message7 = MessageHandler.getMessage(msgID6, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID7 = 10747926;
                String message8 = MessageHandler.getMessage(msgID7, ce.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID8 = 10747926;
                String message9 = MessageHandler.getMessage(msgID8, ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID9 = 10747926;
                String message10 = MessageHandler.getMessage(msgID9, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                int msgID10 = 10747927;
                String message11 = MessageHandler.getMessage(msgID10, ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID11 = 10747927;
                String message12 = MessageHandler.getMessage(msgID11, ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID12 = 10747927;
                String message13 = MessageHandler.getMessage(msgID12, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                int msgID13 = 10748188;
                String message14 = MessageHandler.getMessage(msgID13, ce.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID14 = 10748188;
                String message15 = MessageHandler.getMessage(msgID14, ie.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID15 = 10748188;
                String message16 = MessageHandler.getMessage(msgID15, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
            try {
                HashSet<PluginType> pluginTypes = new HashSet<PluginType>(1);
                pluginTypes.add(PluginType.LDIF_EXPORT);
                directoryServer.initializePlugins(pluginTypes);
            }
            catch (ConfigException ce) {
                int msgID16 = 10748244;
                String message17 = MessageHandler.getMessage(msgID16, ce.getMessage());
                err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID17 = 10748244;
                String message18 = MessageHandler.getMessage(msgID17, ie.getMessage());
                err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID18 = 10748244;
                String message19 = MessageHandler.getMessage(msgID18, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (excludeAttributeStrings == null) {
            excludeAttributes = null;
        } else {
            excludeAttributes = new HashSet<AttributeType>();
            for (String attrName : excludeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                excludeAttributes.add(attrType);
            }
        }
        if (includeAttributeStrings == null) {
            includeAttributes = null;
        } else {
            includeAttributes = new HashSet<AttributeType>();
            for (String attrName : includeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
        }
        if (excludeFilterStrings == null) {
            excludeFilters = null;
        } else {
            excludeFilters = new ArrayList<SearchFilter>();
            for (String filterString : excludeFilterStrings.getValues()) {
                try {
                    excludeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    int msgID19 = 10747956;
                    String message20 = MessageHandler.getMessage(msgID19, filterString, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message20, msgID19);
                    return 1;
                }
                catch (Exception e) {
                    int msgID20 = 10747956;
                    String message21 = MessageHandler.getMessage(msgID20, filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message21, msgID20);
                    return 1;
                }
            }
        }
        if (includeFilterStrings == null) {
            includeFilters = null;
        } else {
            includeFilters = new ArrayList<SearchFilter>();
            for (String filterString : includeFilterStrings.getValues()) {
                try {
                    includeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    int msgID21 = 10747957;
                    String message22 = MessageHandler.getMessage(msgID21, filterString, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message22, msgID21);
                    return 1;
                }
                catch (Exception e) {
                    int msgID22 = 10747957;
                    String message23 = MessageHandler.getMessage(msgID22, filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID22);
                    return 1;
                }
            }
        }
        Backend backend = null;
        List<DN> baseDNList = null;
        ArrayList<DN> defaultIncludeBranches = null;
        ArrayList<DN> excludeBranches = null;
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            if (!backendID.getValue().equals(b.getBackendID())) continue;
            if (backend == null) {
                backend = b;
                baseDNList = dnList.get(i);
                defaultIncludeBranches = dnList.get(i);
                continue;
            }
            int msgID23 = 10747959;
            String message24 = MessageHandler.getMessage(msgID23, backendID.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message24, msgID23);
            return 1;
        }
        if (backend == null) {
            msgID = 10747960;
            message2 = MessageHandler.getMessage(msgID, backendID.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        if (!backend.supportsLDIFExport()) {
            msgID = 10748117;
            message2 = MessageHandler.getMessage(msgID, backendID.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        if (excludeBranchStrings.isPresent()) {
            excludeBranches = new ArrayList<DN>();
            for (String s : excludeBranchStrings.getValues()) {
                DN excludeBranch;
                try {
                    excludeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    int msgID24 = 10747961;
                    String message25 = MessageHandler.getMessage(msgID24, s, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message25, msgID24);
                    return 1;
                }
                catch (Exception e) {
                    int msgID25 = 10747961;
                    String message26 = MessageHandler.getMessage(msgID25, s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message26, msgID25);
                    return 1;
                }
                if (excludeBranches.contains(excludeBranch)) continue;
                excludeBranches.add(excludeBranch);
            }
        }
        if (includeBranchStrings.isPresent()) {
            includeBranches = new ArrayList<DN>();
            for (String s : includeBranchStrings.getValues()) {
                DN includeBranch;
                try {
                    includeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    int msgID26 = 10748122;
                    String message27 = MessageHandler.getMessage(msgID26, s, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message27, msgID26);
                    return 1;
                }
                catch (Exception e) {
                    int msgID27 = 10748122;
                    String message28 = MessageHandler.getMessage(msgID27, s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message28, msgID27);
                    return 1;
                }
                if (!Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) {
                    int msgID28 = 10748146;
                    String message29 = MessageHandler.getMessage(msgID28, s, backendID.getValue());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message29, msgID28);
                    return 1;
                }
                includeBranches.add(includeBranch);
            }
        } else {
            includeBranches = defaultIncludeBranches;
        }
        ExistingFileBehavior existingBehavior = appendToLDIF.isPresent() ? ExistingFileBehavior.APPEND : ExistingFileBehavior.OVERWRITE;
        LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFile.getValue(), existingBehavior);
        exportConfig.setCompressData(compressLDIF.isPresent());
        exportConfig.setEncryptData(encryptLDIF.isPresent());
        exportConfig.setExcludeAttributes(excludeAttributes);
        exportConfig.setExcludeBranches(excludeBranches);
        exportConfig.setExcludeFilters(excludeFilters);
        exportConfig.setIncludeAttributes(includeAttributes);
        exportConfig.setIncludeBranches(includeBranches);
        exportConfig.setIncludeFilters(includeFilters);
        exportConfig.setSignHash(signHash.isPresent());
        exportConfig.setIncludeOperationalAttributes(!excludeOperationalAttrs.isPresent());
        exportConfig.setInvokeExportPlugins(true);
        try {
            exportConfig.setWrapColumn(wrapColumn.getIntValue());
        }
        catch (ArgumentException ae) {
            int msgID29 = 10747962;
            String message30 = MessageHandler.getMessage(msgID29, wrapColumn.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message30, msgID29);
            return 1;
        }
        DN[] baseDNs = new DN[baseDNList.size()];
        baseDNList.toArray(baseDNs);
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                int msgID30 = 10748238;
                String message31 = MessageHandler.getMessage(msgID30, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message31, msgID30);
                return 0;
            }
        }
        catch (Exception e) {
            int msgID31 = 10748238;
            String message32 = MessageHandler.getMessage(msgID31, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message32, msgID31);
            return 0;
        }
        try {
            backend.exportLDIF(exportConfig);
        }
        catch (DirectoryException de) {
            int msgID32 = 10747963;
            message = MessageHandler.getMessage(msgID32, de.getErrorMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID32);
        }
        catch (Exception e) {
            int msgID33 = 10747963;
            message = MessageHandler.getMessage(msgID33, StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID33);
        }
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                int msgID34 = 10617167;
                String message33 = MessageHandler.getMessage(msgID34, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message33, msgID34);
            }
        }
        catch (Exception e) {
            int msgID35 = 10617167;
            message = MessageHandler.getMessage(msgID35, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID35);
        }
        exportConfig.close();
        return 0;
    }
}

