/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.HashSet;
import java.util.LinkedList;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.SaltedSHA512PasswordStorageScheme;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ConfigureDS {
    private static final String CLASS_NAME = "org.opends.server.tools.ConfigureDS";
    private static final String DN_JE_BACKEND = "ds-cfg-backend-id=userRoot,cn=Backends,cn=config";
    private static final String DN_LDAP_CONNECTION_HANDLER = "cn=LDAP Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_LDAPS_CONNECTION_HANDLER = "cn=LDAPS Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_JMX_CONNECTION_HANDLER = "cn=JMX Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_ROOT_USER = "cn=Directory Manager,cn=Root DNs,cn=config";

    public static void main(String[] args) {
        int exitCode = ConfigureDS.configMain(args);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int configMain(String[] args) {
        FileBasedArgument rootPasswordFile;
        StringArgument rootPassword;
        StringArgument rootDNString;
        StringArgument baseDNString;
        StringArgument certNickName;
        StringArgument keyManagerPath;
        StringArgument trustManagerProviderDN;
        StringArgument keyManagerProviderDN;
        IntegerArgument jmxPort;
        BooleanArgument enableStartTLS;
        IntegerArgument ldapsPort;
        IntegerArgument ldapPort;
        StringArgument configClass;
        StringArgument configFile;
        String toolDescription = MessageHandler.getMessage(10486444);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{ldapPort}", 389, null, true, 1, true, 65535, 10486224, new Object[0]);
            argParser.addArgument(ldapPort);
            ldapsPort = new IntegerArgument("ldapsPort", Character.valueOf('P'), "ldapsPort", false, false, true, "{ldapPort}", 636, null, true, 1, true, 65535, 10486618, new Object[0]);
            argParser.addArgument(ldapsPort);
            enableStartTLS = new BooleanArgument("enableStartTLS", Character.valueOf('q'), "enableStartTLS", 10486620, new Object[0]);
            argParser.addArgument(enableStartTLS);
            jmxPort = new IntegerArgument("jmxport", Character.valueOf('x'), "jmxPort", false, false, true, "{jmxPort}", SetupUtils.getDefaultJMXPort(), null, true, 1, true, 65535, 10486566, new Object[0]);
            argParser.addArgument(jmxPort);
            keyManagerProviderDN = new StringArgument("keymanagerproviderdn", Character.valueOf('k'), "keyManagerProviderDN", false, false, true, "{keyManagerProviderDN}", null, null, 10486621, new Object[0]);
            argParser.addArgument(keyManagerProviderDN);
            trustManagerProviderDN = new StringArgument("trustmanagerproviderdn", Character.valueOf('t'), "trustManagerProviderDN", false, false, true, "{trustManagerProviderDN}", null, null, 10486622, new Object[0]);
            argParser.addArgument(trustManagerProviderDN);
            keyManagerPath = new StringArgument("keymanagerpath", Character.valueOf('m'), "keyManagerPath", false, false, true, "{keyManagerPath}", null, null, 10486630, new Object[0]);
            argParser.addArgument(keyManagerPath);
            certNickName = new StringArgument("certnickname", Character.valueOf('a'), "certNickName", false, false, true, "{certNickName}", null, null, 10486631, new Object[0]);
            argParser.addArgument(certNickName);
            baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, 10486225, new Object[0]);
            argParser.addArgument(baseDNString);
            rootDNString = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, false, true, "{rootUserDN}", "cn=Directory Manager", null, 10486226, new Object[0]);
            argParser.addArgument(rootDNString);
            rootPassword = new StringArgument("rootpw", Character.valueOf('w'), "rootPassword", false, false, true, "{rootUserPW}", null, null, 10486227, new Object[0]);
            argParser.addArgument(rootPassword);
            rootPasswordFile = new FileBasedArgument("rootpwfile", Character.valueOf('j'), "rootPasswordFile", false, false, "{filename}", null, null, 10486228, new Object[0]);
            argParser.addArgument(rootPasswordFile);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (!(baseDNString.isPresent() || ldapPort.isPresent() || jmxPort.isPresent() || rootDNString.isPresent())) {
            int msgID = 10748387;
            String message = MessageHandler.getMessage(msgID);
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 1;
        }
        try {
            HashSet<Integer> ports = new HashSet<Integer>();
            if (ldapPort.isPresent()) {
                ports.add(ldapPort.getIntValue());
            }
            if (ldapsPort.isPresent()) {
                if (ports.contains(ldapsPort.getIntValue())) {
                    int msgID = 10749115;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(ldapsPort.getIntValue()));
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    System.err.println(argParser.getUsage());
                    return 1;
                }
                ports.add(ldapsPort.getIntValue());
            }
            if (jmxPort.isPresent()) {
                if (ports.contains(jmxPort.getIntValue())) {
                    int msgID = 10749115;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(jmxPort.getIntValue()));
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    System.err.println(argParser.getUsage());
                    return 1;
                }
                ports.add(jmxPort.getIntValue());
            }
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception e) {
            int msgID = 10748377;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
        }
        catch (Exception e) {
            int msgID = 10748378;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception e) {
            int msgID = 10748379;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String serverLockFileName = LockFileManager.getServerLockFileName();
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(serverLockFileName, failureReason)) {
            int msgID = 10748376;
            String message = MessageHandler.getMessage(msgID, String.valueOf(serverLockFileName), String.valueOf(failureReason));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            String message;
            DN ldapsListenerDN;
            BooleanConfigAttribute enableAttr2;
            BooleanConfigAttribute enablePortAttr;
            IntegerConfigAttribute portAttr2;
            DN ldapListenerDN;
            int msgID;
            ConfigEntry configEntry;
            DN dn;
            LinkedList<DN> baseDNs = null;
            if (baseDNString.isPresent()) {
                baseDNs = new LinkedList<DN>();
                for (String dnString : baseDNString.getValues()) {
                    try {
                        baseDNs.add(DN.decode(dnString));
                    }
                    catch (DirectoryException de) {
                        int msgID2 = 10748380;
                        String message2 = MessageHandler.getMessage(msgID2, String.valueOf(dnString), de.getErrorMessage());
                        System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                        int n = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return n;
                    }
                }
            }
            DN rootDN = null;
            String rootPW = null;
            if (rootDNString.isPresent()) {
                try {
                    rootDN = DN.decode(rootDNString.getValue());
                }
                catch (DirectoryException de) {
                    int msgID3 = 10748381;
                    String message3 = MessageHandler.getMessage(msgID3, String.valueOf(rootDNString.getValue()), de.getErrorMessage());
                    System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
                if (rootPassword.isPresent()) {
                    rootPW = rootPassword.getValue();
                } else if (rootPasswordFile.isPresent()) {
                    rootPW = rootPasswordFile.getValue();
                } else {
                    int msgID4 = 10748382;
                    String message4 = MessageHandler.getMessage(msgID4);
                    System.err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                    int message3 = 1;
                    return message3;
                }
            }
            ConfigHandler configHandler = directoryServer.getConfigHandler();
            if (keyManagerProviderDN.isPresent()) {
                dn = null;
                try {
                    dn = DN.decode(keyManagerProviderDN.getValue());
                }
                catch (DirectoryException de) {
                    int msgID5 = 10748767;
                    String message5 = MessageHandler.getMessage(msgID5, keyManagerProviderDN.getValue(), de.getErrorMessage());
                    System.err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
                try {
                    configHandler.getConfigEntry(dn);
                }
                catch (Exception e) {
                    int msgID6 = 3474025;
                    String message6 = MessageHandler.getMessage(msgID6, keyManagerProviderDN.getValue(), String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
            }
            if (trustManagerProviderDN.isPresent()) {
                dn = null;
                try {
                    dn = DN.decode(trustManagerProviderDN.getValue());
                }
                catch (DirectoryException de) {
                    int msgID7 = 10748768;
                    String message7 = MessageHandler.getMessage(msgID7, trustManagerProviderDN.getValue(), de.getErrorMessage());
                    System.err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
                try {
                    configHandler.getConfigEntry(dn);
                }
                catch (Exception e) {
                    int msgID8 = 3474038;
                    String message8 = MessageHandler.getMessage(msgID8, trustManagerProviderDN.getValue(), String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
            }
            if (keyManagerPath.isPresent() && !keyManagerProviderDN.isPresent()) {
                int msgID9 = 10748776;
                String message9 = MessageHandler.getMessage(msgID9, keyManagerProviderDN.getLongIdentifier(), keyManagerPath.getLongIdentifier());
                System.err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                int msgID8 = 1;
                return msgID8;
            }
            if (baseDNs != null) {
                try {
                    DN jeBackendDN = DN.decode(DN_JE_BACKEND);
                    configEntry = configHandler.getConfigEntry(jeBackendDN);
                    msgID = 0x300131;
                    DNConfigAttribute baseDNAttr = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(msgID), true, true, false, baseDNs);
                    configEntry.putConfigAttribute(baseDNAttr);
                }
                catch (Exception e) {
                    int msgID10 = 10748383;
                    String message10 = MessageHandler.getMessage(msgID10, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                    int baseDNAttr = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return baseDNAttr;
                }
            }
            if (ldapPort.isPresent()) {
                try {
                    ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                    configEntry = configHandler.getConfigEntry(ldapListenerDN);
                    msgID = 2097368;
                    portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(msgID), true, false, true, true, 1L, true, 65535L, ldapPort.getIntValue());
                    configEntry.putConfigAttribute(portAttr2);
                }
                catch (Exception e) {
                    int msgID11 = 10748384;
                    String message11 = MessageHandler.getMessage(msgID11, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                    int portAttr2 = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return portAttr2;
                }
            }
            if (ldapsPort.isPresent()) {
                try {
                    ldapListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                    configEntry = configHandler.getConfigEntry(ldapListenerDN);
                    msgID = 2097368;
                    portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(msgID), true, false, true, true, 1L, true, 65535L, ldapsPort.getIntValue());
                    configEntry.putConfigAttribute(portAttr2);
                    msgID = 2097556;
                    enablePortAttr = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(msgID), true, true, true);
                    configEntry.putConfigAttribute(enablePortAttr);
                }
                catch (Exception e) {
                    int msgID12 = 10748763;
                    String message12 = MessageHandler.getMessage(msgID12, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                    int portAttr3 = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return portAttr3;
                }
            }
            if (jmxPort.isPresent()) {
                try {
                    DN jmxListenerDN = DN.decode(DN_JMX_CONNECTION_HANDLER);
                    configEntry = configHandler.getConfigEntry(jmxListenerDN);
                    msgID = 2097499;
                    portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(msgID), true, false, true, true, 1L, true, 65535L, jmxPort.getIntValue());
                    configEntry.putConfigAttribute(portAttr2);
                    msgID = 2097580;
                    enablePortAttr = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(msgID), true, true, true);
                    configEntry.putConfigAttribute(enablePortAttr);
                }
                catch (Exception e) {
                    int msgID13 = 10748711;
                    String message13 = MessageHandler.getMessage(msgID13, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                    int portAttr4 = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return portAttr4;
                }
            }
            if (enableStartTLS.isPresent()) {
                try {
                    ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                    configEntry = configHandler.getConfigEntry(ldapListenerDN);
                    msgID = 2097379;
                    BooleanConfigAttribute startTLS = new BooleanConfigAttribute("ds-cfg-allow-start-tls", MessageHandler.getMessage(msgID), true, true, true);
                    configEntry.putConfigAttribute(startTLS);
                }
                catch (Exception e) {
                    int msgID14 = 10748769;
                    String message14 = MessageHandler.getMessage(msgID14, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                    int startTLS = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return startTLS;
                }
            }
            if (keyManagerProviderDN.isPresent()) {
                if (enableStartTLS.isPresent() || ldapsPort.isPresent()) {
                    try {
                        dn = DN.decode(keyManagerProviderDN.getValue());
                        configEntry = configHandler.getConfigEntry(dn);
                        msgID = 3146041;
                        enableAttr2 = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(msgID), true, true, true);
                        configEntry.putConfigAttribute(enableAttr2);
                    }
                    catch (Exception e) {
                        int msgID15 = 10748770;
                        String message15 = MessageHandler.getMessage(msgID15, String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                        int enableAttr2 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return enableAttr2;
                    }
                }
                try {
                    StringConfigAttribute keyManagerProviderAttr;
                    if (enableStartTLS.isPresent()) {
                        ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapListenerDN);
                        msgID = 2097542;
                        keyManagerProviderAttr = new StringConfigAttribute("ds-cfg-key-manager-provider-dn", MessageHandler.getMessage(msgID), false, false, true, keyManagerProviderDN.getValue());
                        configEntry.putConfigAttribute(keyManagerProviderAttr);
                    }
                    if (ldapsPort.isPresent()) {
                        ldapsListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapsListenerDN);
                        msgID = 2097542;
                        keyManagerProviderAttr = new StringConfigAttribute("ds-cfg-key-manager-provider-dn", MessageHandler.getMessage(msgID), false, false, true, keyManagerProviderDN.getValue());
                        configEntry.putConfigAttribute(keyManagerProviderAttr);
                    }
                }
                catch (Exception e) {
                    int msgID16 = 10748772;
                    String message16 = MessageHandler.getMessage(msgID16, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                    int keyManagerProviderAttr = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return keyManagerProviderAttr;
                }
                if (keyManagerPath.isPresent()) {
                    try {
                        dn = DN.decode(keyManagerProviderDN.getValue());
                        configEntry = configHandler.getConfigEntry(dn);
                        msgID = 1048619;
                        StringConfigAttribute pathAttr = new StringConfigAttribute("ds-cfg-key-store-file", MessageHandler.getMessage(msgID), true, true, true, keyManagerPath.getValue());
                        configEntry.putConfigAttribute(pathAttr);
                    }
                    catch (Exception e) {
                        message = String.valueOf(e);
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        msgID = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return msgID;
                    }
                }
            }
            if (trustManagerProviderDN.isPresent()) {
                if (enableStartTLS.isPresent() || ldapsPort.isPresent()) {
                    try {
                        dn = DN.decode(trustManagerProviderDN.getValue());
                        configEntry = configHandler.getConfigEntry(dn);
                        msgID = 3408200;
                        enableAttr2 = new BooleanConfigAttribute("ds-cfg-trust-manager-provider-enabled", MessageHandler.getMessage(msgID), true, true, true);
                        configEntry.putConfigAttribute(enableAttr2);
                    }
                    catch (Exception e) {
                        int msgID17 = 10748771;
                        String message17 = MessageHandler.getMessage(msgID17, String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                        int enableAttr3 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return enableAttr3;
                    }
                }
                try {
                    StringConfigAttribute trustManagerProviderAttr;
                    if (enableStartTLS.isPresent()) {
                        ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapListenerDN);
                        msgID = 2097545;
                        trustManagerProviderAttr = new StringConfigAttribute("ds-cfg-trust-manager-provider-dn", MessageHandler.getMessage(msgID), false, false, true, trustManagerProviderDN.getValue());
                        configEntry.putConfigAttribute(trustManagerProviderAttr);
                    }
                    if (ldapsPort.isPresent()) {
                        ldapsListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapsListenerDN);
                        msgID = 2097545;
                        trustManagerProviderAttr = new StringConfigAttribute("ds-cfg-trust-manager-provider-dn", MessageHandler.getMessage(msgID), false, false, true, trustManagerProviderDN.getValue());
                        configEntry.putConfigAttribute(trustManagerProviderAttr);
                    }
                }
                catch (Exception e) {
                    int msgID18 = 10748773;
                    String message18 = MessageHandler.getMessage(msgID18, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                    int trustManagerProviderAttr = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return trustManagerProviderAttr;
                }
            }
            if (certNickName.isPresent()) {
                try {
                    ConfigEntry configEntry2;
                    int msgID19 = 2097381;
                    StringConfigAttribute certNickNameAttr = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(msgID19), false, false, true, certNickName.getValue());
                    if (ldapPort.isPresent()) {
                        DN ldapListenerDN2 = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                        configEntry2 = configHandler.getConfigEntry(ldapListenerDN2);
                        configEntry2.putConfigAttribute(certNickNameAttr);
                    }
                    if (ldapsPort.isPresent()) {
                        DN ldapsListenerDN2 = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                        configEntry2 = configHandler.getConfigEntry(ldapsListenerDN2);
                        configEntry2.putConfigAttribute(certNickNameAttr);
                    }
                    if (jmxPort.isPresent()) {
                        msgID19 = 2097504;
                        certNickNameAttr = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(msgID19), false, false, true, certNickName.getValue());
                        DN jmxListenerDN = DN.decode(DN_JMX_CONNECTION_HANDLER);
                        configEntry2 = configHandler.getConfigEntry(jmxListenerDN);
                        configEntry2.putConfigAttribute(certNickNameAttr);
                    }
                }
                catch (Exception e) {
                    int msgID20 = 10748777;
                    String message19 = MessageHandler.getMessage(msgID20, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                    int configEntry3 = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return configEntry3;
                }
            }
            if (rootDN != null) {
                try {
                    DN rootUserDN = DN.decode(DN_ROOT_USER);
                    configEntry = configHandler.getConfigEntry(rootUserDN);
                    int msgID21 = 3146268;
                    DNConfigAttribute bindDNAttr = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(msgID21), false, true, false, rootDN);
                    configEntry.putConfigAttribute(bindDNAttr);
                    byte[] rootPWBytes = StaticUtils.getBytes(rootPW);
                    String encodedPassword = SaltedSHA512PasswordStorageScheme.encodeOffline(rootPWBytes);
                    StringConfigAttribute bindPWAttr = new StringConfigAttribute("userpassword", "", false, false, false, encodedPassword);
                    configEntry.putConfigAttribute(bindPWAttr);
                }
                catch (Exception e) {
                    int msgID22 = 10748385;
                    String message20 = MessageHandler.getMessage(msgID22, String.valueOf(e));
                    System.err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    LockFileManager.releaseLock(serverLockFileName, failureReason);
                    return n;
                }
            }
            try {
                configHandler.writeUpdatedConfig();
                int msgID23 = 10486244;
                message = MessageHandler.getMessage(msgID23);
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            catch (DirectoryException de) {
                int msgID24 = 10748386;
                String message21 = MessageHandler.getMessage(msgID24, de.getErrorMessage());
                System.err.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
                int n = 1;
                LockFileManager.releaseLock(serverLockFileName, failureReason);
                return n;
            }
        }
        finally {
            LockFileManager.releaseLock(serverLockFileName, failureReason);
        }
        return 0;
    }
}

