/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendToolUtils {
    public static int getBackends(ArrayList<Backend> backendList, ArrayList<BackendCfg> entryList, ArrayList<List<DN>> dnList) {
        ConfigEntry baseEntry;
        DN backendBaseDN;
        try {
            backendBaseDN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException de) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", de.getErrorMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return 1;
        }
        catch (Exception e) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return 1;
        }
        try {
            baseEntry = DirectoryServer.getConfigEntry(backendBaseDN);
        }
        catch (ConfigException ce) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", ce.getMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return 1;
        }
        catch (Exception e) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return 1;
        }
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        for (ConfigEntry configEntry : baseEntry.getChildren().values()) {
            int msgID;
            BackendCfg cfg;
            Backend backend;
            Class<?> backendClass;
            String message;
            String backendClassName;
            String message2;
            String backendID;
            try {
                int msgID2 = 3146110;
                StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(msgID2), true, false, true);
                StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
                if (idAttr == null) continue;
                backendID = idAttr.activeValue();
            }
            catch (ConfigException ce) {
                int msgID3 = 10748121;
                message2 = MessageHandler.getMessage(msgID3, String.valueOf(configEntry.getDN()), ce.getMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID3);
                return 1;
            }
            catch (Exception e) {
                int msgID4 = 10748121;
                message2 = MessageHandler.getMessage(msgID4, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID4);
                return 1;
            }
            try {
                int msgID5 = 3145837;
                StringConfigAttribute classStub = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(msgID5), true, false, false);
                StringConfigAttribute classAttr = (StringConfigAttribute)configEntry.getConfigAttribute(classStub);
                if (classAttr == null) continue;
                backendClassName = classAttr.activeValue();
            }
            catch (ConfigException ce) {
                int msgID6 = 10747966;
                message = MessageHandler.getMessage(msgID6, String.valueOf(configEntry.getDN()), ce.getMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID6);
                return 1;
            }
            catch (Exception e) {
                int msgID7 = 10747966;
                message = MessageHandler.getMessage(msgID7, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID7);
                return 1;
            }
            try {
                backendClass = Class.forName(backendClassName);
            }
            catch (Exception e) {
                int msgID8 = 10747967;
                String message3 = MessageHandler.getMessage(msgID8, backendClassName, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message3, msgID8);
                return 1;
            }
            try {
                backend = (Backend)backendClass.newInstance();
                backend.setBackendID(backendID);
                cfg = root.getBackend(backendID);
                backend.configureBackend(cfg);
            }
            catch (Exception e) {
                msgID = 0xA40040;
                String message4 = MessageHandler.getMessage(msgID, backendClassName, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message4, msgID);
                return 1;
            }
            List<DN> baseDNs = null;
            try {
                msgID = 0x300131;
                DNConfigAttribute baseDNStub = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(msgID), true, true, true);
                DNConfigAttribute baseDNAttr = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
                if (baseDNAttr == null) {
                    msgID = 10747969;
                    String message5 = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message5, msgID);
                } else {
                    baseDNs = baseDNAttr.activeValues();
                }
            }
            catch (Exception e) {
                int msgID9 = 10747970;
                String message6 = MessageHandler.getMessage(msgID9, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message6, msgID9);
                return 1;
            }
            backendList.add(backend);
            entryList.add(cfg);
            dnList.add(baseDNs);
        }
        return 0;
    }
}

