/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class BackUpDB {
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = BackUpDB.mainBackUpDB(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainBackUpDB(String[] args) {
        return BackUpDB.mainBackUpDB(args, true, System.out, System.err);
    }

    public static int mainBackUpDB(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        String message;
        boolean multiple;
        String incrementalBase;
        String backupID;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument backUpAll = null;
        BooleanArgument compress = null;
        BooleanArgument displayUsage = null;
        BooleanArgument encrypt = null;
        BooleanArgument hash = null;
        BooleanArgument incremental = null;
        BooleanArgument signHash = null;
        StringArgument backendID = null;
        StringArgument backupIDString = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument backupDirectory = null;
        StringArgument incrementalBaseID = null;
        String toolDescription = MessageHandler.getMessage(10486443);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.BackUpDB", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, "{backendID}", null, null, 10486005, new Object[0]);
            argParser.addArgument(backendID);
            backUpAll = new BooleanArgument("backupall", Character.valueOf('a'), "backUpAll", 10486034, new Object[0]);
            argParser.addArgument(backUpAll);
            backupIDString = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, "{backupID}", null, null, 10486006, new Object[0]);
            argParser.addArgument(backupIDString);
            backupDirectory = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, "{backupDir}", null, null, 10486007, new Object[0]);
            argParser.addArgument(backupDirectory);
            incremental = new BooleanArgument("incremental", Character.valueOf('i'), "incremental", 10486008, new Object[0]);
            argParser.addArgument(incremental);
            incrementalBaseID = new StringArgument("incrementalbaseid", Character.valueOf('B'), "incrementalBaseID", false, false, true, "{backupID}", null, null, 10486047, new Object[0]);
            argParser.addArgument(incrementalBaseID);
            compress = new BooleanArgument("compress", Character.valueOf('c'), "compress", 10486009, new Object[0]);
            argParser.addArgument(compress);
            encrypt = new BooleanArgument("encrypt", Character.valueOf('y'), "encrypt", 0xA000FA, new Object[0]);
            argParser.addArgument(encrypt);
            hash = new BooleanArgument("hash", Character.valueOf('h'), "hash", 10486011, new Object[0]);
            argParser.addArgument(hash);
            signHash = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", 10486012, new Object[0]);
            argParser.addArgument(signHash);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message2 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message3 = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (backUpAll.isPresent()) {
            if (backendID.isPresent()) {
                int msgID = 10748179;
                String message4 = MessageHandler.getMessage(msgID, backUpAll.getLongIdentifier(), backendID.getLongIdentifier());
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (!backendID.isPresent()) {
            int msgID = 10748180;
            String message5 = MessageHandler.getMessage(msgID, backUpAll.getLongIdentifier(), backendID.getLongIdentifier());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (backupIDString.isPresent()) {
            backupID = backupIDString.getValue();
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            backupID = dateFormat.format(new Date());
        }
        if (incrementalBaseID.isPresent()) {
            if (!incremental.isPresent()) {
                int msgID = 10748192;
                String message6 = MessageHandler.getMessage(msgID, incrementalBaseID.getLongIdentifier(), incremental.getLongIdentifier());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            incrementalBase = incrementalBaseID.getValue();
        } else {
            incrementalBase = null;
        }
        if (signHash.isPresent() && !hash.isPresent()) {
            int msgID = 10748230;
            String message7 = MessageHandler.getMessage(msgID, signHash.getLongIdentifier(), hash.getLongIdentifier());
            err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        File backupDirFile = new File(backupDirectory.getValue());
        if (!backupDirFile.exists()) {
            try {
                backupDirFile.mkdirs();
            }
            catch (Exception e) {
                int msgID = 10748181;
                String message8 = MessageHandler.getMessage(msgID, backupDirectory.getValue(), StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID = 10747924;
                String message9 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID = 10747925;
                String message10 = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747925;
                String message11 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID = 10747926;
                String message12 = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747926;
                String message13 = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747926;
                String message14 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                int msgID = 10747927;
                String message15 = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747927;
                String message16 = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747927;
                String message17 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                int msgID = 10748188;
                String message18 = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10748188;
                String message19 = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10748188;
                String message20 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        ArrayList<Backend> backendsToArchive = new ArrayList<Backend>(numBackends);
        HashMap<String, BackendCfg> configEntries = new HashMap<String, BackendCfg>(numBackends);
        if (backUpAll.isPresent()) {
            for (int i = 0; i < numBackends; ++i) {
                Backend b = backendList.get(i);
                if (!b.supportsBackup()) continue;
                backendsToArchive.add(b);
                configEntries.put(b.getBackendID(), entryList.get(i));
            }
            multiple = true;
        } else {
            String message21;
            int msgID;
            HashSet<String> requestedBackends = new HashSet<String>(backendList.size());
            requestedBackends.addAll(backendID.getValues());
            for (int i = 0; i < numBackends; ++i) {
                Backend b = backendList.get(i);
                if (!requestedBackends.contains(b.getBackendID())) continue;
                if (!b.supportsBackup()) {
                    msgID = 10617110;
                    message21 = MessageHandler.getMessage(msgID, b.getBackendID());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message21, msgID);
                    continue;
                }
                backendsToArchive.add(b);
                configEntries.put(b.getBackendID(), entryList.get(i));
                requestedBackends.remove(b.getBackendID());
            }
            if (!requestedBackends.isEmpty()) {
                for (String id : requestedBackends) {
                    msgID = 10748165;
                    message21 = MessageHandler.getMessage(msgID, id);
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message21, msgID);
                }
                return 1;
            }
            boolean bl = multiple = backendsToArchive.size() > 1;
        }
        if (backendsToArchive.isEmpty()) {
            int msgID = 10617111;
            String message22 = MessageHandler.getMessage(msgID);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message22, msgID);
            return 1;
        }
        boolean errorsEncountered = false;
        for (Backend b : backendsToArchive) {
            StringBuilder failureReason;
            String lockFile;
            StringBuilder failureReason2;
            String lockFile2;
            BackupDirectory backupDir;
            String message23;
            int msgID;
            block79: {
                block78: {
                    try {
                        String lockFile3 = LockFileManager.getBackendLockFileName(b);
                        StringBuilder failureReason3 = new StringBuilder();
                        if (!LockFileManager.acquireSharedLock(lockFile3, failureReason3)) {
                            int msgID2 = 10748232;
                            String message24 = MessageHandler.getMessage(msgID2, b.getBackendID(), String.valueOf(failureReason3));
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message24, msgID2);
                            errorsEncountered = true;
                        }
                        break block78;
                    }
                    catch (Exception e) {
                        int msgID3 = 10748232;
                        String message25 = MessageHandler.getMessage(msgID3, b.getBackendID(), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message25, msgID3);
                        errorsEncountered = true;
                    }
                    continue;
                }
                msgID = 10944792;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message23, msgID);
                BackendCfg configEntry = (BackendCfg)configEntries.get(b.getBackendID());
                String backupDirPath = multiple ? backupDirectory.getValue() + File.separator + b.getBackendID() : backupDirectory.getValue();
                backupDirFile = new File(backupDirPath);
                if (backupDirFile.exists()) {
                    String descriptorPath = backupDirPath + File.separator + "backup.info";
                    File descriptorFile = new File(descriptorPath);
                    if (descriptorFile.exists()) {
                        try {
                            backupDir = BackupDirectory.readBackupDirectoryDescriptor(backupDirPath);
                            break block79;
                        }
                        catch (ConfigException ce) {
                            msgID = 10748185;
                            message23 = MessageHandler.getMessage(msgID, descriptorPath, ce.getMessage());
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                            errorsEncountered = true;
                            try {
                                lockFile2 = LockFileManager.getBackendLockFileName(b);
                                if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                                msgID = 10617161;
                                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason2));
                                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                            }
                            catch (Exception e) {
                                msgID = 10617161;
                                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
                                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            msgID = 10748185;
                            message23 = MessageHandler.getMessage(msgID, descriptorPath, StaticUtils.getExceptionMessage(e));
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                            errorsEncountered = true;
                            try {
                                lockFile2 = LockFileManager.getBackendLockFileName(b);
                                if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                                msgID = 10617161;
                                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason2));
                                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                            }
                            catch (Exception e2) {
                                msgID = 10617161;
                                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                            }
                            continue;
                        }
                    }
                    backupDir = new BackupDirectory(backupDirPath, configEntry.dn());
                } else {
                    try {
                        backupDirFile.mkdirs();
                    }
                    catch (Exception e) {
                        msgID = 10748181;
                        message23 = MessageHandler.getMessage(msgID, backupDirPath, StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                        errorsEncountered = true;
                        try {
                            StringBuilder failureReason4;
                            String lockFile4 = LockFileManager.getBackendLockFileName(b);
                            if (LockFileManager.releaseLock(lockFile4, failureReason4 = new StringBuilder())) continue;
                            msgID = 10617161;
                            message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason4));
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                        }
                        catch (Exception e2) {
                            msgID = 10617161;
                            message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                        }
                        continue;
                    }
                    backupDir = new BackupDirectory(backupDirPath, configEntry.dn());
                }
            }
            BackupConfig backupConfig = new BackupConfig(backupDir, backupID, incremental.isPresent());
            backupConfig.setCompressData(compress.isPresent());
            backupConfig.setEncryptData(encrypt.isPresent());
            backupConfig.setHashData(hash.isPresent());
            backupConfig.setSignHash(signHash.isPresent());
            backupConfig.setIncrementalBaseID(incrementalBase);
            StringBuilder unsupportedReason = new StringBuilder();
            if (!b.supportsBackup(backupConfig, unsupportedReason)) {
                msgID = 10748168;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), unsupportedReason.toString());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                errorsEncountered = true;
                try {
                    lockFile = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) continue;
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                catch (Exception e2) {
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                continue;
            }
            try {
                b.createBackup(backupConfig);
            }
            catch (DirectoryException de) {
                msgID = 10748169;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), de.getErrorMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                errorsEncountered = true;
                try {
                    lockFile2 = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason2));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                catch (Exception e) {
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                continue;
            }
            catch (Exception e) {
                msgID = 10748169;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message23, msgID);
                errorsEncountered = true;
                try {
                    lockFile2 = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason2));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                catch (Exception e2) {
                    msgID = 10617161;
                    message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                }
                continue;
            }
            try {
                lockFile = LockFileManager.getBackendLockFileName(b);
                if (LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) continue;
                msgID = 10617161;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                errorsEncountered = true;
            }
            catch (Exception e) {
                msgID = 10617161;
                message23 = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message23, msgID);
                errorsEncountered = true;
            }
        }
        if (errorsEncountered) {
            int msgID = 10944794;
            message = MessageHandler.getMessage(msgID);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        } else {
            int msgID = 10944795;
            message = MessageHandler.getMessage(msgID);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        }
        return 0;
    }
}

