/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;

public class InitializeTargetTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    boolean append = false;
    boolean isCompressed = false;
    boolean isEncrypted = false;
    boolean skipSchemaValidation = false;
    String domainString = null;
    ReplicationDomain domain = null;
    short target;
    long total;
    long left;

    public void initializeTask() throws DirectoryException {
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-initialize-domain-dn", true);
        AttributeType typeScope = DirectoryServer.getAttributeType("ds-task-initialize-replica-server-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        DN domainDN = DN.nullDN();
        try {
            domainDN = DN.decode(this.domainString);
        }
        catch (Exception e) {
            int msgID = 11796500;
            String message = MessageHandler.getMessage(msgID) + e.getMessage();
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        this.domain = ReplicationDomain.retrievesReplicationDomain(domainDN);
        attrList = taskEntry.getAttribute(typeScope);
        String targetString = TaskUtils.getSingleValueString(attrList);
        this.target = this.domain.decodeTarget(targetString);
        this.createCounterAttribute("ds-task-unprocessed-entry-count", 0L);
        this.createCounterAttribute("ds-task-processed-entry-count", 0L);
    }

    protected TaskState runTask() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("DebugInfoInitializeTarget Task/runTask ");
        }
        try {
            this.domain.initializeTarget(this.target, this);
        }
        catch (DirectoryException de) {
            this.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, "Initialize Task stopped by error" + de.getErrorMessage(), 1);
            return TaskState.STOPPED_BY_ERROR;
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCounterAttribute(String name, long value) {
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        Entry taskEntry = this.getTaskEntry();
        AttributeType type = DirectoryServer.getAttributeType(name, true);
        values.add(new AttributeValue(type, (ByteString)new ASN1OctetString(String.valueOf(value))));
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute(type, name, values));
        taskEntry.putAttribute(type, attrList);
    }

    public void setTotal(long total) {
        this.total = total;
        try {
            this.updateAttribute("ds-task-unprocessed-entry-count", total);
            this.updateAttribute("ds-task-processed-entry-count", 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLeft(long left) {
        this.left = left;
        try {
            this.updateAttribute("ds-task-unprocessed-entry-count", left);
            this.updateAttribute("ds-task-processed-entry-count", this.total - left);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateAttribute(String name, long value) throws DirectoryException {
        Entry taskEntry = this.getTaskEntry();
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        modifications.add(new Modification(ModificationType.REPLACE, new Attribute(name, String.valueOf(value))));
        taskEntry.applyModifications(modifications);
    }
}

