/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class DisconnectClientTask
extends Task {
    private boolean notifyClient;
    private long connectionID;
    private String disconnectMessage;

    public void initializeTask() throws DirectoryException {
        AttributeValue v;
        Iterator i$;
        ClientConnection conn;
        Operation operation = this.getOperation();
        if (operation != null && !(conn = operation.getClientConnection()).hasPrivilege(Privilege.DISCONNECT_CLIENT, operation)) {
            int msgID = 11796505;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        Entry taskEntry = this.getTaskEntry();
        this.connectionID = -1L;
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-disconnect-connection-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                try {
                    this.connectionID = Long.parseLong(v.getStringValue());
                    break;
                }
                catch (Exception e) {
                    int msgID = 11796506;
                    String message = MessageHandler.getMessage(msgID, v.getStringValue());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID, e);
                }
            }
        }
        if (this.connectionID < 0L) {
            int msgID = 11796507;
            String message = MessageHandler.getMessage(msgID, "ds-task-disconnect-connection-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        this.notifyClient = false;
        attrType = DirectoryServer.getAttributeType("ds-task-disconnect-notify-client", true);
        attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                String stringValue = StaticUtils.toLowerCase(v.getStringValue());
                if (stringValue.equals("true")) {
                    this.notifyClient = true;
                    break;
                }
                if (stringValue.equals("false")) break;
                int msgID = 11796508;
                String message = MessageHandler.getMessage(msgID, stringValue);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        }
        this.disconnectMessage = MessageHandler.getMessage(11534365);
        attrType = DirectoryServer.getAttributeType("ds-task-disconnect-message", true);
        attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                this.disconnectMessage = v.getStringValue();
                break;
            }
        }
    }

    protected TaskState runTask() {
        ClientConnection clientConnection = null;
        Iterator<ConnectionHandler> i$ = DirectoryServer.getConnectionHandlers().iterator();
        block0: while (i$.hasNext()) {
            ConnectionHandler handler;
            ConnectionHandler connHandler = handler = i$.next();
            for (ClientConnection c : connHandler.getClientConnections()) {
                if (c.getConnectionID() != this.connectionID) continue;
                clientConnection = c;
                continue block0;
            }
        }
        if (clientConnection == null) {
            int msgID = 11796510;
            String message = MessageHandler.getMessage(msgID, this.connectionID);
            this.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        clientConnection.disconnect(DisconnectReason.ADMIN_DISCONNECT, this.notifyClient, this.disconnectMessage, 11534367);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

