/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class UserPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "ds-mr-user-password-exact";
    }

    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.2";
    }

    public String getDescription() {
        return "user password exact matching rule";
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        byte[] valueBytes = value.value();
        byte[] newValueBytes = new byte[valueBytes.length];
        System.arraycopy(valueBytes, 0, newValueBytes, 0, valueBytes.length);
        if (!UserPasswordSyntax.isEncoded(value)) return new ASN1OctetString(newValueBytes);
        int i = 1;
        while (i < newValueBytes.length) {
            switch (newValueBytes[i]) {
                case 65: {
                    newValueBytes[i] = 97;
                    break;
                }
                case 66: {
                    newValueBytes[i] = 98;
                    break;
                }
                case 67: {
                    newValueBytes[i] = 99;
                    break;
                }
                case 68: {
                    newValueBytes[i] = 100;
                    break;
                }
                case 69: {
                    newValueBytes[i] = 101;
                    break;
                }
                case 70: {
                    newValueBytes[i] = 102;
                    break;
                }
                case 71: {
                    newValueBytes[i] = 103;
                    break;
                }
                case 72: {
                    newValueBytes[i] = 104;
                    break;
                }
                case 73: {
                    newValueBytes[i] = 105;
                    break;
                }
                case 74: {
                    newValueBytes[i] = 106;
                    break;
                }
                case 75: {
                    newValueBytes[i] = 107;
                    break;
                }
                case 76: {
                    newValueBytes[i] = 108;
                    break;
                }
                case 77: {
                    newValueBytes[i] = 109;
                    break;
                }
                case 78: {
                    newValueBytes[i] = 110;
                    break;
                }
                case 79: {
                    newValueBytes[i] = 111;
                    break;
                }
                case 80: {
                    newValueBytes[i] = 112;
                    break;
                }
                case 81: {
                    newValueBytes[i] = 113;
                    break;
                }
                case 82: {
                    newValueBytes[i] = 114;
                    break;
                }
                case 83: {
                    newValueBytes[i] = 115;
                    break;
                }
                case 84: {
                    newValueBytes[i] = 116;
                    break;
                }
                case 85: {
                    newValueBytes[i] = 117;
                    break;
                }
                case 86: {
                    newValueBytes[i] = 118;
                    break;
                }
                case 87: {
                    newValueBytes[i] = 119;
                    break;
                }
                case 88: {
                    newValueBytes[i] = 120;
                    break;
                }
                case 89: {
                    newValueBytes[i] = 121;
                    break;
                }
                case 90: {
                    newValueBytes[i] = 122;
                    break;
                }
                case 125: {
                    return new ASN1OctetString(newValueBytes);
                }
            }
            ++i;
        }
        return new ASN1OctetString(newValueBytes);
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

