/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelexNumberSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "TelexNumber");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "TelexNumber");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "TelexNumber");
        }
    }

    @Override
    public String getSyntaxName() {
        return "TelexNumber";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.52";
    }

    @Override
    public String getDescription() {
        return "Telex Number";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        int msgID;
        int pos;
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength < 5) {
            int msgID2 = 6488249;
            invalidReason.append(MessageHandler.getMessage(msgID2, valueString));
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int msgID3 = 6488250;
            invalidReason.append(MessageHandler.getMessage(msgID3, valueString, Character.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            msgID = 6488251;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            msgID = 6488252;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = valueString.charAt(pos++))) {
            msgID = 6488250;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos - 1));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (!PrintableString.isPrintableCharacter(c)) {
                msgID = 6488251;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        if (pos >= valueLength) {
            msgID = 6488252;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = valueString.charAt(pos++))) {
            msgID = 6488250;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos - 1));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (!PrintableString.isPrintableCharacter(c)) {
                msgID = 6488251;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        return true;
    }
}

