/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeletexTerminalIdentifierSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    public static final HashSet<String> ALLOWED_TTX_PARAMETERS = new HashSet(5);
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "TeletexTerminalIdentifier");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "TeletexTerminalIdentifier");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "TeletexTerminalIdentifier");
        }
    }

    @Override
    public String getSyntaxName() {
        return "TeletexTerminalIdentifier";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.51";
    }

    @Override
    public String getDescription() {
        return "Teletex Terminal Identifier";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String paramName;
        int colonPos;
        String paramStr;
        int msgID;
        int pos;
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            int msgID2 = 6488259;
            invalidReason.append(MessageHandler.getMessage(msgID2));
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int msgID3 = 6488260;
            invalidReason.append(MessageHandler.getMessage(msgID3, valueString, Character.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            msgID = 6488260;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            if (c == '$') {
                msgID = 6488261;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                return false;
            }
            return true;
        }
        int paramStartPos = pos;
        boolean escaped = false;
        while (pos < valueLength) {
            if (escaped) {
                ++pos;
                continue;
            }
            if ((c = valueString.charAt(pos++)) == '\\') {
                escaped = true;
                continue;
            }
            if (c != '$') continue;
            paramStr = valueString.substring(paramStartPos, pos);
            colonPos = paramStr.indexOf(58);
            if (colonPos < 0) {
                int msgID4 = 6488262;
                invalidReason.append(MessageHandler.getMessage(msgID4, valueString, paramStr, paramStartPos));
                return false;
            }
            paramName = paramStr.substring(0, colonPos);
            if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
                int msgID5 = 6488263;
                invalidReason.append(MessageHandler.getMessage(msgID5, valueString, paramName));
                return false;
            }
            paramStartPos = pos;
        }
        paramStr = valueString.substring(paramStartPos);
        colonPos = paramStr.indexOf(58);
        if (colonPos < 0) {
            int msgID6 = 6488262;
            invalidReason.append(MessageHandler.getMessage(msgID6, valueString, paramStr, paramStartPos));
            return false;
        }
        paramName = paramStr.substring(0, colonPos);
        if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
            int msgID7 = 6488263;
            invalidReason.append(MessageHandler.getMessage(msgID7, valueString, paramName));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_TTX_PARAMETERS.add("graphic");
        ALLOWED_TTX_PARAMETERS.add("control");
        ALLOWED_TTX_PARAMETERS.add("misc");
        ALLOWED_TTX_PARAMETERS.add("page");
        ALLOWED_TTX_PARAMETERS.add("private");
    }
}

