/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableStringSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553601, "1.3.6.1.4.1.26027.1.4.1", "PrintableString");
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "PrintableString");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "PrintableString");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "PrintableString");
        }
    }

    @Override
    public String getSyntaxName() {
        return "PrintableString";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.44";
    }

    @Override
    public String getDescription() {
        return "Printable String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        if (value == null) {
            int msgID = 6422633;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            int msgID = 6422633;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (PrintableString.isPrintableCharacter(c)) continue;
            int msgID = 6422634;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), i));
            return false;
        }
        return true;
    }
}

