/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.server.admin.std.server.SubstringMatchingRuleCfg;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericStringSubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public void initializeMatchingRule(SubstringMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getName() {
        return "numericStringSubstringsMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.10";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        StringBuilder valueBuffer = new StringBuilder(valueLength);
        boolean logged = false;
        block4: for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (StaticUtils.isDigit(c)) {
                valueBuffer.append(c);
                continue;
            }
            if (c == ' ') continue;
            int msgID = 6422618;
            String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), i);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (logged) continue block4;
                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    logged = true;
                }
            }
        }
        return new ASN1OctetString(StaticUtils.getBytes(valueBuffer.toString()));
    }

    @Override
    public ByteString normalizeSubstring(ByteString substring) throws DirectoryException {
        String valueString = substring.stringValue();
        int valueLength = valueString.length();
        StringBuilder valueBuffer = new StringBuilder(valueLength);
        boolean logged = false;
        block4: for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (StaticUtils.isDigit(c)) {
                valueBuffer.append(c);
                continue;
            }
            if (c == ' ') continue;
            int msgID = 6422618;
            String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), i);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (logged) continue block4;
                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    logged = true;
                }
            }
        }
        return new ASN1OctetString(StaticUtils.getBytes(valueBuffer.toString()));
    }

    @Override
    public boolean valueMatchesSubstring(ByteString value, ByteString subInitial, List<ByteString> subAnyElements, ByteString subFinal) {
        int pos;
        byte[] valueBytes = value.value();
        int valueLength = valueBytes.length;
        if (subInitial != null) {
            byte[] initialBytes = subInitial.value();
            int initialLength = initialBytes.length;
            if (initialLength > valueLength) {
                return false;
            }
            for (pos = 0; pos < initialLength; ++pos) {
                if (initialBytes[pos] == valueBytes[pos]) continue;
                return false;
            }
        }
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            for (ByteString element : subAnyElements) {
                byte[] anyBytes = element.value();
                int anyLength = anyBytes.length;
                int end = valueLength - anyLength;
                boolean match = false;
                if (anyLength == 0) {
                    match = true;
                    continue;
                }
                while (pos <= end) {
                    if (anyBytes[0] == valueBytes[pos]) {
                        boolean subMatch = true;
                        for (int i = 1; i < anyLength; ++i) {
                            if (anyBytes[i] == valueBytes[pos + i]) continue;
                            subMatch = false;
                            break;
                        }
                        if (subMatch) {
                            match = subMatch;
                            break;
                        }
                    }
                    ++pos;
                }
                if (match) {
                    pos += anyLength;
                    continue;
                }
                return false;
            }
        }
        if (subFinal != null) {
            byte[] finalBytes = subFinal.value();
            int finalLength = finalBytes.length;
            if (valueLength - finalLength < pos) {
                return false;
            }
            pos = valueLength - finalLength;
            int i = 0;
            while (i < finalLength) {
                if (finalBytes[i] != valueBytes[pos]) {
                    return false;
                }
                ++i;
                ++pos;
            }
        }
        return true;
    }
}

