/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class NumericStringEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "numericStringMatch";
    }

    public String getOID() {
        return "2.5.13.8";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.36";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        StringBuilder valueBuffer = new StringBuilder(valueLength);
        boolean logged = false;
        block4: for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (StaticUtils.isDigit(c)) {
                valueBuffer.append(c);
                continue;
            }
            if (c == ' ') continue;
            int msgID = 6422618;
            String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), i);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (logged) continue block4;
                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    logged = true;
                }
            }
        }
        return new ASN1OctetString(StaticUtils.getBytes(valueBuffer.toString()));
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

