/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleUseSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            int msgID = 6553602;
            String message = MessageHandler.getMessage(msgID, "2.5.13.2", "MatchingRuleUseDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            int msgID = 6553603;
            String message = MessageHandler.getMessage(msgID, "2.5.13.3", "MatchingRuleUseDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            int msgID = 0x640004;
            String message = MessageHandler.getMessage(msgID, "2.5.13.4", "MatchingRuleUseDescription");
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public String getSyntaxName() {
        return "MatchingRuleUseDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.31";
    }

    @Override
    public String getDescription() {
        return "Matching Rule Use Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        try {
            MatchingRuleUseSyntax.decodeMatchingRuleUse(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getErrorMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MatchingRuleUse decodeMatchingRuleUse(ByteString value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            int msgID = 6488224;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            int msgID = 6488225;
            String message = MessageHandler.getMessage(msgID, valueStr, pos - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        int oidStartPos = pos;
        if (!StaticUtils.isDigit(c)) {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 6488229;
                String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488227;
                        String message = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int msgID = 6488228;
                    String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                lastWasPeriod = false;
            }
        }
        if (pos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        MatchingRule matchingRule = schema.getMatchingRule(oid);
        if (matchingRule == null) {
            int msgID = 6488230;
            String message = MessageHandler.getMessage(msgID, valueStr, oid);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String description = null;
        boolean isObsolete = false;
        LinkedHashSet attributes = null;
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block5: while (true) {
            LinkedList<AttributeType> attrs;
            block31: {
                AttributeType attr;
                StringBuilder woidBuffer;
                block37: {
                    StringBuilder lowerBuffer;
                    StringBuilder userBuffer;
                    block35: {
                        block33: {
                            String tokenName;
                            block36: {
                                String lowerTokenName;
                                block34: {
                                    String message;
                                    block32: {
                                        StringBuilder tokenNameBuffer = new StringBuilder();
                                        pos = MatchingRuleUseSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
                                        tokenName = tokenNameBuffer.toString();
                                        lowerTokenName = StaticUtils.toLowerCase(tokenName);
                                        if (!tokenName.equals(")")) break block32;
                                        if (pos < length) {
                                            int msgID = 6488231;
                                            message = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                                        }
                                        break block33;
                                    }
                                    if (!lowerTokenName.equals("name")) break block34;
                                    if ((c = valueStr.charAt(pos++)) == '\'') {
                                        userBuffer = new StringBuilder();
                                        lowerBuffer = new StringBuilder();
                                        pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                                        names.put(lowerBuffer.toString(), userBuffer.toString());
                                        continue;
                                    }
                                    if (c != '(') {
                                        int msgID = 6488232;
                                        message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                                    }
                                    break block35;
                                }
                                if (lowerTokenName.equals("desc")) {
                                    StringBuilder descriptionBuffer = new StringBuilder();
                                    pos = MatchingRuleUseSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                                    description = descriptionBuffer.toString();
                                    continue;
                                }
                                if (lowerTokenName.equals("obsolete")) {
                                    isObsolete = true;
                                    continue;
                                }
                                if (!lowerTokenName.equals("applies")) break block36;
                                attrs = new LinkedList<AttributeType>();
                                if ((c = valueStr.charAt(pos++)) == '(') break block37;
                                woidBuffer = new StringBuilder();
                                pos = MatchingRuleUseSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                attr = schema.getAttributeType(woidBuffer.toString());
                                if (attr == null) {
                                    if (!allowUnknownElements) {
                                        int msgID = 6488233;
                                        String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                    }
                                    attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                }
                                attrs.add(attr);
                                break block31;
                            }
                            LinkedList<String> valueList = new LinkedList<String>();
                            pos = MatchingRuleUseSyntax.readExtraParameterValues(valueStr, valueList, pos);
                            extraProperties.put(tokenName, valueList);
                            continue;
                        }
                        if (attributes == null) {
                            int msgID = 6488234;
                            String message = MessageHandler.getMessage(msgID, valueStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                        }
                        return new MatchingRuleUse(value.stringValue(), matchingRule, names, description, isObsolete, attributes, extraProperties);
                    }
                    userBuffer = new StringBuilder();
                    lowerBuffer = new StringBuilder();
                    pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block5;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        names.put(lowerBuffer.toString(), userBuffer.toString());
                    }
                }
                do {
                    woidBuffer = new StringBuilder();
                    pos = MatchingRuleUseSyntax.readWOID(lowerStr, woidBuffer, pos);
                    attr = schema.getAttributeType(woidBuffer.toString());
                    if (attr == null) {
                        if (!allowUnknownElements) {
                            int msgID = 6488233;
                            String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                        }
                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    }
                    attrs.add(attr);
                    c = valueStr.charAt(pos++);
                    if (c == ')') break block31;
                } while (c == '$');
                int msgID = 6488232;
                String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            attributes = new LinkedHashSet(attrs);
        }
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488235;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488235;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488227;
                        String message = MessageHandler.getMessage(msgID, lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    int msgID = 6488228;
                    String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                int msgID = 6488229;
                String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            int msgID = 6488232;
            String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    int msgID = 6488226;
                    String message = MessageHandler.getMessage(msgID, valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                if (c != ')') {
                    if (c == '(') {
                        int msgID = 6488232;
                        String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    startPos = MatchingRuleUseSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488226;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }
}

