/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSyntaxDescriptionSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "LDAPSyntaxDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "LDAPSyntaxDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "LDAPSyntaxDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        return "LDAPSyntaxDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.54";
    }

    @Override
    public String getDescription() {
        return "LDAP Syntax Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String tokenName;
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            int msgID = 6488156;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            int msgID = 6488157;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1, Character.valueOf(c)));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488158;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        int oidStartPos = pos;
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488159;
                        invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1));
                        return false;
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int msgID = 0x630060;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1));
                    return false;
                }
                lastWasPeriod = false;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 6488161;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1));
                return false;
            }
        }
        if (pos >= length) {
            int msgID = 6488158;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        String oid = lowerStr.substring(oidStartPos, pos);
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488158;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        if (c == ')') {
            if (pos < length) {
                int msgID = 6488162;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1));
                return false;
            }
            return true;
        }
        try {
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(lowerStr, tokenNameBuffer, pos);
            tokenName = tokenNameBuffer.toString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 0x630063;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos, StaticUtils.getExceptionMessage(e)));
            return false;
        }
        if (!tokenName.equals("desc")) {
            int msgID = 6488164;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, tokenName));
            return false;
        }
        try {
            StringBuilder descriptionBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 6488165;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos, StaticUtils.getExceptionMessage(e)));
            return false;
        }
        c = valueStr.charAt(pos);
        if (c != ')') {
            try {
                pos = LDAPSyntaxDescriptionSyntax.parseExtension(valueStr, pos);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 6488329;
                invalidReason.append(MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e)));
                return false;
            }
        }
        if ((c = valueStr.charAt(pos++)) != ')') {
            int msgID = 0x630066;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos, Character.valueOf(c)));
            return false;
        }
        while (pos < length) {
            if ((c = valueStr.charAt(pos++)) == ' ') continue;
            int msgID = 6488167;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos));
            return false;
        }
        return true;
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488158;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488158;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6422632;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488158;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int parseExtension(String valueStr, int startPos) throws DirectoryException {
        int pos = startPos;
        int len = valueStr.length();
        do {
            StringBuilder qdString;
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            if (tokenName.length() <= 2 || !tokenName.startsWith("X-")) {
                int msgID = 6488328;
                String message = MessageHandler.getMessage(msgID, valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            String xstring = tokenName.substring(2);
            if (xstring.split("^[A-Za-z_-]+").length > 0) {
                int msgID = 6488328;
                String message = MessageHandler.getMessage(msgID, valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            char c = valueStr.charAt(pos);
            if (c == '\'') {
                qdString = new StringBuilder();
                pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
            } else if (c == '(') {
                ++pos;
                qdString = new StringBuilder();
                while ((c = valueStr.charAt(pos)) != ')') {
                    pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
                }
                ++pos;
            } else {
                int msgID = 6488328;
                String message = MessageHandler.getMessage(msgID, valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            if (pos < len) continue;
            int msgID = 6488158;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        } while (valueStr.charAt(pos) != ')');
        return pos;
    }
}

