/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.17", "Guide");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.18", "Guide");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.19", "Guide");
        }
    }

    @Override
    public String getSyntaxName() {
        return "Guide";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.25";
    }

    @Override
    public String getDescription() {
        return "Guide";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.stringValue());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            return GuideSyntax.criteriaIsValid(valueStr, valueStr, invalidReason);
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            int msgID = 6488269;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(ocName, 0, ocLength, invalidReason)) {
            return false;
        }
        return GuideSyntax.criteriaIsValid(valueStr.substring(sharpPos + 1), valueStr, invalidReason);
    }

    public static boolean criteriaIsValid(String criteria, String valueStr, StringBuilder invalidReason) {
        int endPos;
        char c = criteria.charAt(0);
        if (c == '!') {
            return GuideSyntax.criteriaIsValid(criteria.substring(1), valueStr, invalidReason);
        }
        if (c == '(') {
            int length = criteria.length();
            int depth = 1;
            for (int i = 1; i < length; ++i) {
                c = criteria.charAt(i);
                if (c == ')') {
                    if (--depth != 0) continue;
                    String subCriteria = criteria.substring(1, i);
                    if (!GuideSyntax.criteriaIsValid(subCriteria, valueStr, invalidReason)) {
                        return false;
                    }
                    if (i == length - 1) {
                        return true;
                    }
                    c = criteria.charAt(i + 1);
                    if (c == '|' || c == '&') {
                        return GuideSyntax.criteriaIsValid(criteria.substring(i + 2), valueStr, invalidReason);
                    }
                    int msgID = 6488270;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, Character.valueOf(c), i + 1));
                    return false;
                }
                if (c != '(') continue;
                ++depth;
            }
            int msgID = 6488271;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria));
            return false;
        }
        if (c == '?') {
            if (criteria.startsWith("?true")) {
                if (criteria.length() == 5) {
                    return true;
                }
                c = criteria.charAt(5);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(criteria.substring(6), valueStr, invalidReason);
                }
                int msgID = 6488270;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, Character.valueOf(c), 5));
                return false;
            }
            if (criteria.startsWith("?false")) {
                if (criteria.length() == 6) {
                    return true;
                }
                c = criteria.charAt(6);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(criteria.substring(7), valueStr, invalidReason);
                }
                int msgID = 6488270;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, Character.valueOf(c), 6));
                return false;
            }
            int msgID = 6488272;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria));
            return false;
        }
        if (criteria.equals("true") || criteria.equals("false")) {
            return true;
        }
        int dollarPos = criteria.indexOf(36);
        if (dollarPos < 0) {
            int msgID = 6488273;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria));
            return false;
        }
        if (dollarPos == 0) {
            int msgID = 6488274;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria));
            return false;
        }
        if (dollarPos == criteria.length() - 1) {
            int msgID = 6488275;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(criteria, 0, dollarPos, invalidReason)) {
            return false;
        }
        c = criteria.charAt(dollarPos + 1);
        switch (c) {
            case 'e': {
                if (criteria.startsWith("eq", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 's': {
                if (criteria.startsWith("substr", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'g': {
                if (criteria.startsWith("ge", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'l': {
                if (criteria.startsWith("le", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'a': {
                if (criteria.startsWith("approx", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
            default: {
                int msgID = 6488276;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, dollarPos + 1));
                return false;
            }
        }
        if (endPos >= criteria.length()) {
            return true;
        }
        c = criteria.charAt(endPos);
        if (c == '|' || c == '&') {
            return GuideSyntax.criteriaIsValid(criteria.substring(endPos + 1), valueStr, invalidReason);
        }
        int msgID = 6488270;
        invalidReason.append(MessageHandler.getMessage(msgID, valueStr, criteria, Character.valueOf(c), endPos));
        return false;
    }
}

